/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.internal;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.project.examples.FavoriteItem;
import org.jboss.tools.project.examples.internal.IFavoriteSerializer;
import org.jboss.tools.project.examples.internal.model.JaxbParser;

public class FavoriteItemXmlSerializer
extends JaxbParser
implements IFavoriteSerializer {
    private File xmlFile;
    private static final JAXBContext jaxbContext;

    static {
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{FavoriteItemsWrapper.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    FavoriteItemXmlSerializer(File xmlFile) {
        this.xmlFile = xmlFile;
    }

    @Override
    public Collection<FavoriteItem> deSerialize() throws CoreException {
        Collection<FavoriteItem> items = null;
        try {
            if (this.xmlFile.isFile()) {
                FavoriteItemsWrapper wrapper = (FavoriteItemsWrapper)this.unmarshall(jaxbContext, this.xmlFile);
                items = wrapper.items;
            }
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.project.examples", "Unable to parse user example sites", (Throwable)e));
        }
        return items == null ? Collections.emptyList() : items;
    }

    @Override
    public void serialize(Collection<FavoriteItem> collection) throws CoreException {
        try {
            FavoriteItemsWrapper wrapper = new FavoriteItemsWrapper();
            wrapper.items = collection;
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            this.xmlFile.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(this.xmlFile);
            marshaller.marshal((Object)wrapper, (Writer)writer);
        }
        catch (Exception shouldntHappen) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.project.examples", "Unable to serialize favorite items", (Throwable)shouldntHappen));
        }
    }

    @XmlRootElement(name="favorites")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class FavoriteItemsWrapper {
        @XmlElement(name="favoriteItem", type=FavoriteItem.class)
        Collection<FavoriteItem> items;

        FavoriteItemsWrapper() {
        }
    }
}

