/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.internal.fixes;

import java.io.File;
import java.io.FilenameFilter;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.server.core.IRuntime;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;

class PortletRuntimeComponentProvider {
    public static final String IS_PORTLET_RUNTIME = "isPortletRuntime";

    PortletRuntimeComponentProvider() {
    }

    public static boolean isPortalPresent(File location, IRuntime runtime, String property) {
        IJBossServerRuntime jbossRuntime = (IJBossServerRuntime)runtime.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
        if (jbossRuntime != null) {
            IPath jbossLocation = runtime.getLocation();
            IPath configPath = jbossLocation.append("server").append(jbossRuntime.getJBossConfiguration());
            File configFile = configPath.toFile();
            if (PortletRuntimeComponentProvider.exists(configFile, "deploy/jboss-portal.sar")) {
                return true;
            }
            if (PortletRuntimeComponentProvider.exists(configFile, "deploy/jboss-portal-ha.sar")) {
                return true;
            }
            if (PortletRuntimeComponentProvider.exists(configFile, "deploy/simple-portal") || PortletRuntimeComponentProvider.exists(configFile, "deploy/simple-portal.sar")) {
                return true;
            }
            if (PortletRuntimeComponentProvider.exists(configFile, "deploy/gatein.ear")) {
                return true;
            }
            if (PortletRuntimeComponentProvider.exists(jbossLocation.toFile(), "standalone/deployments/gatein.ear")) {
                return true;
            }
            return PortletRuntimeComponentProvider.exists(jbossLocation.toFile(), "gatein/gatein.ear");
        }
        if (!IS_PORTLET_RUNTIME.equals(property)) {
            return false;
        }
        File tomcatLib = new File(location, "lib");
        if (tomcatLib.exists() && tomcatLib.isDirectory()) {
            String[] files = tomcatLib.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("portlet-api") && name.endsWith(".jar");
                }
            });
            return files.length > 0;
        }
        return false;
    }

    private static boolean exists(File location, String portalDir) {
        if (Platform.getOS().equals("win32")) {
            portalDir = portalDir.replace("/", "\\");
        }
        File file = new File(location, portalDir);
        return file.exists();
    }
}

