/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.wizard;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.dialogs.WorkingSetConfigurationBlock;
import org.jboss.tools.project.examples.internal.Messages;
import org.jboss.tools.project.examples.internal.ProjectExamplesActivator;
import org.jboss.tools.project.examples.model.ProjectExample;
import org.jboss.tools.project.examples.wizard.IProjectExamplesWizardPage;
import org.jboss.tools.project.examples.wizard.NewProjectExamplesWizard2;

public class NewProjectExamplesLocationPage
extends WizardPage {
    private static final String RESOURCE = "org.eclipse.ui.resourceWorkingSetPage";
    private static final String JAVA = "org.eclipse.jdt.ui.JavaWorkingSetPage";
    private Text outputDirectoryText;
    private Button isWorkspace;
    private WorkingSetGroup fWorkingSetGroup;
    private static final IWorkingSet[] EMPTY_WORKING_SET_ARRAY = new IWorkingSet[0];

    protected NewProjectExamplesLocationPage() {
        super("org.jboss.tools.project.examples.location");
        this.setTitle("Location");
        this.setDescription("Project Example Location and Workspace");
        this.fWorkingSetGroup = new WorkingSetGroup();
        this.setWorkingSets(new IWorkingSet[0]);
    }

    public void setWorkingSets(IWorkingSet[] workingSets) {
        if (workingSets == null) {
            throw new IllegalArgumentException();
        }
        this.fWorkingSetGroup.setWorkingSets(workingSets);
    }

    public IWorkingSet[] getWorkingSets() {
        return this.fWorkingSetGroup.getSelectedWorkingSets();
    }

    protected Control createWorkingSetControl(Composite composite) {
        return this.fWorkingSetGroup.createControl(composite);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(4, 4, false, false);
        composite.setLayoutData((Object)gd);
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
        Group outputDirectoryGroup = new Group(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        outputDirectoryGroup.setLayout((Layout)layout);
        outputDirectoryGroup.setText(Messages.ProjectExamplesPreferencePage_Output_directory);
        gd = new GridData(4, 4, true, false);
        outputDirectoryGroup.setLayoutData((Object)gd);
        this.isWorkspace = new Button((Composite)outputDirectoryGroup, 32);
        gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        this.isWorkspace.setLayoutData((Object)gd);
        this.isWorkspace.setText(Messages.ProjectExamplesPreferencePage_Use_default_workspace_location);
        this.isWorkspace.setSelection(ProjectExamplesActivator.getDefault().getPreferenceStore().getBoolean("projectExamplesDefaultLocation"));
        this.outputDirectoryText = new Text((Composite)outputDirectoryGroup, 2052);
        gd = new GridData(4, 4, true, false);
        gd.verticalAlignment = 0x1000000;
        this.outputDirectoryText.setLayoutData((Object)gd);
        IPreferenceStore store = ProjectExamplesActivator.getDefault().getPreferenceStore();
        String outputDirectoryValue = store.getString("projectExamplesOutputDirectory");
        if (outputDirectoryValue == null || outputDirectoryValue.isEmpty()) {
            IPath path = Platform.getLocation();
            outputDirectoryValue = path.toOSString();
        }
        this.outputDirectoryText.setText(outputDirectoryValue == null ? "" : outputDirectoryValue);
        final Button outputDirectoryBrowse = new Button((Composite)outputDirectoryGroup, 8);
        outputDirectoryBrowse.setText(Messages.Browse);
        outputDirectoryBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(NewProjectExamplesLocationPage.this.getShell(), 4);
                String value = NewProjectExamplesLocationPage.this.outputDirectoryText.getText();
                if (value.trim().length() == 0) {
                    value = Platform.getLocation().toOSString();
                }
                dialog.setFilterPath(value);
                String result = dialog.open();
                if (result == null || result.trim().length() == 0) {
                    return;
                }
                NewProjectExamplesLocationPage.this.outputDirectoryText.setText(result);
            }
        });
        this.enableControls(outputDirectoryBrowse);
        this.isWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String location;
                NewProjectExamplesLocationPage.this.enableControls(outputDirectoryBrowse);
                if (!NewProjectExamplesLocationPage.this.isWorkspace.getSelection() && !NewProjectExamplesLocationPage.this.validateLocation(location = NewProjectExamplesLocationPage.this.outputDirectoryText.getText().trim())) {
                    return;
                }
                NewProjectExamplesLocationPage.this.setPageComplete(true);
                NewProjectExamplesLocationPage.this.setErrorMessage(null);
                NewProjectExamplesLocationPage.this.setMessage(null);
                ProjectExamplesActivator.getDefault().getPreferenceStore().setValue("projectExamplesDefaultLocation", NewProjectExamplesLocationPage.this.isWorkspace.getSelection());
            }
        });
        this.outputDirectoryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String location;
                if (!NewProjectExamplesLocationPage.this.isWorkspace.getSelection() && !NewProjectExamplesLocationPage.this.validateLocation(location = NewProjectExamplesLocationPage.this.outputDirectoryText.getText().trim())) {
                    return;
                }
                ProjectExamplesActivator.getDefault().getPreferenceStore().setValue("projectExamplesOutputDirectory", NewProjectExamplesLocationPage.this.outputDirectoryText.getText());
                NewProjectExamplesLocationPage.this.setPageComplete(true);
                NewProjectExamplesLocationPage.this.setErrorMessage(null);
                NewProjectExamplesLocationPage.this.setMessage(null);
            }
        });
        Control workingSetControl = this.createWorkingSetControl(composite);
        workingSetControl.setLayoutData((Object)new GridData(768));
        this.setPageComplete(true);
    }

    private boolean canCreate(File file) {
        while (!file.exists()) {
            if ((file = file.getParentFile()) != null) continue;
            return false;
        }
        return file.canWrite();
    }

    public void init(IStructuredSelection selection, IWorkbenchPart activePart) {
        this.setWorkingSets(this.getSelectedWorkingSet(selection, activePart));
    }

    private IWorkingSet[] getSelectedWorkingSet(IStructuredSelection selection, IWorkbenchPart activePart) {
        IWorkingSet[] selected = this.getSelectedWorkingSet(selection);
        if (selected != null && selected.length > 0) {
            int i = 0;
            while (i < selected.length) {
                if (!NewProjectExamplesLocationPage.isValidWorkingSet(selected[i])) {
                    return EMPTY_WORKING_SET_ARRAY;
                }
                ++i;
            }
            return selected;
        }
        if (!(activePart instanceof PackageExplorerPart)) {
            return EMPTY_WORKING_SET_ARRAY;
        }
        PackageExplorerPart explorerPart = (PackageExplorerPart)activePart;
        if (explorerPart.getRootMode() == 1) {
            IWorkingSet filterWorkingSet = explorerPart.getFilterWorkingSet();
            if (filterWorkingSet == null) {
                return EMPTY_WORKING_SET_ARRAY;
            }
            if (!NewProjectExamplesLocationPage.isValidWorkingSet(filterWorkingSet)) {
                return EMPTY_WORKING_SET_ARRAY;
            }
            return new IWorkingSet[]{filterWorkingSet};
        }
        Object input = explorerPart.getViewPartInput();
        if (!(input instanceof IWorkingSet)) {
            return EMPTY_WORKING_SET_ARRAY;
        }
        IWorkingSet workingSet = (IWorkingSet)input;
        if (!NewProjectExamplesLocationPage.isValidWorkingSet(workingSet)) {
            return EMPTY_WORKING_SET_ARRAY;
        }
        return new IWorkingSet[]{workingSet};
    }

    private IWorkingSet[] getSelectedWorkingSet(IStructuredSelection selection) {
        if (!(selection instanceof ITreeSelection)) {
            return EMPTY_WORKING_SET_ARRAY;
        }
        ITreeSelection treeSelection = (ITreeSelection)selection;
        if (treeSelection.isEmpty()) {
            return EMPTY_WORKING_SET_ARRAY;
        }
        List elements = treeSelection.toList();
        if (elements.size() == 1) {
            Object element = elements.get(0);
            TreePath[] paths = treeSelection.getPathsFor(element);
            if (paths.length != 1) {
                return EMPTY_WORKING_SET_ARRAY;
            }
            TreePath path = paths[0];
            if (path.getSegmentCount() == 0) {
                return EMPTY_WORKING_SET_ARRAY;
            }
            Object candidate = path.getSegment(0);
            if (!(candidate instanceof IWorkingSet)) {
                return EMPTY_WORKING_SET_ARRAY;
            }
            IWorkingSet workingSetCandidate = (IWorkingSet)candidate;
            if (NewProjectExamplesLocationPage.isValidWorkingSet(workingSetCandidate)) {
                return new IWorkingSet[]{workingSetCandidate};
            }
            return EMPTY_WORKING_SET_ARRAY;
        }
        ArrayList<IWorkingSet> result = new ArrayList<IWorkingSet>();
        for (Object element : elements) {
            if (!(element instanceof IWorkingSet) || !NewProjectExamplesLocationPage.isValidWorkingSet((IWorkingSet)element)) continue;
            result.add((IWorkingSet)element);
        }
        return result.toArray(new IWorkingSet[result.size()]);
    }

    private static boolean isValidWorkingSet(IWorkingSet workingSet) {
        String id = workingSet.getId();
        if (!JAVA.equals(id) && !RESOURCE.equals(id)) {
            return false;
        }
        return !workingSet.isAggregateWorkingSet();
    }

    protected void enableControls(Button outputDirectoryBrowse) {
        this.outputDirectoryText.setEnabled(!this.isWorkspace.getSelection());
        outputDirectoryBrowse.setEnabled(!this.isWorkspace.getSelection());
    }

    public IWizardPage getNextPage() {
        ProjectExample projectExample;
        IWizard wizard = this.getWizard();
        if (wizard instanceof NewProjectExamplesWizard2 && (projectExample = ((NewProjectExamplesWizard2)wizard).getSelectedProjectExample()) != null && projectExample.getImportType() != null) {
            List<IProjectExamplesWizardPage> pages = ((NewProjectExamplesWizard2)wizard).getContributedPages("extra");
            for (IProjectExamplesWizardPage page : pages) {
                if (!projectExample.getImportType().equals(page.getProjectExampleType())) continue;
                return page;
            }
        }
        return null;
    }

    private boolean validateLocation(String location) {
        if (location.length() == 0) {
            this.setErrorMessage(null);
            this.setMessage("Enter a location for the project");
            this.setPageComplete(false);
            return false;
        }
        if (!Path.EMPTY.isValidPath(location)) {
            this.setErrorMessage("Invalid project contents directory");
            this.setPageComplete(false);
            return false;
        }
        IPath projectPath = Path.fromOSString((String)location);
        if (!projectPath.toFile().exists() && !this.canCreate(projectPath.toFile())) {
            this.setErrorMessage("Cannot create project content at the given external location.");
            this.setPageComplete(false);
            return false;
        }
        return true;
    }

    private final class WorkingSetGroup {
        private WorkingSetConfigurationBlock fWorkingSetBlock;

        public WorkingSetGroup() {
            String[] workingSetIds = new String[]{NewProjectExamplesLocationPage.JAVA, NewProjectExamplesLocationPage.RESOURCE};
            this.fWorkingSetBlock = new WorkingSetConfigurationBlock(workingSetIds, ProjectExamplesActivator.getDefault().getDialogSettings());
        }

        public Control createControl(Composite composite) {
            Group workingSetGroup = new Group(composite, 0);
            workingSetGroup.setFont(composite.getFont());
            workingSetGroup.setText("Working sets");
            workingSetGroup.setLayout((Layout)new GridLayout(1, false));
            this.fWorkingSetBlock.createContent((Composite)workingSetGroup);
            return workingSetGroup;
        }

        public void setWorkingSets(IWorkingSet[] workingSets) {
            this.fWorkingSetBlock.setWorkingSets(workingSets);
        }

        public IWorkingSet[] getSelectedWorkingSets() {
            return this.fWorkingSetBlock.getSelectedWorkingSets();
        }
    }
}

