/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.core;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jboss.tools.foundation.core.plugin.BaseCorePlugin;
import org.jboss.tools.foundation.core.plugin.log.IPluginLog;
import org.jboss.tools.foundation.core.plugin.log.StatusFactory;
import org.jboss.tools.runtime.core.internal.RuntimeCorePreferences;
import org.jboss.tools.runtime.core.internal.RuntimeExtensionManager;
import org.jboss.tools.runtime.core.model.DownloadRuntime;
import org.jboss.tools.runtime.core.model.IDownloadRuntimes;
import org.jboss.tools.runtime.core.model.IRuntimeDetector;
import org.osgi.framework.BundleContext;

public class RuntimeCoreActivator
extends BaseCorePlugin {
    public static final String PLUGIN_ID = "org.jboss.tools.runtime.core";
    private static RuntimeCoreActivator plugin;
    private BundleContext context;
    private IDownloadRuntimes downloader = null;
    private static final String ESB_DETECTOR_ID = "org.jboss.tools.runtime.handlers.EsbHandler";

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.context = context;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static RuntimeCoreActivator getDefault() {
        return plugin;
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    public IDownloadRuntimes getDownloader() {
        return this.downloader;
    }

    public void setDownloader(IDownloadRuntimes downloader) {
        this.downloader = downloader;
    }

    public IRuntimeDetector getEsbDetector() {
        return this.findRuntimeDetector(ESB_DETECTOR_ID);
    }

    public IRuntimeDetector findRuntimeDetector(String id) {
        return RuntimeExtensionManager.getDefault().findRuntimeDetector(id);
    }

    @Deprecated
    public Set<IRuntimeDetector> getDeclaredRuntimeDetectors() {
        return this.getRuntimeDetectors();
    }

    public synchronized Set<IRuntimeDetector> getRuntimeDetectors() {
        return RuntimeExtensionManager.getDefault().getRuntimeDetectors();
    }

    public void saveEnabledDetectors() {
        RuntimeCorePreferences.getDefault().saveDetectorEnablement();
    }

    public void saveEnabledDetectors(Set<IRuntimeDetector> allDetectors) {
        RuntimeCorePreferences.getDefault().saveDetectorEnablement(allDetectors);
    }

    public Map<String, DownloadRuntime> getDownloadRuntimes() {
        return RuntimeExtensionManager.getDefault().getDownloadRuntimes();
    }

    public Map<String, DownloadRuntime> getDownloadRuntimes(IProgressMonitor monitor) {
        return RuntimeExtensionManager.getDefault().getDownloadRuntimes(monitor);
    }

    public DownloadRuntime[] getDownloadRuntimeArray(IProgressMonitor monitor) {
        Map<String, DownloadRuntime> map = RuntimeExtensionManager.getDefault().getDownloadRuntimes(monitor);
        if (map == null) {
            return new DownloadRuntime[0];
        }
        Collection<DownloadRuntime> arr = map.values();
        return arr.toArray(new DownloadRuntime[arr.size()]);
    }

    public DownloadRuntime findDownloadRuntime(String id) {
        return RuntimeExtensionManager.getDefault().findDownloadRuntime(id);
    }

    public DownloadRuntime findDownloadRuntime(String id, IProgressMonitor monitor) {
        return RuntimeExtensionManager.getDefault().findDownloadRuntime(id, monitor);
    }

    public static IPluginLog pluginLog() {
        return RuntimeCoreActivator.getDefault().pluginLogInternal();
    }

    public static StatusFactory statusFactory() {
        return RuntimeCoreActivator.getDefault().statusFactoryInternal();
    }
}

