/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.core.extract;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.runtime.core.extract.IOverwrite;
import org.jboss.tools.runtime.core.extract.internal.IExtractUtility;
import org.jboss.tools.runtime.core.extract.internal.UntarGZUtility;
import org.jboss.tools.runtime.core.extract.internal.UntarUtility;
import org.jboss.tools.runtime.core.extract.internal.UnzipUtility;

public class ExtractUtility {
    private static final String ZIP_SUFFIX = "zip";
    private static final String TAR_SUFFIX = "tar";
    private static final String TAR_GZ_SUFFIX = "tar.gz";
    private static final String TGZ_SUFFIX = ".tgz";
    public static final int FORMAT_ZIP = 1;
    public static final int FORMAT_TAR = 2;
    public static final int FORMAT_TGZ = 3;
    private File file;
    private IExtractUtility util;

    public ExtractUtility(File file) {
        this.file = file;
        String name = file.getName().toLowerCase();
        if (name.endsWith(ZIP_SUFFIX)) {
            this.util = new UnzipUtility(file);
        } else if (name.endsWith(TAR_SUFFIX)) {
            this.util = new UntarUtility(file);
        } else if (name.endsWith(TAR_GZ_SUFFIX) || name.endsWith(TGZ_SUFFIX)) {
            this.util = new UntarGZUtility(file);
        }
    }

    public ExtractUtility(File file, int format) {
        this.file = file;
        switch (format) {
            case 1: {
                this.util = new UnzipUtility(file);
                break;
            }
            case 2: {
                this.util = new UntarUtility(file);
                break;
            }
            case 3: {
                this.util = new UntarGZUtility(file);
            }
        }
    }

    public File getOriginalFile() {
        return this.file;
    }

    public IStatus extract(File destination, IOverwrite overwriteQuery, IProgressMonitor monitor) {
        if (this.util != null) {
            try {
                return this.util.extract(destination, overwriteQuery, monitor);
            }
            catch (CoreException ce) {
                return new Status(4, "org.jboss.tools.runtime.core", "Error extracting file " + this.file.getAbsolutePath(), (Throwable)ce);
            }
        }
        return new Status(4, "org.jboss.tools.runtime.core", "Unable to discover how to extract file " + this.file.getAbsolutePath());
    }

    public String getExtractedRootFolder(IProgressMonitor monitor) throws CoreException {
        if (this.util != null) {
            return this.util.getRoot(monitor);
        }
        return null;
    }
}

