/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.core.util;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.jboss.tools.runtime.core.JBossRuntimeLocator;
import org.jboss.tools.runtime.core.RuntimeCoreActivator;
import org.jboss.tools.runtime.core.model.IRuntimeDetector;
import org.jboss.tools.runtime.core.model.RuntimeDefinition;
import org.jboss.tools.runtime.core.model.RuntimePath;

public class RuntimeInitializerUtil {
    public static void initializeRuntimesFromFolder(File directory, IProgressMonitor monitor) {
        if (directory != null && directory.isDirectory()) {
            RuntimePath runtimePath = new RuntimePath(directory.getAbsolutePath());
            List<RuntimeDefinition> runtimeDefinitions = RuntimeInitializerUtil.createRuntimeDefinitions(runtimePath, monitor);
            RuntimeInitializerUtil.initializeRuntimes(runtimeDefinitions);
        }
    }

    public static IStatus initializeRuntimes(List<RuntimeDefinition> runtimeDefinitions) {
        MultiStatus ms = new MultiStatus("org.jboss.tools.runtime.core", 0, "Unable to initialize some runtime paths.", null);
        for (RuntimeDefinition def : runtimeDefinitions) {
            IStatus child;
            boolean found = false;
            try {
                if (def.getDetector() != null) {
                    if (def.getDetector().isEnabled()) {
                        found |= def.getDetector().initializeRuntime(def);
                    }
                } else {
                    Set<IRuntimeDetector> detectors = RuntimeCoreActivator.getDefault().getRuntimeDetectors();
                    for (IRuntimeDetector detector : detectors) {
                        if (!detector.isEnabled()) continue;
                        found |= detector.initializeRuntime(def);
                    }
                }
            }
            catch (CoreException ce) {
                RuntimeCoreActivator.pluginLog().logError((Throwable)ce);
            }
            if (!found) {
                ms.add(RuntimeCoreActivator.statusFactory().errorStatus("All runtime detectors failed to initialize " + def.getName()));
            }
            if ((child = RuntimeInitializerUtil.initializeRuntimes(def.getIncludedRuntimeDefinitions())).isOK()) continue;
            ms.add(child);
        }
        return ms;
    }

    public static void createRuntimeDefinitions(RuntimePath[] runtimePaths, IProgressMonitor monitor) {
        HashSet<RuntimePath> set = new HashSet<RuntimePath>(Arrays.asList(runtimePaths));
        RuntimeInitializerUtil.createRuntimeDefinitions(set, monitor);
    }

    public static void createRuntimeDefinitions(Set<RuntimePath> runtimePaths, IProgressMonitor monitor) {
        int size = runtimePaths == null ? 0 : runtimePaths.size();
        monitor.beginTask("Searching for Runtimes", 1 + 100 * size);
        for (RuntimePath runtimePath : runtimePaths) {
            RuntimeInitializerUtil.createRuntimeDefinitions(runtimePath, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
        }
        monitor.worked(1);
        monitor.done();
    }

    public static List<RuntimeDefinition> createRuntimeDefinitions(RuntimePath runtimePath, IProgressMonitor monitor) {
        JBossRuntimeLocator locator = new JBossRuntimeLocator();
        List<RuntimeDefinition> runtimeDefinitions = locator.searchForRuntimes(runtimePath.getPath(), monitor);
        for (RuntimeDefinition runtimeDefinition : runtimeDefinitions) {
            runtimeDefinition.setRuntimePath(runtimePath);
        }
        RuntimeDefinition[] defs = runtimeDefinitions.toArray(new RuntimeDefinition[runtimeDefinitions.size()]);
        runtimePath.setRuntimeDefinitions(defs);
        return runtimeDefinitions;
    }
}

