/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.ui;

import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.foundation.core.plugin.AbstractTrace;
import org.jboss.tools.foundation.core.plugin.log.IPluginLog;
import org.jboss.tools.foundation.ui.plugin.BaseUIPlugin;
import org.jboss.tools.runtime.core.RuntimeCoreActivator;
import org.jboss.tools.runtime.core.model.IDownloadRuntimes;
import org.jboss.tools.runtime.core.model.IRuntimeDetector;
import org.jboss.tools.runtime.core.model.RuntimeDefinition;
import org.jboss.tools.runtime.core.model.RuntimeModel;
import org.jboss.tools.runtime.core.model.RuntimePath;
import org.jboss.tools.runtime.core.util.RuntimeModelUtil;
import org.jboss.tools.runtime.ui.RuntimeSharedImages;
import org.jboss.tools.runtime.ui.download.DownloadRuntimes;
import org.jboss.tools.runtime.ui.internal.Trace;
import org.jboss.tools.runtime.ui.internal.dialogs.RuntimeCheckboxTreeViewer;
import org.jboss.tools.runtime.ui.internal.dialogs.SearchRuntimePathDialog;
import org.osgi.framework.BundleContext;

public class RuntimeUIActivator
extends BaseUIPlugin {
    public static final String PLUGIN_ID = "org.jboss.tools.runtime.ui";
    private static RuntimeUIActivator plugin;
    private BundleContext context;
    private RuntimeModel runtimeModel;

    public BundleContext getBundleContext() {
        return this.context;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.context = context;
        RuntimeCoreActivator.getDefault().setDownloader((IDownloadRuntimes)new DownloadRuntimes());
        super.registerDebugOptionsListener(PLUGIN_ID, (AbstractTrace)new Trace(this), context);
    }

    public void stop(BundleContext context) throws Exception {
        this.saveRuntimePreferences();
        this.runtimeModel = null;
        plugin = null;
        super.stop(context);
    }

    public static RuntimeUIActivator getDefault() {
        return plugin;
    }

    public RuntimeModel getModel() {
        if (this.runtimeModel == null) {
            this.runtimeModel = new RuntimeModel(ConfigurationScope.INSTANCE.getNode(PLUGIN_ID));
        }
        return this.runtimeModel;
    }

    public static RuntimeCheckboxTreeViewer createRuntimeViewer(RuntimePath[] runtimePaths2, Composite composite, int heightHint) {
        return new RuntimeCheckboxTreeViewer(composite, runtimePaths2, heightHint);
    }

    public static RuntimeCheckboxTreeViewer createRuntimeViewer(Set<RuntimePath> runtimePaths2, Composite composite, int heightHint) {
        return new RuntimeCheckboxTreeViewer(composite, runtimePaths2, heightHint);
    }

    public static SearchRuntimePathDialog launchSearchRuntimePathDialog(Shell shell, RuntimePath[] runtimePaths, boolean needRefresh, int heightHint) {
        return SearchRuntimePathDialog.launchSearchRuntimePathDialog(shell, runtimePaths, needRefresh, heightHint);
    }

    public static IPluginLog pluginLog() {
        return RuntimeUIActivator.getDefault().pluginLogInternal();
    }

    public void saveRuntimePreferences() {
        this.getModel().saveRuntimePaths();
        RuntimeCoreActivator.getDefault().saveEnabledDetectors();
    }

    public RuntimeSharedImages getSharedImages() {
        return RuntimeSharedImages.getDefault();
    }

    public static RuntimeSharedImages sharedImages() {
        return RuntimeUIActivator.getDefault().getSharedImages();
    }

    @Deprecated
    public List<RuntimeDefinition> getServerDefinitions() {
        return RuntimeModelUtil.getRuntimeDefinitions((RuntimePath[])this.getModel().getRuntimePaths());
    }

    @Deprecated
    public Set<IRuntimeDetector> getRuntimeDetectors() {
        return RuntimeCoreActivator.getDefault().getRuntimeDetectors();
    }

    @Deprecated
    public static void setTimestamp(RuntimePath[] runtimePaths2) {
        RuntimeModelUtil.updateTimestamps((RuntimePath[])runtimePaths2);
    }

    @Deprecated
    public static boolean runtimeCreated(RuntimeDefinition runtimeDefinition) {
        return RuntimeModelUtil.verifyRuntimeDefinitionCreated((RuntimeDefinition)runtimeDefinition);
    }

    @Deprecated
    public static RuntimePath[] getRuntimePaths() {
        return RuntimeUIActivator.getDefault().getModel().getRuntimePaths();
    }
}

