/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.foundation.ui.xpl.taskwizard.WizardFragment;
import org.jboss.tools.runtime.core.model.DownloadRuntime;
import org.jboss.tools.runtime.ui.RuntimeUIActivator;
import org.jboss.tools.runtime.ui.wizard.IWorkflowProvider;

public class RuntimeUIExtensionManager {
    private static HashMap<String, WorkflowProviderWrapper> providerMap = null;

    public static WizardFragment[] createFragmentsForRuntime(DownloadRuntime dr) {
        RuntimeUIExtensionManager.ensureLoaded();
        ArrayList<WizardFragment> toReturn = new ArrayList<WizardFragment>();
        ArrayList<WorkflowProviderWrapper> vals = new ArrayList<WorkflowProviderWrapper>(providerMap.values());
        Collections.sort(vals, new Comparator<WorkflowProviderWrapper>(){

            @Override
            public int compare(WorkflowProviderWrapper o1, WorkflowProviderWrapper o2) {
                return o1.weight - o2.weight;
            }
        });
        for (WorkflowProviderWrapper pw : vals) {
            WizardFragment[] fragList;
            IWorkflowProvider p = pw.provider;
            if (!p.canProvideWorkflow(dr) || (fragList = p.createFragmentsForRuntime(dr)) == null) continue;
            toReturn.addAll(Arrays.asList(fragList));
        }
        return toReturn.toArray(new WizardFragment[toReturn.size()]);
    }

    private static void ensureLoaded() {
        if (providerMap != null) {
            return;
        }
        providerMap = new HashMap();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.jboss.tools.runtime.ui", "workflowProvider");
        int i = 0;
        while (i < cf.length) {
            try {
                String id = cf[i].getAttribute("id");
                String weight = cf[i].getAttribute("weight");
                int weight2 = 100;
                try {
                    weight2 = Integer.parseInt(weight);
                }
                catch (NumberFormatException nfe) {
                    RuntimeUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.runtime.ui", nfe.getMessage(), (Throwable)nfe));
                }
                Object o = cf[i].createExecutableExtension("class");
                WorkflowProviderWrapper wrap = new WorkflowProviderWrapper(id, (IWorkflowProvider)o, weight2);
                providerMap.put(id, wrap);
            }
            catch (CoreException ce) {
                RuntimeUIActivator.getDefault().getLog().log(ce.getStatus());
            }
            ++i;
        }
    }

    private static class WorkflowProviderWrapper {
        String id;
        IWorkflowProvider provider;
        int weight;

        public WorkflowProviderWrapper(String id, IWorkflowProvider provider, int weight) {
            this.id = id;
            this.provider = provider;
            this.weight = weight;
        }
    }
}

