/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.ui.internal.dialogs;

import java.io.File;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.runtime.core.model.RuntimeDefinition;
import org.jboss.tools.runtime.core.model.RuntimeDetectionProblem;
import org.jboss.tools.runtime.ui.RuntimeSharedImages;

public class RuntimeLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 3 && element instanceof RuntimeDefinition) {
            RuntimeDefinition definition = (RuntimeDefinition)element;
            RuntimeDetectionProblem[] s = definition.getProblems();
            int maxError = 0;
            int i = 0;
            while (i < s.length) {
                maxError = maxError > s[i].getSeverity() ? maxError : s[i].getSeverity();
                ++i;
            }
            if (maxError == 2) {
                return RuntimeSharedImages.getImage("/icons/xpl/quickfix_warning_obj.gif");
            }
            if (maxError == 4) {
                return RuntimeSharedImages.getImage("/icons/xpl/quickfix_error_obj.gif");
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof RuntimeDefinition) {
            File location;
            RuntimeDefinition definition = (RuntimeDefinition)element;
            if (columnIndex == 0) {
                return definition.getName();
            }
            if (columnIndex == 1) {
                return definition.getType();
            }
            if (columnIndex == 2) {
                return definition.getVersion();
            }
            if (columnIndex == 4 && (location = definition.getLocation()) != null) {
                return definition.getLocation().getAbsolutePath();
            }
            if (columnIndex == 3) {
                RuntimeDetectionProblem[] all = definition.getProblems();
                StringBuilder sb = new StringBuilder();
                int warnCount = 0;
                int errorCount = 0;
                int i = 0;
                while (i < all.length) {
                    if (all[i].getSeverity() == 2) {
                        ++warnCount;
                    } else if (all[i].getSeverity() == 4) {
                        ++errorCount;
                    }
                    ++i;
                }
                if (errorCount > 0) {
                    sb.append(errorCount);
                    sb.append(" error");
                    if (errorCount > 1) {
                        sb.append("s");
                    }
                    if (warnCount > 0) {
                        sb.append(", ");
                    }
                }
                if (warnCount > 0) {
                    sb.append(warnCount);
                    sb.append(" warning");
                    if (warnCount > 1) {
                        sb.append("s");
                    }
                }
                return sb.toString();
            }
        }
        return null;
    }
}

