/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.ui.internal.preferences;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.jboss.tools.foundation.ui.xpl.taskwizard.TaskWizardDialog;
import org.jboss.tools.runtime.core.RuntimeCoreActivator;
import org.jboss.tools.runtime.core.model.IRuntimeDetector;
import org.jboss.tools.runtime.core.model.IRuntimePathChangeListener;
import org.jboss.tools.runtime.core.model.RuntimePath;
import org.jboss.tools.runtime.ui.RuntimeSharedImages;
import org.jboss.tools.runtime.ui.RuntimeUIActivator;
import org.jboss.tools.runtime.ui.internal.Messages;
import org.jboss.tools.runtime.ui.internal.RuntimeWorkbenchUtils;
import org.jboss.tools.runtime.ui.internal.dialogs.AutoResizeTableLayout;
import org.jboss.tools.runtime.ui.internal.dialogs.EditRuntimePathDialog;
import org.jboss.tools.runtime.ui.internal.dialogs.FastProgressMonitorFocusJobDialog;
import org.jboss.tools.runtime.ui.internal.dialogs.RuntimePathEditingSupport;
import org.jboss.tools.runtime.ui.internal.dialogs.SearchRuntimePathDialog;
import org.jboss.tools.runtime.ui.internal.wizard.DownloadRuntimesWizard;

public class RuntimePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static String ID = "org.jboss.tools.runtime.preferences.RuntimePreferencePage";
    private RuntimePath[] runtimePaths = new RuntimePath[0];
    private boolean isDirty;
    private TableViewer runtimePathViewer;
    private RuntimePath runtimePath;
    private Set<IRuntimeDetector> runtimeDetectors;
    private TableViewer detectorViewer;
    private Button searchButton;
    private Button downloadButton;
    private IRuntimePathChangeListener runtimePathChangeListener;

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)layout);
        Group pathsGroup = this.createGroup(composite, 1);
        pathsGroup.setText(Messages.RuntimePreferencePage_Description);
        Label pathsDescription = new Label((Composite)pathsGroup, 0);
        pathsDescription.setText(Messages.RuntimePreferencePage_Each_path_on_this_list);
        Group pathsTableGroup = this.createGroup(composite, 2);
        ((GridData)pathsTableGroup.getLayoutData()).widthHint = 100;
        pathsTableGroup.setText(Messages.RuntimePreferencePage_Paths);
        this.runtimePathViewer = this.createRuntimePathViewer((Composite)pathsTableGroup);
        Group detectorGroup = this.createGroup(composite, 1);
        detectorGroup.setText(Messages.RuntimePreferencePage_Available_runtime_detectors);
        this.detectorViewer = this.createDetectorViewer((Composite)detectorGroup);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private Group createGroup(Composite composite, int column) {
        Group group = new Group(composite, 0);
        GridData gd = new GridData(4, 4, true, false);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(column, false);
        group.setLayout((Layout)layout);
        return group;
    }

    private TableViewer createDetectorViewer(Composite parent) {
        final CheckboxTableViewer tableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2564);
        Table table = tableViewer.getTable();
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        table.setLayoutData((Object)gd);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        String[] columnNames = new String[]{Messages.RuntimePreferencePage_Type, Messages.RuntimePreferencePage_Link};
        int i = 0;
        while (i < columnNames.length) {
            TableColumn tc = new TableColumn(table, 16384);
            tc.setText(columnNames[i]);
            ++i;
        }
        ColumnLayoutData[] layouts = new ColumnLayoutData[]{new ColumnWeightData(300, 300), new ColumnWeightData(100, 50)};
        TableLayout layout = new TableLayout();
        int i2 = 0;
        while (i2 < layouts.length) {
            layout.addColumnData(layouts[i2]);
            ++i2;
        }
        table.setLayout((Layout)layout);
        tableViewer.setLabelProvider((IBaseLabelProvider)new RuntimeDetectorLabelProvider());
        tableViewer.setContentProvider((IContentProvider)new RuntimeDetectorContentProvider(this.runtimeDetectors));
        tableViewer.setInput(this.runtimeDetectors);
        for (IRuntimeDetector detector : this.runtimeDetectors) {
            tableViewer.setChecked((Object)detector, detector.isEnabled());
        }
        tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                IRuntimeDetector detector = (IRuntimeDetector)event.getElement();
                if (detector.isValid()) {
                    detector.setEnabled(!detector.isEnabled());
                } else {
                    MessageDialog.openWarning((Shell)RuntimePreferencePage.this.getShell(), (String)Messages.RuntimePreferencePage_Information, (String)NLS.bind((String)Messages.RuntimePreferencePage_Detector_is_invalid, (Object)detector.getName()));
                    tableViewer.setChecked((Object)detector, false);
                }
            }
        });
        i = 0;
        while (i < this.runtimeDetectors.size()) {
            TableItem item = table.getItem(i);
            Object data = item.getData();
            if (data instanceof IRuntimeDetector) {
                IRuntimeDetector detector = (IRuntimeDetector)data;
                final String preferenceId = detector.getPreferenceId();
                final String prefName = detector.getName();
                if (preferenceId != null && preferenceId.trim().length() > 0) {
                    Link link = new Link((Composite)table, 0);
                    link.setText(Messages.RuntimePreferencePage_A_Link_a);
                    link.setEnabled(detector.isValid());
                    TableEditor editor = new TableEditor(table);
                    editor.grabVertical = true;
                    editor.grabHorizontal = true;
                    editor.setEditor((Control)link, item, 1);
                    link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            boolean switchPage = true;
                            if (RuntimePreferencePage.this.isDirty) {
                                switchPage = MessageDialog.open((int)3, (Shell)RuntimePreferencePage.this.getShell(), (String)NLS.bind((String)Messages.RuntimePreferencePage_Open_preferences, (Object)prefName), (String)NLS.bind((String)Messages.RuntimePreferencePage_You_have_unsaved_changes, (Object)prefName), (int)0);
                            }
                            if (switchPage) {
                                if (RuntimePreferencePage.this.isDirty) {
                                    RuntimePreferencePage.this.performOk();
                                    RuntimeWorkbenchUtils.refreshPreferencePageUIThread(RuntimePreferencePage.this.getShell(), preferenceId);
                                } else {
                                    PreferencesUtil.createPreferenceDialogOn((Shell)RuntimePreferencePage.this.getShell(), (String)preferenceId, null, null);
                                }
                            }
                        }
                    });
                }
            }
            ++i;
        }
        return tableViewer;
    }

    private TableViewer createRuntimePathViewer(Composite parent) {
        final TableViewer viewer = new TableViewer(parent, 68356);
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        viewer.getTable().setLayoutData((Object)gd);
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setFont(parent.getFont());
        viewer.setContentProvider((IContentProvider)new RuntimePathContentProvider());
        String[] columnHeaders = new String[]{Messages.RuntimePreferencePage_Path, Messages.RuntimePreferencePage_Every_start};
        int i = 0;
        while (i < columnHeaders.length) {
            TableViewerColumn column = new TableViewerColumn(viewer, 0);
            column.setLabelProvider((CellLabelProvider)new RuntimePathLabelProvider(i));
            column.getColumn().setText(columnHeaders[i]);
            column.getColumn().setResizable(true);
            column.getColumn().setMoveable(true);
            column.setEditingSupport((EditingSupport)new RuntimePathEditingSupport((ColumnViewer)viewer, i));
            ++i;
        }
        ColumnLayoutData[] runtimePathsLayouts = new ColumnLayoutData[]{new ColumnWeightData(150, 150), new ColumnWeightData(60, 60)};
        AutoResizeTableLayout layout = new AutoResizeTableLayout(table);
        int i2 = 0;
        while (i2 < runtimePathsLayouts.length) {
            layout.addColumnData(runtimePathsLayouts[i2]);
            ++i2;
        }
        viewer.getTable().setLayout((Layout)layout);
        this.configureViewer(viewer);
        viewer.setInput((Object)this.runtimePaths);
        this.createRuntimePathsButtons(parent, viewer);
        this.runtimePathChangeListener = new IRuntimePathChangeListener(){

            public void changed() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (RuntimePreferencePage.this.runtimePathChangeListener != null) {
                            RuntimePreferencePage.this.runtimePaths = RuntimeUIActivator.getDefault().getModel().getRuntimePaths();
                            viewer.refresh();
                        }
                    }
                });
            }
        };
        RuntimeUIActivator.getDefault().getModel().addRuntimePathChangeListener(this.runtimePathChangeListener);
        return viewer;
    }

    private void configureViewer(final TableViewer viewer) {
        TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(viewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)viewer));
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                ViewerCell cell = viewer.getColumnViewerEditor().getFocusCell();
                if (cell != null && cell.getColumnIndex() == 1) {
                    return super.isEditorActivationEvent(event);
                }
                return event.eventType == 5 || event.eventType == 3 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        TableViewerEditor.create((TableViewer)viewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
    }

    private void createRuntimePathsButtons(Composite parent, final TableViewer viewer) {
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        buttonComposite.setLayoutData((Object)new GridData(4, 128, false, false));
        Button addButton = new Button(buttonComposite, 8);
        addButton.setLayoutData((Object)new GridData(768));
        addButton.setText(Messages.RuntimePreferencePage_Add);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuntimePreferencePage.this.addPressed();
            }
        });
        final Button editButton = new Button(buttonComposite, 8);
        editButton.setLayoutData((Object)new GridData(768));
        editButton.setText(Messages.RuntimePreferencePage_Edit);
        editButton.setEnabled(false);
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuntimePreferencePage.this.editPressed();
            }
        });
        final Button removeButton = new Button(buttonComposite, 8);
        removeButton.setLayoutData((Object)new GridData(768));
        removeButton.setText(Messages.RuntimePreferencePage_Remove);
        removeButton.setEnabled(false);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuntimePreferencePage.this.removedPressed();
            }
        });
        this.searchButton = new Button(buttonComposite, 8);
        this.searchButton.setLayoutData((Object)new GridData(768));
        this.searchButton.setText(Messages.RuntimePreferencePage_Search);
        this.searchButton.setEnabled(this.runtimePaths.length > 0);
        this.searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchRuntimePathDialog.launchSearchRuntimePathDialog(RuntimePreferencePage.this.getShell(), RuntimePreferencePage.this.runtimePaths, false, 15);
            }
        });
        this.downloadButton = new Button(buttonComposite, 8);
        this.downloadButton.setLayoutData((Object)new GridData(768));
        this.downloadButton.setText(Messages.RuntimePreferencePage_Download);
        this.downloadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean switchPage = true;
                if (RuntimePreferencePage.this.isDirty) {
                    switchPage = MessageDialog.open((int)3, (Shell)RuntimePreferencePage.this.getShell(), (String)Messages.RuntimePreferencePage_Open_download_wizard, (String)Messages.RuntimePreferencePage_You_have_unsaved_changes2, (int)0);
                }
                if (switchPage) {
                    if (RuntimePreferencePage.this.isDirty) {
                        RuntimePreferencePage.this.performOk();
                    }
                    Shell sh = PlatformUI.getWorkbench().getModalDialogShellProvider().getShell();
                    DownloadRuntimesWizard wizard = new DownloadRuntimesWizard(sh);
                    TaskWizardDialog dialog = new TaskWizardDialog(RuntimePreferencePage.this.getShell(), (IWizard)wizard);
                    dialog.open();
                    Job downloadJob = (Job)wizard.getTaskModel().getObject("dl.runtime.downloadJob");
                    if (downloadJob != null) {
                        RuntimePreferencePage.this.fireProgressDialog(downloadJob);
                    }
                }
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel = viewer.getSelection();
                if (sel instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)sel;
                    Object object = selection.getFirstElement();
                    editButton.setEnabled(object instanceof RuntimePath);
                    removeButton.setEnabled(object instanceof RuntimePath);
                } else {
                    editButton.setEnabled(false);
                    removeButton.setEnabled(false);
                }
            }
        });
    }

    private void fireProgressDialog(final Job downloadJob) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = RuntimePreferencePage.this.getShell();
                if (shell == null || shell.isDisposed()) {
                    shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                }
                try {
                    new FastProgressMonitorFocusJobDialog(shell).run(true, true, downloadJob);
                }
                catch (InvocationTargetException e) {
                    RuntimeUIActivator.pluginLog().logError((Throwable)e);
                }
                catch (InterruptedException e) {
                    RuntimeUIActivator.pluginLog().logError((Throwable)e);
                }
            }
        });
    }

    private void addPressed() {
        IDialogSettings dialogSettings = RuntimeUIActivator.getDefault().getDialogSettings();
        String lastUsedPath = dialogSettings.get("lastPath");
        if (lastUsedPath == null) {
            lastUsedPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        }
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setMessage(Messages.RuntimePreferencePage_Add_a_new_path);
        dialog.setFilterPath(lastUsedPath);
        String path = dialog.open();
        if (path == null) {
            return;
        }
        dialogSettings.put("lastPath", path);
        final RuntimePath runtimePath = new RuntimePath(path);
        boolean exists = Arrays.asList(this.runtimePaths).contains(runtimePath);
        if (exists) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.RuntimePreferencePage_Add_Runtime_Path, (String)Messages.RuntimePreferencePage_This_runtime_path_already_exists);
            return;
        }
        final SearchRuntimePathDialog d = SearchRuntimePathDialog.launchSearchRuntimePathDialog(this.getShell(), new RuntimePath[]{runtimePath}, false, 15);
        Shell s1 = d.getShell();
        d.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (d.getReturnCode() == 0 && d.getAddPath()) {
                    RuntimePath[] newRuntimePaths = new RuntimePath[RuntimePreferencePage.this.runtimePaths.length + 1];
                    System.arraycopy(RuntimePreferencePage.this.runtimePaths, 0, newRuntimePaths, 0, RuntimePreferencePage.this.runtimePaths.length);
                    newRuntimePaths[((RuntimePreferencePage)RuntimePreferencePage.this).runtimePaths.length] = runtimePath;
                    RuntimePreferencePage.this.runtimePaths = newRuntimePaths;
                    RuntimePreferencePage.this.runtimePathViewer.setInput((Object)RuntimePreferencePage.this.runtimePaths);
                    RuntimePreferencePage.this.configureSearch();
                    RuntimePreferencePage.this.runtimePathViewer.refresh();
                    RuntimePreferencePage.this.isDirty = true;
                }
            }
        });
    }

    private void removedPressed() {
        IStructuredSelection selection;
        Object object;
        ISelection sel = this.runtimePathViewer.getSelection();
        if (sel instanceof IStructuredSelection && (object = (selection = (IStructuredSelection)sel).getFirstElement()) instanceof RuntimePath) {
            RuntimePath[] newRuntimePaths = new RuntimePath[this.runtimePaths.length - 1];
            ArrayList<RuntimePath> l = new ArrayList<RuntimePath>(Arrays.asList(this.runtimePaths));
            l.remove(object);
            int i = 0;
            for (RuntimePath path : l) {
                newRuntimePaths[i++] = path;
            }
            this.runtimePaths = newRuntimePaths;
            this.runtimePathViewer.setInput((Object)this.runtimePaths);
            this.configureSearch();
            this.runtimePathViewer.refresh();
            this.isDirty = true;
        }
    }

    private void editPressed() {
        IStructuredSelection selection;
        Object object;
        ISelection sel = this.runtimePathViewer.getSelection();
        if (sel instanceof IStructuredSelection && (object = (selection = (IStructuredSelection)sel).getFirstElement()) instanceof RuntimePath) {
            RuntimePath runtimePathClone;
            this.runtimePath = (RuntimePath)object;
            try {
                runtimePathClone = (RuntimePath)this.runtimePath.clone();
            }
            catch (CloneNotSupportedException e1) {
                RuntimeUIActivator.pluginLog().logError((Throwable)e1);
                runtimePathClone = this.runtimePath;
            }
            EditRuntimePathDialog dialog = new EditRuntimePathDialog(this.getShell(), runtimePathClone);
            int ok = dialog.open();
            if (ok == 0) {
                if (this.runtimePath.equals((Object)runtimePathClone)) {
                    return;
                }
                if (Arrays.asList(this.runtimePaths).contains(runtimePathClone)) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.RuntimePreferencePage_Edit_Runtime_path, (String)Messages.RuntimePreferencePage_This_runtime_path_already_exists);
                    return;
                }
                ArrayList<RuntimePath> l = new ArrayList<RuntimePath>(Arrays.asList(this.runtimePaths));
                l.remove(this.runtimePath);
                this.runtimePath = runtimePathClone;
                l.add(this.runtimePath);
                this.runtimePaths = l.toArray(new RuntimePath[l.size()]);
                this.configureSearch();
                this.runtimePathViewer.refresh();
                this.isDirty = true;
            }
        }
    }

    public void init(IWorkbench workbench) {
        this.isDirty = false;
        RuntimePath[] tempPaths = RuntimeUIActivator.getDefault().getModel().getRuntimePaths();
        this.runtimePaths = new RuntimePath[tempPaths.length];
        int i = 0;
        while (i < tempPaths.length) {
            try {
                this.runtimePaths[i] = (RuntimePath)tempPaths[i].clone();
            }
            catch (CloneNotSupportedException e) {
                RuntimeUIActivator.pluginLog().logError((Throwable)e);
            }
            ++i;
        }
        this.runtimeDetectors = RuntimeCoreActivator.getDefault().getRuntimeDetectors();
    }

    public void dispose() {
        RuntimeUIActivator.getDefault().getModel().removeRuntimePathChangeListener(this.runtimePathChangeListener);
        this.runtimePathChangeListener = null;
        super.dispose();
    }

    public static int getButtonWidthHint(Button button) {
        button.setFont(JFaceResources.getDialogFont());
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static void setButtonDimensionHint(Button button) {
        Assert.isNotNull((Object)button);
        Object gd = button.getLayoutData();
        if (gd instanceof GridData) {
            ((GridData)gd).widthHint = RuntimePreferencePage.getButtonWidthHint(button);
            ((GridData)gd).horizontalAlignment = 4;
        }
    }

    protected void performApply() {
        RuntimeUIActivator.getDefault().getModel().setRuntimePaths(this.runtimePaths);
        RuntimeUIActivator.getDefault().saveRuntimePreferences();
        super.performApply();
        this.isDirty = false;
    }

    protected void performDefaults() {
        this.isDirty = false;
        this.runtimePaths = RuntimeUIActivator.getDefault().getModel().getRuntimePaths();
        this.runtimeDetectors = RuntimeCoreActivator.getDefault().getRuntimeDetectors();
        this.runtimePathViewer.setInput((Object)this.runtimePaths);
        this.detectorViewer.setInput(this.runtimeDetectors);
        super.performDefaults();
    }

    public boolean performOk() {
        RuntimeUIActivator.getDefault().getModel().setRuntimePaths(this.runtimePaths);
        RuntimeUIActivator.getDefault().saveRuntimePreferences();
        boolean ret = super.performOk();
        this.isDirty = false;
        return ret;
    }

    private void configureSearch() {
        if (this.searchButton != null) {
            this.searchButton.setEnabled(this.runtimePaths.length > 0);
        }
    }

    private static class RuntimeDetectorContentProvider
    implements IStructuredContentProvider {
        private Set<IRuntimeDetector> detectors;

        public RuntimeDetectorContentProvider(Set<IRuntimeDetector> detectors) {
            this.detectors = detectors;
        }

        public Object[] getElements(Object inputElement) {
            return this.detectors.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.detectors = (Set)newInput;
        }
    }

    private static class RuntimeDetectorLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private RuntimeDetectorLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IRuntimeDetector) {
                IRuntimeDetector detector = (IRuntimeDetector)element;
                if (columnIndex == 0) {
                    return detector.getName();
                }
            }
            return null;
        }
    }

    class RuntimePathContentProvider
    implements IStructuredContentProvider {
        RuntimePathContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return RuntimePreferencePage.this.runtimePaths;
        }

        public void dispose() {
        }
    }

    public static class RuntimePathLabelProvider
    extends ColumnLabelProvider {
        private int columnIndex;

        public RuntimePathLabelProvider(int i) {
            this.columnIndex = i;
        }

        public String getText(Object element) {
            if (element instanceof RuntimePath) {
                RuntimePath runtimePath = (RuntimePath)element;
                switch (this.columnIndex) {
                    case 0: {
                        return runtimePath.getPath();
                    }
                }
            }
            return null;
        }

        public Image getImage(Object element) {
            String path;
            if (element == null) {
                return null;
            }
            RuntimePath runtimePath = (RuntimePath)element;
            if (this.columnIndex == 1) {
                if (runtimePath.isScanOnEveryStartup()) {
                    return RuntimeSharedImages.getImage("checkbox_on");
                }
                return RuntimeSharedImages.getImage("checkbox_off");
            }
            if (!(this.columnIndex != 0 || (path = runtimePath.getPath()) != null && new File(path).isDirectory())) {
                return RuntimeSharedImages.getImage("error_image");
            }
            return null;
        }
    }
}

