/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.foundation.core.tasks.TaskModel;
import org.jboss.tools.foundation.ui.xpl.taskwizard.TaskWizard;
import org.jboss.tools.foundation.ui.xpl.taskwizard.WizardFragment;
import org.jboss.tools.runtime.core.RuntimeCoreActivator;
import org.jboss.tools.runtime.core.model.DownloadRuntime;
import org.jboss.tools.runtime.core.model.IDownloadRuntimeFilter;
import org.jboss.tools.runtime.core.model.IDownloadRuntimeWorkflowConstants;
import org.jboss.tools.runtime.ui.internal.Messages;
import org.jboss.tools.runtime.ui.internal.wizard.DownloadRuntimeLicenseFragment;
import org.jboss.tools.runtime.ui.internal.wizard.FinalizeRuntimeDownloadFragment;
import org.jboss.tools.runtime.ui.internal.wizard.SelectDownloadRuntimeFragment;

public class DownloadRuntimesTaskWizard
extends TaskWizard
implements IDownloadRuntimeWorkflowConstants {
    public DownloadRuntimesTaskWizard() {
        this(new String[0], new String[0]);
    }

    private DownloadRuntimesTaskWizard(Map<String, DownloadRuntime> downloadRuntime) {
        this(new String[0], new String[0], downloadRuntime);
    }

    public DownloadRuntimesTaskWizard(IDownloadRuntimeFilter filter) {
        this(DownloadRuntimesTaskWizard.dlRuntimeMapFromFilter(filter));
    }

    public DownloadRuntimesTaskWizard(List<DownloadRuntime> runtimes) {
        this(DownloadRuntimesTaskWizard.dlRuntimeMapFromList(runtimes));
    }

    private static Map<String, DownloadRuntime> dlRuntimeMapFromList(List<DownloadRuntime> runtimes) {
        HashMap<String, DownloadRuntime> downloadRuntimes = new HashMap<String, DownloadRuntime>();
        if (runtimes == null) {
            return downloadRuntimes;
        }
        for (DownloadRuntime runtime : runtimes) {
            downloadRuntimes.put(runtime.getId(), runtime);
        }
        return downloadRuntimes;
    }

    private static HashMap<String, DownloadRuntime> dlRuntimeMapFromFilter(IDownloadRuntimeFilter filter) {
        return DownloadRuntimesTaskWizard.dlRuntimeMapFromFilter(filter, DownloadRuntimesTaskWizard.safeFetchDownloadRuntimes(null));
    }

    private static HashMap<String, DownloadRuntime> dlRuntimeMapFromFilter(IDownloadRuntimeFilter filter, Map<String, DownloadRuntime> downloadRuntimes) {
        HashMap<String, DownloadRuntime> tmp = new HashMap<String, DownloadRuntime>();
        for (String k : downloadRuntimes.keySet()) {
            DownloadRuntime v = downloadRuntimes.get(k);
            if (!filter.accepts(v)) continue;
            tmp.put(k, v);
        }
        return tmp;
    }

    public DownloadRuntimesTaskWizard(String[] ids, String[] values) {
        this(ids, values, null);
    }

    public DownloadRuntimesTaskWizard(String[] ids, String[] values, final Map<String, DownloadRuntime> downloadRuntimes) {
        super(Messages.DownloadRuntimesWizard_Download_Runtimes, new WizardFragment(){

            protected void createChildFragments(List<WizardFragment> list) {
                list.add(new SelectDownloadRuntimeFragment(DownloadRuntimesTaskWizard.safeFetchDownloadRuntimes(downloadRuntimes)));
                list.add(new DownloadRuntimeLicenseFragment());
                list.add(new FinalizeRuntimeDownloadFragment());
            }
        }, new TaskModel());
        if (ids != null) {
            TaskModel taskModel2 = this.getTaskModel();
            int size = ids.length;
            int i = 0;
            while (i < size) {
                taskModel2.putObject(ids[i], (Object)values[i]);
                ++i;
            }
        }
        this.getTaskModel().putObject("dl.runtime.map.prop", DownloadRuntimesTaskWizard.safeFetchDownloadRuntimes(downloadRuntimes));
    }

    private static Map<String, DownloadRuntime> safeFetchDownloadRuntimes(Map<String, DownloadRuntime> downloadRuntimes) {
        if (downloadRuntimes != null) {
            return downloadRuntimes;
        }
        final ArrayList<DownloadRuntime> runtimes = new ArrayList<DownloadRuntime>();
        IRunnableWithProgress loadDownloadRuntimes = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                DownloadRuntime[] inner = null;
                inner = RuntimeCoreActivator.getDefault().getDownloadRuntimeArray(monitor);
                if (inner != null) {
                    runtimes.addAll(Arrays.asList(inner));
                }
            }
        };
        try {
            new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()).run(true, true, loadDownloadRuntimes);
        }
        catch (InvocationTargetException e1) {
            RuntimeCoreActivator.pluginLog().logError((Throwable)e1);
        }
        catch (InterruptedException e1) {
            RuntimeCoreActivator.pluginLog().logError((Throwable)e1);
        }
        return DownloadRuntimesTaskWizard.dlRuntimeMapFromList(runtimes);
    }

    public void init(IWorkbench newWorkbench, IStructuredSelection newSelection) {
    }
}

