/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.preview.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.wst.sse.core.internal.model.ModelLifecycleEvent;
import org.eclipse.wst.sse.core.internal.provisional.IModelLifecycleListener;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.view.events.INodeSelectionListener;
import org.eclipse.wst.sse.ui.internal.view.events.ITextSelectionListener;
import org.eclipse.wst.sse.ui.internal.view.events.NodeSelectionChangedEvent;
import org.eclipse.wst.sse.ui.internal.view.events.TextSelectionChangedEvent;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.resref.core.ResourceReferenceListListener;
import org.jboss.tools.jst.web.model.helpers.WebAppHelper;
import org.jboss.tools.jst.web.project.WebProject;
import org.jboss.tools.jst.web.ui.internal.editor.bundle.BundleMap;
import org.jboss.tools.jst.web.ui.internal.editor.editor.IJSPTextEditor;
import org.jboss.tools.jst.web.ui.internal.editor.editor.IVisualController;
import org.jboss.tools.jst.web.ui.internal.editor.selection.SelectionHelper;
import org.jboss.tools.vpe.VpeDebug;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.VisualController;
import org.jboss.tools.vpe.editor.toolbar.format.FormatControllerManager;
import org.jboss.tools.vpe.preview.editor.VpvEditor;
import org.jboss.tools.vpe.preview.editor.VpvEditorPart;
import org.jboss.tools.vpe.preview.editor.context.VpvPageContext;
import org.jboss.tools.vpe.resref.core.AbsoluteFolderReferenceList;
import org.w3c.dom.Node;

public class VpvEditorController
extends VisualController
implements INodeAdapter,
IModelLifecycleListener,
INodeSelectionListener,
ITextSelectionListener,
SelectionListener,
ResourceReferenceListListener,
ISelectionChangedListener,
IVisualController {
    private StructuredTextEditor sourceEditor;
    private VpvEditorPart editPart;
    private VpvEditor visualEditor;
    private VpvPageContext pageContext;
    private FormatControllerManager toolbarFormatControllerManager = null;
    private boolean visualEditorVisible = true;
    private static List<String> vpeCategoryCommands = null;
    private AbsoluteFolderReferenceList absoluteFolderReferenceListListener;

    public VpvEditorController(VpvEditorPart editPart) {
        this.editPart = editPart;
    }

    void init(StructuredTextEditor sourceEditor, VpvEditor visualEditor, BundleMap bundleMap) {
        this.sourceEditor = sourceEditor;
        this.visualEditor = visualEditor;
        visualEditor.setController(this);
        bundleMap.init(sourceEditor.getEditorInput());
        this.pageContext = new VpvPageContext(bundleMap, this.editPart);
        IDOMModel sourceModel = (IDOMModel)this.getModel();
        if (sourceModel == null) {
            return;
        }
        sourceModel.addModelLifecycleListener((IModelLifecycleListener)this);
        IEditorInput editorInput = this.pageContext.getEditPart().getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            XModel xm = null;
            IProject project = ((IFileEditorInput)editorInput).getFile().getProject();
            IModelNature mn = EclipseResourceUtil.getModelNature((IProject)project);
            if (mn != null) {
                xm = mn.getModel();
            }
            if (xm != null) {
                WebProject.getInstance((XModel)xm).getTaglibMapping().revalidate(WebAppHelper.getWebApp((XModel)xm));
            }
        }
        ISelectionProvider provider = sourceEditor.getSelectionProvider();
        provider.addSelectionChangedListener((ISelectionChangedListener)this);
        StyledText textWidget = SelectionHelper.getSourceTextWidget((StructuredTextEditor)sourceEditor);
        if (textWidget != null) {
            textWidget.addSelectionListener((SelectionListener)this);
        }
        this.absoluteFolderReferenceListListener = AbsoluteFolderReferenceList.getInstance();
        this.absoluteFolderReferenceListListener.addChangeListener((ResourceReferenceListListener)this);
        this.sourceSelectionChanged();
        this.refreshCommands();
    }

    public IStructuredModel getModel() {
        return this.sourceEditor.getModel();
    }

    public void drop(Node node, Node parentNode, int offset) {
    }

    public VpvPageContext getPageContext() {
        return this.pageContext;
    }

    public void postLongOperation() {
    }

    public void preLongOperation() {
    }

    public void refreshExternalLinks() {
    }

    public void visualRefresh() {
        this.visualEditor.refresh();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!this.isVisualEditorVisible()) {
            return;
        }
        if (this.editPart.getVisualMode() != 1 && this.toolbarFormatControllerManager != null) {
            this.toolbarFormatControllerManager.selectionChanged();
        }
        if (this.editPart.getVisualMode() != 1) {
            if (VpeDebug.PRINT_SOURCE_SELECTION_EVENT) {
                System.out.println(">>>>>>>>>>>>>> selectionChanged  " + event.getSource());
            }
            this.sourceSelectionChanged();
        }
    }

    public IPath getPath() {
        IEditorInput input;
        if (this.editPart != null && (input = this.editPart.getEditorInput()) instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile().getFullPath();
        }
        return null;
    }

    public void changed(Object source) {
        if (this.absoluteFolderReferenceListListener == source) {
            this.visualRefresh();
        }
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent arg0) {
    }

    public void textSelectionChanged(TextSelectionChangedEvent arg0) {
    }

    public void nodeSelectionChanged(NodeSelectionChangedEvent arg0) {
    }

    public void processPostModelEvent(ModelLifecycleEvent arg0) {
    }

    public void processPreModelEvent(ModelLifecycleEvent arg0) {
    }

    public boolean isAdapterForType(Object type) {
        return this == type;
    }

    public void notifyChanged(INodeNotifier arg0, int arg1, Object arg2, Object arg3, Object arg4, int arg5) {
    }

    public void refreshCommands() {
        ICommandService commandService = (ICommandService)this.editPart.getSite().getService(ICommandService.class);
        if (commandService != null) {
            for (String commandId : this.getVpeCategoryCommands()) {
                commandService.refreshElements(commandId, null);
            }
        }
    }

    private List<String> getVpeCategoryCommands() {
        if (vpeCategoryCommands == null) {
            Command[] definedCommands;
            ICommandService commandService = (ICommandService)this.editPart.getSite().getService(ICommandService.class);
            vpeCategoryCommands = new ArrayList<String>();
            Command[] commandArray = definedCommands = commandService.getDefinedCommands();
            int n = definedCommands.length;
            int n2 = 0;
            while (n2 < n) {
                Command command = commandArray[n2];
                try {
                    if ("org.jboss.tools.vpe.category".equals(command.getCategory().getId())) {
                        vpeCategoryCommands.add(command.getId());
                    }
                }
                catch (NotDefinedException e) {
                    VpePlugin.reportProblem((Exception)((Object)e));
                }
                ++n2;
            }
        }
        return vpeCategoryCommands;
    }

    public void sourceSelectionChanged() {
    }

    public void sourceSelectionToVisualSelection() {
        if (this.editPart.getVisualMode() != 1) {
            this.sourceSelectionChanged();
        }
    }

    public void dispose() {
        IDOMModel sourceModel = (IDOMModel)this.getModel();
        if (sourceModel != null) {
            sourceModel.removeModelLifecycleListener((IModelLifecycleListener)this);
        }
        if (this.sourceEditor != null) {
            ISelectionProvider provider = this.sourceEditor.getSelectionProvider();
            provider.removeSelectionChangedListener((ISelectionChangedListener)this);
            StyledText textWidget = SelectionHelper.getSourceTextWidget((StructuredTextEditor)this.sourceEditor);
            if (textWidget != null) {
                textWidget.removeSelectionListener((SelectionListener)this);
            }
            ((IJSPTextEditor)this.sourceEditor).setVPEController(null);
        }
        if (this.visualEditor != null) {
            this.visualEditor = null;
        }
        if (this.absoluteFolderReferenceListListener != null) {
            this.absoluteFolderReferenceListListener.removeChangeListener((ResourceReferenceListListener)this);
        }
        this.toolbarFormatControllerManager = null;
    }

    public boolean isVisualEditorVisible() {
        return this.visualEditorVisible;
    }

    public void setVisualEditorVisible(boolean visualEditorVisible) {
        this.visualEditorVisible = visualEditorVisible;
    }

    public StructuredTextEditor getSourceEditor() {
        return this.sourceEditor;
    }

    public void setToolbarFormatControllerManager(FormatControllerManager formatControllerManager) {
        this.toolbarFormatControllerManager = formatControllerManager;
    }
}

