/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.xulrunner.editor;

import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.vpe.xulrunner.editor.DrawOutlineInterface;
import org.jboss.tools.vpe.xulrunner.editor.FlasherData;
import org.mozilla.interfaces.inIFlasher;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIServiceManager;
import org.mozilla.xpcom.Mozilla;

public class Flasher {
    private inIFlasher iFlasher;
    private static final String ELEMENT_BORDER_PATTERN = "border: 2px solid %s !important;";
    private static final String PREV_STYLE_ATTR_NAME = "oldstyle";
    private DrawOutlineInterface drawOutline;

    public Flasher() {
        nsIServiceManager serviceManager = Mozilla.getInstance().getServiceManager();
        this.iFlasher = (inIFlasher)serviceManager.getServiceByContractID("@mozilla.org/inspector/flasher;1", "{7b4a099f-6f6e-4565-977b-fb622adbff49}");
        this.iFlasher.setThickness(2);
        this.drawOutline = "macosx".equals(Platform.getOS()) ? new DrawOutlineInterface(){
            private List<FlasherData> previouslyBorderedElements = null;

            @Override
            public void drawElementOutline(List<FlasherData> flasherData) {
                this.clearPreviouslySelectedElements();
                this.saveOldStyle(flasherData);
                this.previouslyBorderedElements = flasherData;
            }

            private void clearPreviouslySelectedElements() {
                if (this.previouslyBorderedElements != null) {
                    for (FlasherData borderedData : this.previouslyBorderedElements) {
                        nsIDOMElement lastBorderedElement = borderedData.getElement();
                        if (lastBorderedElement == null || lastBorderedElement.getAttribute("style") == null) continue;
                        String style = lastBorderedElement.getAttribute(Flasher.PREV_STYLE_ATTR_NAME);
                        lastBorderedElement.removeAttribute(Flasher.PREV_STYLE_ATTR_NAME);
                        lastBorderedElement.setAttribute("style", style);
                    }
                }
            }

            private void saveOldStyle(List<FlasherData> flasherData) {
                for (FlasherData flasherData2 : flasherData) {
                    nsIDOMElement domElement = flasherData2.getElement();
                    if (domElement == null) continue;
                    String oldstyle = domElement.getAttribute("style");
                    domElement.setAttribute("style", String.valueOf(domElement.getAttribute("style")) + ';' + String.format(Flasher.ELEMENT_BORDER_PATTERN, flasherData2.getSelectionColor()));
                    domElement.setAttribute(Flasher.PREV_STYLE_ATTR_NAME, oldstyle);
                }
            }
        } : new DrawOutlineInterface(){

            @Override
            public void drawElementOutline(List<FlasherData> flasherData) {
                for (FlasherData flasherData2 : flasherData) {
                    if (flasherData2.getElement() == null) continue;
                    Flasher.this.iFlasher.setColor(flasherData2.getSelectionColor());
                    Flasher.this.iFlasher.drawElementOutline(flasherData2.getElement());
                }
            }
        };
    }

    public void drawElementOutline(List<FlasherData> flasherData) {
        this.drawOutline.drawElementOutline(flasherData);
    }

    public void scrollElementIntoView(nsIDOMElement element) {
        this.iFlasher.scrollElementIntoView(element);
    }

    public Object getColor() {
        return this.iFlasher.getColor();
    }

    public void setColor(String color) {
        this.iFlasher.setColor(color);
    }

    public void dispose() {
        this.iFlasher = null;
    }
}

