/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.dnd;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.jboss.tools.vpe.dnd.AbstractDraggableFragment;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.jboss.tools.vpe.xulrunner.util.XulRunnerVpeUtils;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMText;

public class DraggableTextSelection
extends AbstractDraggableFragment {
    private final nsIDOMText selectionContainer;
    private final int startOffset;
    private final int endOffset;

    public DraggableTextSelection(nsIDOMText selectionContainer, int startOffset, int endOffset) {
        this.selectionContainer = selectionContainer;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    @Override
    public nsIDOMElement cloneFragmentAsElement() {
        nsIDOMDocument document = this.selectionContainer.getOwnerDocument();
        nsIDOMElement cloneContainer = VisualDomUtil.createBorderlessContainer(document);
        nsIDOMNode selectionContainerParent = this.selectionContainer.getParentNode();
        selectionContainerParent.appendChild((nsIDOMNode)cloneContainer);
        String cloneText = this.selectionContainer.getData().substring(this.startOffset, this.endOffset);
        nsIDOMText clone = document.createTextNode(cloneText);
        cloneContainer.appendChild((nsIDOMNode)clone);
        return cloneContainer;
    }

    @Override
    public Point getPosition() {
        Rectangle bounds = XulRunnerVpeUtils.getTextSelectionBounds((nsIDOMText)this.selectionContainer);
        return new Point(bounds.x, bounds.y);
    }
}

