/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.mozilla;

import org.eclipse.swt.SWTError;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.jboss.tools.jst.web.ui.internal.editor.bundle.BundleMap;
import org.jboss.tools.vpe.editor.VpeEditorPart;
import org.jboss.tools.vpe.editor.VpePreviewDomBuilder;
import org.jboss.tools.vpe.editor.VpeSourceDomBuilder;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.mapping.VpeDomMapping;
import org.jboss.tools.vpe.editor.mozilla.MozillaEditor;
import org.jboss.tools.vpe.editor.mozilla.MozillaEventAdapter;
import org.jboss.tools.vpe.editor.mozilla.PreviewDomEventListener;
import org.jboss.tools.vpe.editor.mozilla.XulRunnerPreview;
import org.jboss.tools.vpe.editor.mozilla.listener.EditorLoadWindowListener;
import org.jboss.tools.vpe.editor.mozilla.listener.MozillaDndListener;
import org.jboss.tools.vpe.editor.template.VpeTemplateManager;
import org.jboss.tools.vpe.xulrunner.PlatformIsNotSupportedException;
import org.jboss.tools.vpe.xulrunner.XulRunnerBundleNotFoundException;
import org.jboss.tools.vpe.xulrunner.XulRunnerException;
import org.mozilla.xpcom.XPCOMException;
import org.w3c.dom.Document;

public class MozillaPreview
extends MozillaEditor {
    private EditorLoadWindowListener editorLoadWindowListener;
    private MozillaDndListener editorDomEventListener;
    private VpeTemplateManager templateManager;
    private VpePageContext pageContext;
    private StructuredTextEditor sourceEditor;
    private VpeEditorPart editPart;
    private IDOMDocument sourceDocument;

    public MozillaPreview(VpeEditorPart editPart, StructuredTextEditor sourceEditor) {
        this.setTemplateManager(VpeTemplateManager.getInstance());
        this.setSourceEditor(sourceEditor);
        this.setEditPart(editPart);
    }

    @Override
    public void createPartControl(Composite parent) {
        try {
            this.setXulRunnerEditor(new XulRunnerPreview(parent, this));
            this.setInitialContent();
            this.getXulRunnerEditor().setLayoutData((Object)new GridData(4, 4, true, true));
        }
        catch (XulRunnerBundleNotFoundException e) {
            this.errorWrapper.showError(parent, (Throwable)e);
        }
        catch (PlatformIsNotSupportedException e) {
            this.errorWrapper.showError(parent, (Throwable)e);
        }
        catch (XulRunnerException e) {
            this.errorWrapper.showError(parent, (Throwable)e);
        }
        catch (XPCOMException e) {
            this.errorWrapper.showError(parent, (Throwable)e);
        }
        catch (SWTError e) {
            this.errorWrapper.showError(parent, (Throwable)e);
        }
    }

    @Override
    public void setEditorLoadWindowListener(EditorLoadWindowListener listener) {
        this.editorLoadWindowListener = listener;
    }

    public void onLoadWindow() {
        this.setContentArea(this.findContentArea());
        this.attachMozillaEventAdapter();
        if (this.editorLoadWindowListener != null) {
            this.editorLoadWindowListener.load();
        }
    }

    @Override
    public void showResizer() {
    }

    @Override
    public void hideResizer() {
    }

    public void rebuildDom() {
        if (this.getPageContext() != null && this.getPageContext().getVisualBuilder() != null && this.getSourceDocument() != null) {
            this.getPageContext().getVisualBuilder().rebuildDom((Document)this.getSourceDocument());
        }
    }

    public void buildDom() {
        BundleMap bundle = new BundleMap();
        bundle.init(this.getSourceEditor().getEditorInput());
        bundle.setShowBundleUsageAsEL(false);
        this.setPageContext(new VpePageContext(bundle, this.getEditPart()));
        VpeDomMapping domMapping = new VpeDomMapping(this.getPageContext());
        VpeSourceDomBuilder sourceBuilder = new VpeSourceDomBuilder(domMapping, null, this.getTemplateManager(), this.getSourceEditor(), this.getPageContext());
        VpePreviewDomBuilder visualBuilder = new VpePreviewDomBuilder(domMapping, null, this.getTemplateManager(), this, this.getPageContext());
        this.getPageContext().setSourceDomBuilder(sourceBuilder);
        this.getPageContext().setVisualDomBuilder(visualBuilder);
        IDOMModel sourceModel = (IDOMModel)this.getSourceEditor().getModel();
        this.setSourceDocument(sourceModel.getDocument());
        visualBuilder.buildDom((Document)this.getSourceDocument());
    }

    protected IDOMDocument getSourceDocument() {
        return this.sourceDocument;
    }

    protected void setSourceDocument(IDOMDocument sourceDocument) {
        this.sourceDocument = sourceDocument;
    }

    private VpePageContext getPageContext() {
        return this.pageContext;
    }

    private void setPageContext(VpePageContext pageContext) {
        this.pageContext = pageContext;
    }

    private VpeEditorPart getEditPart() {
        return this.editPart;
    }

    private void setEditPart(VpeEditorPart editPart) {
        this.editPart = editPart;
    }

    private VpeTemplateManager getTemplateManager() {
        return this.templateManager;
    }

    private void setTemplateManager(VpeTemplateManager templateManager) {
        this.templateManager = templateManager;
    }

    private StructuredTextEditor getSourceEditor() {
        return this.sourceEditor;
    }

    private void setSourceEditor(StructuredTextEditor sourceEditor) {
        this.sourceEditor = sourceEditor;
    }

    @Override
    public void dispose() {
        this.setEditorLoadWindowListener(null);
        if (this.pageContext != null) {
            this.pageContext.dispose();
            this.pageContext = null;
        }
        if (this.getXulRunnerEditor() != null) {
            this.getXulRunnerEditor().dispose();
            this.setXulRunnerEditor(null);
        }
        this.sourceDocument = null;
        this.sourceEditor = null;
        this.editPart = null;
        super.dispose();
    }

    @Override
    protected MozillaEventAdapter createMozillaEventAdapter() {
        return new PreviewDomEventListener();
    }
}

