/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.jboss.tools.jst.web.ui.internal.editor.util.NodesManagingUtil;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.mapping.VpeDomMapping;
import org.jboss.tools.vpe.editor.mapping.VpeNodeMapping;
import org.jboss.tools.vpe.editor.selection.VpeSelectionController;
import org.jboss.tools.vpe.editor.util.TextUtil;
import org.jboss.tools.vpe.editor.util.VpeNodesManagingUtil;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMRange;
import org.mozilla.interfaces.nsISelection;
import org.w3c.dom.Node;

public class SelectionUtil {
    public static nsIDOMNode getSelectedNode(nsISelection selection) {
        nsIDOMNode selectedNode = null;
        nsIDOMNode focusNode = selection.getFocusNode();
        if (selection.getAnchorNode() == focusNode) {
            if (focusNode != null) {
                selectedNode = focusNode.getNodeType() != 3 && selection.getFocusOffset() != 0 ? focusNode.getChildNodes().item((long)(selection.getFocusOffset() - 1)) : selection.getFocusNode();
            }
        } else {
            nsIDOMRange range = selection.getRangeAt(0);
            selectedNode = range.getCommonAncestorContainer();
        }
        return selectedNode;
    }

    public static void setSourceSelection(VpePageContext pageContext, Node node) {
        int start = NodesManagingUtil.getStartOffsetNode((Node)node);
        int length = NodesManagingUtil.getNodeLength((Node)node);
        pageContext.getSourceBuilder().getStructuredTextViewer().setSelectedRange(start, length);
        pageContext.getSourceBuilder().getStructuredTextViewer().revealRange(start, length);
    }

    public static void setSourceSelection(VpePageContext pageContext, Node node, int offset, int length) {
        int start = NodesManagingUtil.getStartOffsetNode((Node)node);
        SelectionUtil.setSourceSelection(pageContext, start + offset, length);
    }

    public static void setSourceSelection(VpePageContext pageContext, Node node, int offset) {
        int start = NodesManagingUtil.getStartOffsetNode((Node)node);
        pageContext.getSourceBuilder().getStructuredTextViewer().getTextWidget().setSelection(start + offset);
    }

    public static void setSourceSelection(VpePageContext pageContext, int offset, int length) {
        pageContext.getSourceBuilder().getStructuredTextViewer().setSelectedRange(offset, length);
        pageContext.getSourceBuilder().getStructuredTextViewer().revealRange(offset, length);
    }

    public static VpeNodeMapping getNodeMappingBySourceSelection(IStructuredModel model, VpeDomMapping domMapping, int focus, int anchor) {
        Node focusNode;
        if (anchor < focus) {
            int tmp = focus;
            focus = anchor;
            anchor = tmp;
        }
        if ((focusNode = SelectionUtil.getSourceNodeByPosition(model, focus)) != null && NodesManagingUtil.isNodeContainsPosition((Node)focusNode, (int)anchor)) {
            return VpeNodesManagingUtil.getNodeMapping(domMapping, focusNode);
        }
        return null;
    }

    private static Node getSourceNodeByPosition(IStructuredModel model, int position) {
        IndexedRegion possibleNode;
        IndexedRegion node = model.getIndexedRegion(position);
        IndexedRegion indexedRegion = possibleNode = position >= 1 ? model.getIndexedRegion(position - 1) : null;
        if (node == null && position >= 1) {
            node = possibleNode;
        } else if (node != null && ((Node)node).getNodeType() != 3 && node.getStartOffset() == position && position >= 1) {
            node = possibleNode;
        } else if (node != null && ((Node)node).getNodeType() != 3 && possibleNode != null && ((Node)possibleNode).getNodeType() == 3) {
            node = possibleNode;
        }
        return (Node)node;
    }

    public static Point getVisualSelectionRange(nsISelection selection) {
        Point range = new Point(0, 0);
        nsIDOMNode focusedNode = SelectionUtil.getSelectedNode(selection);
        if (focusedNode != null) {
            range.x = selection.getFocusOffset();
            range.y = selection.getAnchorOffset() - selection.getFocusOffset();
        }
        return range;
    }

    public static Point getSourceSelectionRange(nsIDOMNode focusedNode, int startOffset, int endOffset, Node sourceNode) {
        Point sourceRange = new Point(0, 0);
        if (sourceNode != null && sourceNode.getNodeValue() != null) {
            NodeImpl nodeImpl = (NodeImpl)sourceNode;
            sourceRange.x = TextUtil.sourcePosition(nodeImpl.getValueSource(), focusedNode.getNodeValue(), startOffset);
            sourceRange.y = TextUtil.sourcePosition(nodeImpl.getValueSource(), focusedNode.getNodeValue(), endOffset);
        }
        return sourceRange;
    }

    public static VpeNodeMapping getNodeMappingBySourceSelection(StructuredTextEditor sourceEditor, VpeDomMapping domMapping) {
        List<VpeNodeMapping> mappings = SelectionUtil.getNodeMappingsBySourceSelection(sourceEditor, domMapping);
        if (!mappings.isEmpty()) {
            return mappings.get(0);
        }
        return null;
    }

    public static List<VpeNodeMapping> getNodeMappingsBySourceSelection(StructuredTextEditor sourceEditor, VpeDomMapping domMapping) {
        ArrayList<VpeNodeMapping> nodeMappings = new ArrayList<VpeNodeMapping>();
        for (Node node : SelectionUtil.getFocusNodesBySourceSelection(sourceEditor, domMapping)) {
            VpeNodeMapping nodeMapping = VpeNodesManagingUtil.getNodeMapping(domMapping, node);
            if (nodeMapping == null) continue;
            nodeMappings.add(nodeMapping);
        }
        return nodeMappings;
    }

    private static List<Node> getFocusNodesBySourceSelection(StructuredTextEditor sourceEditor, VpeDomMapping domMapping) {
        Point range = sourceEditor.getTextViewer().getSelectedRange();
        IDocument document = sourceEditor.getTextViewer().getDocument();
        ArrayList<Node> focusNodes = new ArrayList<Node>();
        IStructuredModel model = null;
        try {
            model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
            if (model == null) {
                List<Node> list = Collections.emptyList();
                return list;
            }
            int selectionStart = Math.min(range.x, range.x + range.y);
            if (range.y == 0) {
                Node focusNode = SelectionUtil.getSourceNodeByPosition(model, selectionStart);
                if (focusNode != null) {
                    focusNodes.add(focusNode);
                }
            } else {
                ISelection selection = sourceEditor.getSelectionProvider().getSelection();
                if (selection instanceof IStructuredSelection) {
                    for (Object selectionElement : (IStructuredSelection)selection) {
                        if (!(selectionElement instanceof Node)) continue;
                        focusNodes.add((Node)selectionElement);
                    }
                }
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return focusNodes;
    }

    public static Node getNodeBySourcePosition(StructuredTextEditor sourceEditor, int position) {
        IDocument document = sourceEditor.getTextViewer().getDocument();
        IStructuredModel model = null;
        Node node = null;
        try {
            model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
            node = (Node)model.getIndexedRegion(position);
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return node;
    }

    public static nsIDOMNode getSelectedNode(VpePageContext pageContext) {
        nsIDOMNode domNode = null;
        List selectedNodes = pageContext.getVisualBuilder().getXulRunnerEditor().getSelectedNodes();
        if (selectedNodes != null && selectedNodes.size() > 0) {
            domNode = (nsIDOMNode)selectedNodes.get(0);
        }
        return domNode;
    }

    public static Point getSourceSelectionRange(StructuredTextEditor sourceEditor) {
        StructuredTextViewer textViewer = sourceEditor.getTextViewer();
        if (textViewer != null) {
            return textViewer.getSelectedRange();
        }
        return null;
    }

    public static void clearSelection(VpeSelectionController selectionController) {
        selectionController.getSelection((short)1).removeAllRanges();
    }
}

