/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.configuration;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;

public final class ProjectBuilderUtils {
    public static final String VALIDATOR_BUILDER_ID = "org.eclipse.wst.validation.validationbuilder";

    private ProjectBuilderUtils() {
    }

    public static boolean isProjectBuilderInstalled(IProject project, String builderId) throws CoreException {
        ICommand[] commands;
        ICommand[] iCommandArray = commands = project.getDescription().getBuildSpec();
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand command = iCommandArray[n2];
            if (command.getBuilderName().equals(builderId)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean installProjectBuilder(IProject project, String builderId) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        if (ProjectBuilderUtils.isProjectBuilderInstalled(project, builderId)) {
            return false;
        }
        ICommand jaxrsBuilderCommand = desc.newCommand();
        jaxrsBuilderCommand.setBuilderName(builderId);
        int validatorBuilderIdIndex = ProjectBuilderUtils.locatorValidatorBuilderId(commands);
        if (validatorBuilderIdIndex == -1) {
            ICommand[] newCommands = new ICommand[commands.length + 2];
            System.arraycopy(commands, 0, newCommands, 0, commands.length);
            newCommands[newCommands.length - 2] = jaxrsBuilderCommand;
            ICommand validationBuilderCommand = desc.newCommand();
            validationBuilderCommand.setBuilderName(VALIDATOR_BUILDER_ID);
            newCommands[newCommands.length - 1] = validationBuilderCommand;
            desc.setBuildSpec(newCommands);
        } else {
            ICommand[] newCommands = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, newCommands, 0, validatorBuilderIdIndex);
            System.arraycopy(commands, validatorBuilderIdIndex, newCommands, validatorBuilderIdIndex + 1, commands.length - validatorBuilderIdIndex);
            newCommands[validatorBuilderIdIndex] = jaxrsBuilderCommand;
            desc.setBuildSpec(newCommands);
        }
        project.setDescription(desc, null);
        return true;
    }

    private static int locatorValidatorBuilderId(ICommand[] commands) {
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(VALIDATOR_BUILDER_ID)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int getBuilderPosition(IProject project, String builderId) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderId)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean uninstallProjectBuilder(IProject project, String builderId) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderId)) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                desc.setBuildSpec(newCommands);
                project.setDescription(desc, null);
                return true;
            }
            ++i;
        }
        return false;
    }
}

