/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IMethod;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.jdt.SourceType;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJavaMethodParameter;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJavaMethodSignature;

public class JavaMethodSignature
implements IJavaMethodSignature {
    private final IMethod javaMethod;
    private final SourceType returnedType;
    private final List<IJavaMethodParameter> methodParameters;

    public JavaMethodSignature(IMethod javaMethod, SourceType returnedType, List<IJavaMethodParameter> methodParameters) {
        this.javaMethod = javaMethod;
        this.returnedType = returnedType;
        this.methodParameters = new ArrayList<IJavaMethodParameter>(methodParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaMethodSignature createWorkingcopy() {
        JavaMethodSignature javaMethodSignature = this;
        synchronized (javaMethodSignature) {
            return new JavaMethodSignature(this.javaMethod, this.returnedType, new ArrayList<IJavaMethodParameter>(this.methodParameters));
        }
    }

    @Override
    public IMethod getJavaMethod() {
        return this.javaMethod;
    }

    @Override
    public SourceType getReturnedType() {
        return this.returnedType;
    }

    @Override
    public List<IJavaMethodParameter> getMethodParameters() {
        return Collections.unmodifiableList(this.methodParameters);
    }

    @Override
    public IJavaMethodParameter getMethodParameter(String name) {
        for (IJavaMethodParameter parameter : this.methodParameters) {
            if (!parameter.getName().equals(name)) continue;
            return parameter;
        }
        return null;
    }

    public String toString() {
        StringBuilder stb = new StringBuilder("JavaMethodSignature ");
        if (this.returnedType != null) {
            stb.append(this.returnedType.getDisplayableTypeName()).append(" ");
        } else {
            stb.append("void ");
        }
        stb.append(this.javaMethod.getElementName()).append("(");
        Iterator<IJavaMethodParameter> paramIterator = this.methodParameters.iterator();
        while (paramIterator.hasNext()) {
            IJavaMethodParameter methodParam = paramIterator.next();
            for (Map.Entry<String, Annotation> entry : methodParam.getAnnotations().entrySet()) {
                stb.append(entry.getValue()).append(" ");
            }
            if (methodParam.getType() != null) {
                stb.append(methodParam.getType().getDisplayableTypeName());
            } else {
                stb.append("unknown");
            }
            if (!paramIterator.hasNext()) continue;
            stb.append(", ");
        }
        stb.append(")");
        return stb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.javaMethod == null ? 0 : this.javaMethod.hashCode());
        result = 31 * result + (this.methodParameters == null ? 0 : this.methodParameters.hashCode());
        result = 31 * result + (this.returnedType == null ? 0 : this.returnedType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaMethodSignature other = (JavaMethodSignature)obj;
        if (this.javaMethod == null ? other.javaMethod != null : !this.javaMethod.equals(other.javaMethod)) {
            return false;
        }
        if (this.methodParameters == null ? other.methodParameters != null : !this.methodParameters.equals(other.methodParameters)) {
            return false;
        }
        return !(this.returnedType == null ? other.returnedType != null : !this.returnedType.equals(other.returnedType));
    }
}

