/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsBaseElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsJavaElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsWebxmlApplication;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.jdt.AnnotationUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.Flags;
import org.jboss.tools.ws.jaxrs.core.jdt.FlagsUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementKind;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsElement;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsJavaApplication;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.JaxrsElementDelta;

public class JaxrsJavaApplication
extends JaxrsJavaElement<IType>
implements IJaxrsJavaApplication {
    private boolean isApplicationSubclass = false;
    private String applicationPathOverride = null;

    public static Builder from(IJavaElement javaElement) throws JavaModelException {
        CompilationUnit ast = JdtUtils.parse(javaElement, (IProgressMonitor)new NullProgressMonitor());
        switch (javaElement.getElementType()) {
            case 5: {
                return new Builder(((ICompilationUnit)javaElement).findPrimaryType(), ast);
            }
            case 7: {
                return new Builder((IType)javaElement, ast);
            }
        }
        return null;
    }

    public static Builder from(IJavaElement javaElement, CompilationUnit ast) {
        switch (javaElement.getElementType()) {
            case 5: {
                return new Builder(((ICompilationUnit)javaElement).findPrimaryType(), ast);
            }
            case 7: {
                return new Builder((IType)javaElement, ast);
            }
        }
        return null;
    }

    private JaxrsJavaApplication(Builder builder) {
        this(builder.javaType, builder.annotations, builder.metamodel, builder.isApplicationSubclass, null);
    }

    private JaxrsJavaApplication(IType javaType, Map<String, Annotation> annotations, JaxrsMetamodel metamodel, boolean isApplicationSubclass, JaxrsJavaApplication primaryCopy) {
        super(javaType, annotations, metamodel, primaryCopy);
        JaxrsWebxmlApplication webxmlApplication;
        this.isApplicationSubclass = isApplicationSubclass;
        if (this.hasMetamodel() && (webxmlApplication = this.getMetamodel().findWebxmlApplicationByClassName(this.getJavaClassName())) != null) {
            this.applicationPathOverride = webxmlApplication.getApplicationPath();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JaxrsBaseElement createWorkingCopy() {
        JaxrsJavaApplication jaxrsJavaApplication = this;
        synchronized (jaxrsJavaApplication) {
            return new JaxrsJavaApplication((IType)this.getJavaElement(), AnnotationUtils.createWorkingCopies(this.getAnnotations()), this.getMetamodel(), this.isApplicationSubclass, this);
        }
    }

    @Override
    public JaxrsJavaApplication getWorkingCopy() {
        return (JaxrsJavaApplication)super.getWorkingCopy();
    }

    @Override
    boolean isMarkedForRemoval() {
        return !this.isApplicationSubclass && this.getApplicationPathAnnotation() == null;
    }

    @Override
    public EnumElementKind getElementKind() {
        return EnumElementKind.APPLICATION_JAVA;
    }

    @Override
    public boolean isWebXmlApplication() {
        return false;
    }

    @Override
    public boolean isJavaApplication() {
        return true;
    }

    public boolean isJaxrsCoreApplicationSubclass() {
        return this.isApplicationSubclass;
    }

    public void setJaxrsCoreApplicationSubclass(boolean isApplicationSubclass) {
        this.isApplicationSubclass = isApplicationSubclass;
    }

    @Override
    public String getJavaClassName() {
        return ((IType)this.getJavaElement()).getFullyQualifiedName();
    }

    public void setApplicationPathOverride(String applicationPathOverride) throws CoreException {
        Logger.debug("Override @ApplicationPath value with '{}'", applicationPathOverride);
        this.applicationPathOverride = applicationPathOverride;
        if (this.hasMetamodel()) {
            this.getMetamodel().update(new JaxrsElementDelta((IJaxrsElement)this, 4, 64));
        }
    }

    public void unsetApplicationPathOverride() throws CoreException {
        Logger.debug("Unoverriding @ApplicationPath value");
        this.applicationPathOverride = null;
        if (this.hasMetamodel()) {
            this.getMetamodel().update(new JaxrsElementDelta((IJaxrsElement)this, 4, 64));
        }
    }

    @Override
    public String getApplicationPath() {
        if (this.applicationPathOverride != null) {
            return this.applicationPathOverride;
        }
        Annotation applicationPathAnnotation = this.getApplicationPathAnnotation();
        if (applicationPathAnnotation != null) {
            return applicationPathAnnotation.getValue();
        }
        return null;
    }

    public Annotation getApplicationPathAnnotation() {
        return this.getAnnotation("javax.ws.rs.ApplicationPath");
    }

    public boolean isOverriden() {
        if (this.getMetamodel() != null) {
            return this.getMetamodel().findWebxmlApplicationByClassName(this.getJavaClassName()) != null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(IJavaElement javaElement, CompilationUnit ast) throws CoreException {
        JaxrsJavaApplication jaxrsJavaApplication = this;
        synchronized (jaxrsJavaApplication) {
            JaxrsJavaApplication transientApplication = JaxrsJavaApplication.from(javaElement, ast).build(false);
            Flags annotationsFlags = FlagsUtils.computeElementFlags(this);
            if (transientApplication == null) {
                this.remove(annotationsFlags);
            } else {
                Flags updateAnnotationsFlags = this.updateAnnotations(transientApplication.getAnnotations());
                JaxrsElementDelta delta = new JaxrsElementDelta((IJaxrsElement)this, 4, updateAnnotationsFlags);
                if (this.isJaxrsCoreApplicationSubclass() != transientApplication.isJaxrsCoreApplicationSubclass()) {
                    this.isApplicationSubclass = transientApplication.isJaxrsCoreApplicationSubclass();
                    delta.addFlag(128);
                }
                if (this.isMarkedForRemoval()) {
                    this.remove(annotationsFlags);
                } else if (this.hasMetamodel()) {
                    this.getMetamodel().update(delta);
                }
            }
        }
    }

    /* synthetic */ JaxrsJavaApplication(Builder builder, JaxrsJavaApplication jaxrsJavaApplication) {
        this(builder);
    }

    public static class Builder {
        private final IType javaType;
        private final CompilationUnit ast;
        private Map<String, Annotation> annotations;
        private JaxrsMetamodel metamodel = null;
        private boolean isApplicationSubclass = false;

        private Builder(IType javaType, CompilationUnit ast) {
            this.javaType = javaType;
            this.ast = ast;
        }

        public Builder withMetamodel(JaxrsMetamodel metamodel) {
            this.metamodel = metamodel;
            return this;
        }

        public JaxrsJavaApplication build() throws CoreException {
            return this.build(true);
        }

        JaxrsJavaApplication build(boolean joinMetamodel) throws CoreException {
            long start;
            block5: {
                block4: {
                    start = System.currentTimeMillis();
                    try {
                        if (this.javaType != null && this.javaType.exists() && this.javaType.isStructureKnown()) break block4;
                    }
                    catch (Throwable throwable) {
                        long end = System.currentTimeMillis();
                        Logger.tracePerf("Built JAX-RS JavaApplication in {}ms", end - start);
                        throw throwable;
                    }
                    long end = System.currentTimeMillis();
                    Logger.tracePerf("Built JAX-RS JavaApplication in {}ms", end - start);
                    return null;
                }
                JdtUtils.makeConsistentIfNecessary((IMember)this.javaType);
                IType applicationSupertype = JdtUtils.resolveType("javax.ws.rs.core.Application", this.javaType.getJavaProject(), (IProgressMonitor)new NullProgressMonitor());
                this.isApplicationSubclass = JdtUtils.isTypeOrSuperType(applicationSupertype, this.javaType);
                this.annotations = JdtUtils.resolveAllAnnotations((IMember)this.javaType, this.ast);
                Annotation applicationPathAnnotation = this.annotations.get("javax.ws.rs.ApplicationPath");
                if (!this.isApplicationSubclass && applicationPathAnnotation == null) break block5;
                JaxrsJavaApplication application = new JaxrsJavaApplication(this, null);
                if (joinMetamodel) {
                    application.joinMetamodel();
                }
                JaxrsJavaApplication jaxrsJavaApplication = application;
                long end = System.currentTimeMillis();
                Logger.tracePerf("Built JAX-RS JavaApplication in {}ms", end - start);
                return jaxrsJavaApplication;
            }
            long end = System.currentTimeMillis();
            Logger.tracePerf("Built JAX-RS JavaApplication in {}ms", end - start);
            return null;
        }
    }
}

