/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.index.Term;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.tools.ws.jaxrs.core.JBossJaxrsCorePlugin;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder.JavaElementChangedEvent;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder.JaxrsElementChangedProcessorDelegate;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder.JaxrsHttpMethodChangedListener;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder.ResourceDelta;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsBaseElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsBuiltinHttpMethod;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsElementFactory;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsEndpoint;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsHttpMethod;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsJavaApplication;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsJavaElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParameterAggregator;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsProvider;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResource;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsShadowElementsCache;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsWebxmlApplication;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.search.JaxrsElementsIndexationDelegate;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.search.LuceneDocumentFactory;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.jdt.Flags;
import org.jboss.tools.ws.jaxrs.core.jdt.FlagsUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementCategory;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementKind;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsApplication;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsElement;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsElementChangedListener;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsEndpoint;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsHttpMethod;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsJavaApplication;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsNameBinding;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsParamConverterProvider;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsProvider;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsResource;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsResourceMethod;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsStatus;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.JaxrsElementDelta;
import org.jboss.tools.ws.jaxrs.core.wtp.WtpUtils;

public class JaxrsMetamodel
implements IJaxrsMetamodel {
    public static final QualifiedName METAMODEL_QUALIFIED_NAME = new QualifiedName("org.jboss.tools.ws.jaxrs.core", "metamodel");
    private final IJavaProject javaProject;
    private int problemLevel;
    private final Map<String, JaxrsBaseElement> elements = new HashMap<String, JaxrsBaseElement>();
    private final Map<String, JaxrsEndpoint> endpoints = new HashMap<String, JaxrsEndpoint>();
    private final JaxrsElementsIndexationDelegate indexationService;
    private final Set<IJaxrsElementChangedListener> elementChangedListeners = new HashSet<IJaxrsElementChangedListener>();
    private boolean initializing = true;
    private IStatus buildStatus = Status.OK_STATUS;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private JaxrsShadowElementsCache shadowElementsCache = new JaxrsShadowElementsCache();

    private JaxrsMetamodel(IJavaProject javaProject) throws CoreException {
        this.javaProject = javaProject;
        this.indexationService = new JaxrsElementsIndexationDelegate(this);
        this.addBuiltinHttpMethods();
        this.addJaxrsElementChangedListener(new JaxrsHttpMethodChangedListener());
    }

    @Override
    public String getIdentifier() {
        return this.javaProject.getHandleIdentifier();
    }

    public void setBuildStatus(IStatus buildStatus) {
        this.buildStatus = buildStatus;
    }

    public IStatus getBuildStatus() {
        return this.buildStatus;
    }

    @Override
    public boolean isInitializing() {
        return this.initializing;
    }

    public void resetProblemLevel() {
        this.problemLevel = 0;
    }

    @Override
    public final int getProblemSeverity() {
        int globalLevel = this.problemLevel;
        for (Map.Entry<String, JaxrsBaseElement> entry : this.elements.entrySet()) {
            globalLevel = Math.max(globalLevel, entry.getValue().getProblemSeverity());
        }
        return globalLevel;
    }

    public void setProblemSeverity(int severity) {
        this.problemLevel = Math.max(this.problemLevel, severity);
    }

    private void addBuiltinHttpMethods() throws CoreException {
        JaxrsBuiltinHttpMethod.from("javax.ws.rs.GET", "GET").buildIn(this);
        JaxrsBuiltinHttpMethod.from("javax.ws.rs.POST", "POST").buildIn(this);
        JaxrsBuiltinHttpMethod.from("javax.ws.rs.PUT", "PUT").buildIn(this);
        JaxrsBuiltinHttpMethod.from("javax.ws.rs.DELETE", "DELETE").buildIn(this);
        JaxrsBuiltinHttpMethod.from("javax.ws.rs.OPTIONS", "OPTIONS").buildIn(this);
        JaxrsBuiltinHttpMethod.from("javax.ws.rs.HEAD", "HEAD").buildIn(this);
    }

    @Override
    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public static JaxrsMetamodel create(IJavaProject javaProject) throws CoreException {
        Logger.debug("*** Returning a new Metamodel for project '{}' ***", javaProject.getElementName());
        JaxrsMetamodel metamodel = new JaxrsMetamodel(javaProject);
        Logger.debug("JAX-RS Metamodel created for project {}", javaProject.getElementName());
        javaProject.getProject().setSessionProperty(METAMODEL_QUALIFIED_NAME, (Object)metamodel);
        JBossJaxrsCorePlugin.notifyMetamodelChanged(metamodel, 1);
        return metamodel;
    }

    public final void remove() throws CoreException {
        try {
            try {
                this.readWriteLock.writeLock().lock();
                JBossJaxrsCorePlugin.notifyMetamodelChanged(this, 2);
                this.elementChangedListeners.clear();
                this.indexationService.dispose();
                IProject project = this.getProject();
                if (project.exists() && project.isOpen()) {
                    project.setSessionProperty(METAMODEL_QUALIFIED_NAME, null);
                    if (!project.getWorkspace().isTreeLocked()) {
                        project.deleteMarkers("org.jboss.tools.ws.jaxrs.metamodelMarker", true, 2);
                    }
                }
            }
            catch (IOException e) {
                Logger.error("Failed to remove JAX-RS Metamodel for project " + this.javaProject.getElementName(), e);
                this.readWriteLock.writeLock().unlock();
                Logger.debug("JAX-RS Metamodel removed for project " + this.javaProject.getElementName());
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
            Logger.debug("JAX-RS Metamodel removed for project " + this.javaProject.getElementName());
        }
    }

    @Override
    public IProject getProject() {
        if (this.javaProject == null) {
            return null;
        }
        return this.javaProject.getProject();
    }

    public void addJaxrsElementChangedListener(IJaxrsElementChangedListener listener) {
        this.elementChangedListeners.add(listener);
    }

    public void removeListener(IJaxrsElementChangedListener listener) {
        this.elementChangedListeners.remove(listener);
    }

    private void notifyListeners(JaxrsElementDelta delta) {
        Logger.debug("Notify elementChangedListeners after {}", delta);
        for (IJaxrsElementChangedListener listener : this.elementChangedListeners) {
            listener.notifyElementChanged(delta);
        }
    }

    public void processJavaElementChange(JavaElementChangedEvent delta, IProgressMonitor progressMonitor) throws CoreException {
        try {
            Logger.debug("Processing {}", delta);
            this.readWriteLock.writeLock().lock();
            IJavaElement element = delta.getElement();
            CompilationUnit ast = delta.getCompilationUnitAST();
            int deltaKind = delta.getKind();
            switch (element.getElementType()) {
                case 2: 
                case 3: {
                    this.processProject(progressMonitor);
                    break;
                }
                case 16: {
                    this.processJavaAnnotationChange((IAnnotation)element, deltaKind, ast, progressMonitor);
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 9: {
                    this.processJavaElementChange(element, deltaKind, ast, progressMonitor);
                    break;
                }
            }
        }
        finally {
            this.initializing = false;
            progressMonitor.done();
            this.readWriteLock.writeLock().unlock();
            this.setBuildStatus(Status.OK_STATUS);
            Logger.debug("Done processing Java changes: " + this.getStatus());
        }
    }

    private void processJavaElementChange(IJavaElement javaElement, int deltaKind, CompilationUnit ast, IProgressMonitor progressMonitor) throws JavaModelException, CoreException {
        if (deltaKind == 1) {
            JaxrsElementFactory.createElements(javaElement, ast, this, progressMonitor);
        } else {
            List<IJaxrsElement> jaxrsElements = this.searchJaxrsElements(javaElement);
            if (deltaKind == 4) {
                if (jaxrsElements.isEmpty()) {
                    JaxrsElementFactory.createElements(javaElement, ast, this, progressMonitor);
                } else {
                    for (JaxrsJavaElement jaxrsJavaElement : jaxrsElements) {
                        jaxrsJavaElement.update(javaElement, ast);
                    }
                }
            } else {
                for (JaxrsJavaElement jaxrsJavaElement : jaxrsElements) {
                    jaxrsJavaElement.remove(FlagsUtils.computeElementFlags(jaxrsJavaElement));
                }
            }
        }
    }

    private void processJavaAnnotationChange(IAnnotation javaAnnotation, int deltaKind, CompilationUnit ast, IProgressMonitor progressMonitor) throws JavaModelException, CoreException {
        block8: {
            block7: {
                JaxrsJavaElement matchingElement = (JaxrsJavaElement)this.findElement(javaAnnotation.getParent());
                if (matchingElement == null) break block7;
                switch (deltaKind) {
                    case 1: {
                        Annotation addedAnnotation = JdtUtils.resolveAnnotation(javaAnnotation, ast);
                        if (addedAnnotation != null) {
                            matchingElement.addAnnotation(addedAnnotation);
                            break;
                        }
                        break block8;
                    }
                    case 4: {
                        Annotation updatedAnnotation = JdtUtils.resolveAnnotation(javaAnnotation, ast);
                        if (updatedAnnotation != null) {
                            matchingElement.updateAnnotation(updatedAnnotation);
                            break;
                        }
                        break block8;
                    }
                    case 2: {
                        matchingElement.removeAnnotation(javaAnnotation);
                    }
                }
                break block8;
            }
            JaxrsElementFactory.createElements(javaAnnotation, ast, this, progressMonitor);
        }
    }

    public void processProject(IProgressMonitor progressMonitor) throws CoreException {
        ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
        writeLock.lock();
        try {
            try {
                progressMonitor.beginTask("Processing project '" + this.getProject().getName() + "'...", 1);
                Logger.debug("Processing full project '{}'", this.getProject().getName());
                this.removePreviousJaxrsMarkers();
                this.elements.clear();
                this.endpoints.clear();
                this.indexationService.clear();
                this.addBuiltinHttpMethods();
                Logger.debug("Processing project '" + this.getProject().getName() + "'...");
                if (WtpUtils.hasWebDeploymentDescriptor(this.getProject())) {
                    this.processWebDeploymentDescriptorChange(new ResourceDelta((IResource)WtpUtils.getWebDeploymentDescriptor(this.getProject()), 1, Flags.NONE));
                }
                this.processResourceChange(new ResourceDelta((IResource)this.getProject(), 1, Flags.NONE), progressMonitor);
                progressMonitor.worked(1);
            }
            catch (CoreException e) {
                Logger.error("Failed while processing resource results", e);
                this.initializing = false;
                progressMonitor.done();
                writeLock.unlock();
                this.setBuildStatus(Status.OK_STATUS);
                Logger.debug("Done processing resource results.");
            }
        }
        finally {
            this.initializing = false;
            progressMonitor.done();
            writeLock.unlock();
            this.setBuildStatus(Status.OK_STATUS);
            Logger.debug("Done processing resource results.");
        }
    }

    private void removePreviousJaxrsMarkers() throws CoreException {
        final ArrayList<IMarker> markersToRemove = new ArrayList<IMarker>();
        for (Map.Entry<String, JaxrsBaseElement> entry : this.elements.entrySet()) {
            IResource resource = entry.getValue().getResource();
            if (resource == null || !resource.exists()) continue;
            IMarker[] markers = resource.findMarkers("org.jboss.tools.ws.jaxrs.metamodelMarker", false, 2);
            markersToRemove.addAll(Arrays.asList(markers));
        }
        ISchedulingRule projectModificationRule = this.javaProject.getProject().getWorkspace().getRuleFactory().modifyRule((IResource)this.getProject());
        Job removeMarkersJob = new Job("Removing JAx-RS markers..."){

            protected IStatus run(IProgressMonitor monitor) {
                for (IMarker markerToRemove : markersToRemove) {
                    try {
                        markerToRemove.delete();
                    }
                    catch (CoreException e) {
                        Logger.error("Failed to remove JAX-RS marker on '" + markerToRemove.getResource() + "'", e);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        removeMarkersJob.setRule(projectModificationRule);
        removeMarkersJob.schedule();
    }

    public void processAffectedResources(List<ResourceDelta> affectedResources, IProgressMonitor progressMonitor) {
        ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
        writeLock.lock();
        try {
            try {
                progressMonitor.beginTask("Processing Resource " + affectedResources.size() + " change(s)...", affectedResources.size());
                Logger.debug("Processing {} Resource change(s)...", affectedResources.size());
                for (ResourceDelta event : affectedResources) {
                    if (event.getResource().getType() == 4) {
                        this.processProject(progressMonitor);
                    } else {
                        this.processResourceChange(event, progressMonitor);
                    }
                    progressMonitor.worked(1);
                }
            }
            catch (CoreException e) {
                Logger.error("Failed while processing Resource results", e);
                this.initializing = false;
                progressMonitor.done();
                writeLock.unlock();
                this.setBuildStatus(Status.OK_STATUS);
                Logger.debug("Done processing Resource results.");
            }
        }
        finally {
            this.initializing = false;
            progressMonitor.done();
            writeLock.unlock();
            this.setBuildStatus(Status.OK_STATUS);
            Logger.debug("Done processing Resource results.");
        }
    }

    private void processResourceChange(ResourceDelta event, IProgressMonitor progressMonitor) throws CoreException {
        Logger.debug("Processing {}", event);
        IResource resource = event.getResource();
        if (resource == null) {
            return;
        }
        IJavaElement javaElement = JavaCore.create((IResource)resource);
        if (javaElement != null && !JdtUtils.isArchive(javaElement)) {
            this.processJavaElement(javaElement, event.getDeltaKind(), progressMonitor);
        } else if (WtpUtils.isWebDeploymentDescriptor(resource)) {
            this.processWebDeploymentDescriptorChange(new ResourceDelta(resource, event.getDeltaKind(), Flags.NONE));
        }
    }

    private void processJavaElement(IJavaElement javaElement, int deltaKind, IProgressMonitor progressMonitor) throws CoreException, JavaModelException {
        Set matchingElements = this.findElements(javaElement);
        switch (deltaKind) {
            case 1: {
                JaxrsElementFactory.createElements(javaElement, JdtUtils.parse(javaElement, progressMonitor), this, progressMonitor);
                break;
            }
            case 4: {
                CompilationUnit ast = JdtUtils.parse(javaElement, progressMonitor);
                if (matchingElements.isEmpty()) {
                    JaxrsElementFactory.createElements(javaElement, ast, this, progressMonitor);
                    break;
                }
                for (JaxrsJavaElement element : matchingElements) {
                    if (((IMember)element.getJavaElement()).getElementType() == 7 && javaElement.getElementType() == 7) {
                        element.update(javaElement, ast);
                        continue;
                    }
                    if (((IMember)element.getJavaElement()).getElementType() != 7 || javaElement.getElementType() != 5) continue;
                    ICompilationUnit compilationUnit = (ICompilationUnit)javaElement;
                    IType type = JdtUtils.resolveType(compilationUnit, ((IMember)element.getJavaElement()).getHandleIdentifier());
                    if (type != null) {
                        element.update((IJavaElement)type, ast);
                        continue;
                    }
                    element.remove(FlagsUtils.computeElementFlags(element));
                }
                break;
            }
            case 2: {
                for (JaxrsJavaElement element : matchingElements) {
                    element.remove(FlagsUtils.computeElementFlags(element));
                }
                break;
            }
        }
    }

    private void processWebDeploymentDescriptorChange(ResourceDelta delta) throws CoreException {
        long start = System.currentTimeMillis();
        try {
            IResource webxmlResource = delta.getResource();
            JaxrsWebxmlApplication webxmlElement = (JaxrsWebxmlApplication)this.findElement(webxmlResource);
            switch (delta.getDeltaKind()) {
                case 1: {
                    JaxrsWebxmlApplication.from(webxmlResource).inMetamodel(this).build();
                    break;
                }
                case 4: {
                    if (webxmlElement != null) {
                        webxmlElement.update(webxmlResource);
                        break;
                    }
                    JaxrsWebxmlApplication.from(webxmlResource).inMetamodel(this).build();
                    break;
                }
                case 2: {
                    if (webxmlElement == null) break;
                    webxmlElement.remove(FlagsUtils.computeElementFlags(webxmlElement));
                }
                default: {
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            Logger.tracePerf("Processed web.xml in {}ms", end - start);
            throw throwable;
        }
        long end = System.currentTimeMillis();
        Logger.tracePerf("Processed web.xml in {}ms", end - start);
    }

    public void add(JaxrsBaseElement element) throws CoreException {
        ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
        writeLock.lock();
        try {
            if (element == null || this.findElementByIdentifier(element) != null) {
                return;
            }
            this.elements.put(element.getIdentifier(), element);
            this.indexationService.indexElement(element);
            JaxrsElementDelta delta = new JaxrsElementDelta((IJaxrsElement)element, 1, FlagsUtils.computeElementFlags(element));
            this.notifyListeners(delta);
            this.processElementChange(delta);
        }
        finally {
            writeLock.unlock();
        }
    }

    public void notifyElementProblemLevelChanged(IJaxrsElement element) {
        Set<JaxrsEndpoint> affectedEndpoints = this.findEndpoints(element);
        for (JaxrsEndpoint affectedEndpoint : affectedEndpoints) {
            JBossJaxrsCorePlugin.notifyEndpointProblemLevelChanged(affectedEndpoint);
        }
    }

    public void processElementChange(JaxrsElementDelta delta) throws CoreException {
        long start = System.currentTimeMillis();
        ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
        writeLock.lock();
        try {
            JaxrsElementChangedProcessorDelegate.processEvent(delta);
        }
        catch (Throwable throwable) {
            writeLock.unlock();
            this.initializing = false;
            long end = System.currentTimeMillis();
            Logger.tracePerf("JAX-RS Element change processed in {}ms", end - start);
            throw throwable;
        }
        writeLock.unlock();
        this.initializing = false;
        long end = System.currentTimeMillis();
        Logger.tracePerf("JAX-RS Element change processed in {}ms", end - start);
    }

    public void update(JaxrsElementDelta delta) throws CoreException {
        if (delta.isRelevant()) {
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            writeLock.lock();
            try {
                this.indexationService.reindexElement(delta.getElement());
                this.notifyListeners(delta);
                this.processElementChange(delta);
            }
            finally {
                writeLock.unlock();
            }
        } else {
            Logger.trace("{} is not relevant. No propagation amongst other elements is happening", delta);
        }
    }

    public void update(JaxrsEndpoint endpoint) {
        if (endpoint == null) {
            return;
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
        writeLock.lock();
        try {
            this.indexationService.reindexElement(endpoint);
            JBossJaxrsCorePlugin.notifyEndpointChanged(endpoint, 4);
        }
        finally {
            writeLock.unlock();
        }
    }

    public void remove(IJaxrsElement element, Flags flags) throws CoreException {
        if (element == null) {
            return;
        }
        try {
            this.readWriteLock.writeLock().lock();
            this.processElementChange(new JaxrsElementDelta(element, 2, flags));
            this.elements.remove(element.getIdentifier());
            this.indexationService.unindexElement(element);
            this.shadowElementsCache.index(element);
            this.notifyListeners(new JaxrsElementDelta(element, 2, flags));
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public void remove(JaxrsEndpoint endpoint) {
        if (endpoint == null) {
            return;
        }
        try {
            this.readWriteLock.writeLock().lock();
            this.endpoints.remove(endpoint.getIdentifier());
            this.indexationService.unindexEndpoint(endpoint);
            JBossJaxrsCorePlugin.notifyEndpointChanged(endpoint, 2);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    private List<IJaxrsElement> searchJaxrsElements(IJavaElement element) throws JavaModelException {
        if (element == null) {
            return Collections.emptyList();
        }
        try {
            this.readWriteLock.readLock().lock();
            ArrayList<IJaxrsElement> result = new ArrayList<IJaxrsElement>();
            Term javaElementTerm = new Term("javaElement", Boolean.TRUE.toString());
            switch (element.getElementType()) {
                case 2: {
                    Term javaProjectIdentifier = new Term("javaProjectIdentifier", element.getHandleIdentifier());
                    result.addAll(this.searchJaxrsElements(javaElementTerm, javaProjectIdentifier));
                    break;
                }
                case 3: {
                    Term packageFragmentRootIdentifier = new Term("packageFragmentRootIdentifier", element.getHandleIdentifier());
                    result.addAll(this.searchJaxrsElements(javaElementTerm, packageFragmentRootIdentifier));
                    break;
                }
                case 5: {
                    Term compilationUnitTerm = new Term("compilationUnitIdentifier", element.getHandleIdentifier());
                    result.addAll(this.searchJaxrsElements(javaElementTerm, compilationUnitTerm));
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    IJaxrsElement foundElement = this.elements.get(element.getHandleIdentifier());
                    if (foundElement == null) break;
                    result.add(foundElement);
                }
            }
            ArrayList<IJaxrsElement> arrayList = result;
            return arrayList;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    private <T extends IJaxrsElement> Set<T> searchJaxrsElements(Term ... terms) {
        try {
            this.readWriteLock.readLock().lock();
            Set set = this.indexationService.searchElements(terms);
            return set;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    private Set<JaxrsEndpoint> searchJaxrsEndpoints(Term ... terms) {
        Logger.debugIndexing("Searching for Endpoints with using: {}", Arrays.asList(terms));
        return this.indexationService.searchEndpoints(terms);
    }

    private <T extends IJaxrsStatus> T searchJaxrsElement(Term ... terms) {
        String matchingIdentifier = this.indexationService.searchElement(terms);
        IJaxrsStatus element = this.elements.get(matchingIdentifier);
        if (element == null) {
            Logger.traceIndexing("No element matching terms", terms);
        }
        return (T)element;
    }

    @Override
    public List<IJaxrsElement> getAllElements() {
        return new ArrayList<IJaxrsElement>(this.elements.values());
    }

    public <T extends IJavaElement> List<T> getAllJavaElements(int elementType) {
        ArrayList javaElements = new ArrayList();
        for (Map.Entry<String, JaxrsBaseElement> entry : this.elements.entrySet()) {
            Object javaElement;
            IJaxrsElement jaxrsElement = entry.getValue();
            if (!(jaxrsElement instanceof JaxrsJavaElement) || (javaElement = ((JaxrsJavaElement)jaxrsElement).getJavaElement()) == null || javaElement.getElementType() != elementType) continue;
            javaElements.add(javaElement);
        }
        return javaElements;
    }

    public boolean hasCustomElements() {
        return this.elements.size() > 6;
    }

    public IJaxrsElement getElement(String identifier) {
        return this.elements.get(identifier);
    }

    public Set<IJaxrsElement> findElements(IResource resource) {
        if (resource == null) {
            return Collections.emptySet();
        }
        try {
            this.readWriteLock.readLock().lock();
            Term resourcePathTerm = new Term("resource", resource.getFullPath().toPortableString());
            Set<IJaxrsElement> set = this.searchJaxrsElements(resourcePathTerm);
            return set;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public Set<EnumElementKind> getShadowElementKinds(IResource changedResource) {
        return this.shadowElementsCache.lookup(changedResource);
    }

    public void removeShadowedElement(IFile changedResource) {
        this.shadowElementsCache.unindex((IResource)changedResource);
    }

    public void addShadowedElement(IJaxrsElement changedElement) {
        this.shadowElementsCache.index(changedElement);
    }

    private IJaxrsStatus findElementByIdentifier(IJaxrsElement element) {
        return this.searchJaxrsElement(LuceneDocumentFactory.getIdentifierTerm(element));
    }

    public <T extends IJaxrsElement> Set<T> findElements(IJavaElement javaElement) {
        if (javaElement == null) {
            return Collections.emptySet();
        }
        try {
            this.readWriteLock.readLock().lock();
            String identifier = javaElement.getHandleIdentifier();
            switch (javaElement.getElementType()) {
                case 2: {
                    Set<T> set = this.searchJaxrsElements(new Term("javaProjectIdentifier", identifier));
                    return set;
                }
                case 3: {
                    Set<T> set = this.searchJaxrsElements(new Term("packageFragmentRootIdentifier", identifier));
                    return set;
                }
                case 5: {
                    Set<T> set = this.searchJaxrsElements(new Term("compilationUnitIdentifier", identifier));
                    return set;
                }
            }
            Set<T> set = this.searchJaxrsElements(LuceneDocumentFactory.getIdentifierTerm(javaElement));
            return set;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public IJaxrsElement findElement(IResource resource) {
        if (resource == null) {
            return null;
        }
        try {
            this.readWriteLock.readLock().lock();
            IJaxrsElement iJaxrsElement = (IJaxrsElement)this.searchJaxrsElement(LuceneDocumentFactory.getResourcePathTerm(resource));
            return iJaxrsElement;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public Set<IJaxrsElement> findAllElements() {
        return this.findElements((IJavaElement)this.javaProject);
    }

    @Override
    public IJaxrsElement findElement(IJavaElement javaElement) {
        if (javaElement == null) {
            return null;
        }
        try {
            this.readWriteLock.readLock().lock();
            IJaxrsElement iJaxrsElement = (IJaxrsElement)this.searchJaxrsElement(LuceneDocumentFactory.getIdentifierTerm(javaElement));
            return iJaxrsElement;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public IJaxrsElement findElement(String className, EnumElementCategory expectedCategory) {
        try {
            this.readWriteLock.readLock().lock();
            IJaxrsElement iJaxrsElement = (IJaxrsElement)this.searchJaxrsElement(LuceneDocumentFactory.getJavaClassNameTerm(className), LuceneDocumentFactory.getElementCategoryTerm(expectedCategory));
            return iJaxrsElement;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public boolean containsElement(JaxrsBaseElement element) {
        if (element == null) {
            return false;
        }
        try {
            this.readWriteLock.readLock().lock();
            boolean bl = this.elements.containsKey(element.getIdentifier());
            return bl;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public final Set<IJaxrsApplication> findAllApplications() {
        try {
            this.readWriteLock.readLock().lock();
            Term categoryTerm = new Term("type", EnumElementCategory.APPLICATION.toString());
            Set<IJaxrsApplication> set = this.searchJaxrsElements(categoryTerm);
            return set;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public Set<IJaxrsJavaApplication> findApplicationsByAnnotation(String annotationClassName) {
        if (annotationClassName == null) {
            return Collections.emptySet();
        }
        try {
            this.readWriteLock.readLock().lock();
            Term projectTerm = new Term("javaProjectIdentifier", this.getJavaProject().getHandleIdentifier());
            Term categoryTerm = new Term("type", EnumElementCategory.APPLICATION.toString());
            Term typeTerm = new Term("annotationName", annotationClassName);
            Set<IJaxrsJavaApplication> set = this.searchJaxrsElements(projectTerm, categoryTerm, typeTerm);
            return set;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public final IJaxrsApplication findApplication() {
        try {
            this.readWriteLock.readLock().lock();
            JaxrsWebxmlApplication webxmlApplication = this.findWebxmlApplication();
            if (webxmlApplication != null && webxmlApplication.exists()) {
                JaxrsWebxmlApplication jaxrsWebxmlApplication = webxmlApplication;
                return jaxrsWebxmlApplication;
            }
            Set<JaxrsJavaApplication> javaApplications = this.findJavaApplications();
            for (JaxrsJavaApplication application : javaApplications) {
                if (!application.exists()) continue;
                JaxrsJavaApplication jaxrsJavaApplication = application;
                return jaxrsJavaApplication;
            }
            return null;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public boolean hasApplication() {
        return this.findApplication() != null;
    }

    public final Set<JaxrsJavaApplication> findJavaApplications() {
        try {
            this.readWriteLock.readLock().lock();
            Term categoryTerm = new Term("type", EnumElementCategory.APPLICATION.toString());
            Term kindTerm = new Term("javaApplication", Boolean.TRUE.toString());
            Set<JaxrsJavaApplication> set = this.searchJaxrsElements(categoryTerm, kindTerm);
            return set;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public final JaxrsJavaApplication findJavaApplicationByTypeName(String typeName) {
        if (typeName == null) {
            return null;
        }
        try {
            this.readWriteLock.readLock().lock();
            Term classNameTerm = new Term("javaClassName", typeName);
            Term categoryTerm = new Term("type", EnumElementCategory.APPLICATION.toString());
            Term kindTerm = new Term("javaApplication", Boolean.TRUE.toString());
            String matchingIdentifier = this.indexationService.searchElement(classNameTerm, categoryTerm, kindTerm);
            JaxrsJavaApplication jaxrsJavaApplication = (JaxrsJavaApplication)this.elements.get(matchingIdentifier);
            return jaxrsJavaApplication;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public final Set<JaxrsWebxmlApplication> findWebxmlApplications() {
        try {
            this.readWriteLock.readLock().lock();
            Term categoryTerm = new Term("type", EnumElementCategory.APPLICATION.toString());
            Term kindTerm = new Term("webXmlApplication", Boolean.TRUE.toString());
            Set<JaxrsWebxmlApplication> set = this.searchJaxrsElements(categoryTerm, kindTerm);
            return set;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public final JaxrsWebxmlApplication findWebxmlApplication() {
        try {
            this.readWriteLock.readLock().lock();
            Term categoryTerm = new Term("type", EnumElementCategory.APPLICATION.toString());
            Term kindTerm = new Term("webXmlApplication", Boolean.TRUE.toString());
            String elementIdentifier = this.indexationService.searchElement(categoryTerm, kindTerm);
            JaxrsWebxmlApplication jaxrsWebxmlApplication = (JaxrsWebxmlApplication)this.elements.get(elementIdentifier);
            return jaxrsWebxmlApplication;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public final JaxrsWebxmlApplication findWebxmlApplicationByClassName(String className) {
        if (className == null) {
            return null;
        }
        try {
            this.readWriteLock.readLock().lock();
            Term classNameTerm = new Term("javaClassName", className);
            Term categoryTerm = new Term("type", EnumElementCategory.APPLICATION.toString());
            Term kindTerm = new Term("webXmlApplication", Boolean.TRUE.toString());
            String matchingIdentifier = this.indexationService.searchElement(classNameTerm, categoryTerm, kindTerm);
            JaxrsWebxmlApplication jaxrsWebxmlApplication = (JaxrsWebxmlApplication)this.elements.get(matchingIdentifier);
            return jaxrsWebxmlApplication;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public final Set<IJaxrsHttpMethod> findAllHttpMethods() {
        try {
            this.readWriteLock.readLock().lock();
            Term categoryTerm = new Term("type", EnumElementCategory.HTTP_METHOD.toString());
            Set<IJaxrsHttpMethod> set = this.searchJaxrsElements(categoryTerm);
            return set;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public Set<String> findAllHttpMethodNames() {
        Set<IJaxrsHttpMethod> httpMethods = this.findAllHttpMethods();
        HashSet<String> httpMethodNames = new HashSet<String>(httpMethods.size() * 2);
        for (IJaxrsHttpMethod httpMethod : httpMethods) {
            httpMethodNames.add(httpMethod.getJavaClassName());
        }
        return httpMethodNames;
    }

    public final Set<IJaxrsNameBinding> findAllNameBindings() {
        try {
            this.readWriteLock.readLock().lock();
            Term categoryTerm = new Term("type", EnumElementCategory.NAME_BINDING.toString());
            Set<IJaxrsNameBinding> set = this.searchJaxrsElements(categoryTerm);
            return set;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public IJaxrsNameBinding findNameBinding(String className) {
        try {
            this.readWriteLock.readLock().lock();
            Term classNameTerm = new Term("javaClassName", className);
            Term categoryTerm = new Term("type", EnumElementCategory.NAME_BINDING.toString());
            IJaxrsNameBinding iJaxrsNameBinding = (IJaxrsNameBinding)this.searchJaxrsElement(classNameTerm, categoryTerm);
            return iJaxrsNameBinding;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public JaxrsParameterAggregator findParameterAggregator(String className) {
        try {
            this.readWriteLock.readLock().lock();
            Term classNameTerm = new Term("javaClassName", className);
            Term categoryTerm = new Term("type", EnumElementCategory.PARAMETER_AGGREGATOR.toString());
            JaxrsParameterAggregator jaxrsParameterAggregator = (JaxrsParameterAggregator)this.searchJaxrsElement(classNameTerm, categoryTerm);
            return jaxrsParameterAggregator;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public JaxrsHttpMethod findHttpMethodByTypeName(String className) throws CoreException {
        if (className == null) {
            return null;
        }
        try {
            this.readWriteLock.readLock().lock();
            Term categoryTerm = new Term("type", EnumElementCategory.HTTP_METHOD.toString());
            Term typeTerm = new Term("javaClassName", className);
            JaxrsHttpMethod jaxrsHttpMethod = (JaxrsHttpMethod)this.searchJaxrsElement(categoryTerm, typeTerm);
            return jaxrsHttpMethod;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public IJaxrsProvider findProvider(IType providerType) {
        if (providerType == null) {
            return null;
        }
        return this.findProvider(providerType.getFullyQualifiedName());
    }

    public IJaxrsProvider findProvider(String providerName) {
        if (providerName == null) {
            return null;
        }
        try {
            this.readWriteLock.readLock().lock();
            Term projectTerm = new Term("javaProjectIdentifier", this.getJavaProject().getHandleIdentifier());
            Term categoryTerm = new Term("type", EnumElementCategory.PROVIDER.toString());
            Term typeTerm = new Term("javaClassName", providerName);
            IJaxrsProvider iJaxrsProvider = (IJaxrsProvider)this.searchJaxrsElement(projectTerm, categoryTerm, typeTerm);
            return iJaxrsProvider;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public Set<IJaxrsProvider> findProvidersByAnnotation(String annotationClassName) {
        if (annotationClassName == null) {
            return Collections.emptySet();
        }
        try {
            this.readWriteLock.readLock().lock();
            Term projectTerm = new Term("javaProjectIdentifier", this.getJavaProject().getHandleIdentifier());
            Term categoryTerm = new Term("type", EnumElementCategory.PROVIDER.toString());
            Term typeTerm = new Term("annotationName", annotationClassName);
            Set<IJaxrsProvider> set = this.searchJaxrsElements(projectTerm, categoryTerm, typeTerm);
            return set;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public Set<IJaxrsElement> findElementsByAnnotation(String annotationClassName) {
        if (annotationClassName == null) {
            return Collections.emptySet();
        }
        try {
            this.readWriteLock.readLock().lock();
            Term projectTerm = new Term("javaProjectIdentifier", this.getJavaProject().getHandleIdentifier());
            Term typeTerm = new Term("annotationName", annotationClassName);
            Set<IJaxrsElement> set = this.searchJaxrsElements(projectTerm, typeTerm);
            return set;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public Set<JaxrsProvider> findProviders(EnumElementKind providerKind, String providedClassName) {
        if (providerKind == null || providedClassName == null) {
            return Collections.emptySet();
        }
        try {
            this.readWriteLock.readLock().lock();
            Term projectTerm = new Term("javaProjectIdentifier", this.getJavaProject().getHandleIdentifier());
            Term categoryTerm = new Term("type", EnumElementCategory.PROVIDER.toString());
            Term providerKindTerm = new Term("providerKind:" + providerKind.toString(), providedClassName);
            Set<JaxrsProvider> set = this.searchJaxrsElements(projectTerm, categoryTerm, providerKindTerm);
            return set;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public Set<IJaxrsProvider> findAllProviders() {
        try {
            this.readWriteLock.readLock().lock();
            Term projectTerm = new Term("javaProjectIdentifier", this.getJavaProject().getHandleIdentifier());
            Term categoryTerm = new Term("type", EnumElementCategory.PROVIDER.toString());
            Set<IJaxrsProvider> set = this.searchJaxrsElements(projectTerm, categoryTerm);
            return set;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public Set<IJaxrsParamConverterProvider> findAllParamConverterProviders() {
        try {
            this.readWriteLock.readLock().lock();
            Term projectTerm = new Term("javaProjectIdentifier", this.getJavaProject().getHandleIdentifier());
            Term categoryTerm = new Term("type", EnumElementCategory.PARAM_CONVERTER_PROVIDER.toString());
            Set<IJaxrsParamConverterProvider> set = this.searchJaxrsElements(projectTerm, categoryTerm);
            return set;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public JaxrsResource findResource(IType resourceType) {
        if (resourceType == null) {
            return null;
        }
        try {
            this.readWriteLock.readLock().lock();
            Term projectTerm = new Term("javaProjectIdentifier", this.getJavaProject().getHandleIdentifier());
            Term categoryTerm = new Term("type", EnumElementCategory.RESOURCE.toString());
            Term typeTerm = new Term("javaClassName", resourceType.getFullyQualifiedName());
            JaxrsResource jaxrsResource = (JaxrsResource)this.searchJaxrsElement(projectTerm, categoryTerm, typeTerm);
            return jaxrsResource;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public Set<IJaxrsResourceMethod> findResourceMethodsByReturnedType(IType returnedType) {
        if (returnedType == null) {
            return Collections.emptySet();
        }
        try {
            this.readWriteLock.readLock().lock();
            Term projectTerm = new Term("javaProjectIdentifier", this.getJavaProject().getHandleIdentifier());
            Term categoryTerm = new Term("type", EnumElementCategory.RESOURCE_METHOD.toString());
            Term typeTerm = new Term("returnedTypeName", returnedType.getFullyQualifiedName());
            Set<IJaxrsResourceMethod> set = this.searchJaxrsElements(projectTerm, categoryTerm, typeTerm);
            return set;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public Set<IJaxrsResourceMethod> findResourceMethodsByAnnotation(String annotationClassName) {
        if (annotationClassName == null) {
            return Collections.emptySet();
        }
        try {
            this.readWriteLock.readLock().lock();
            Term projectTerm = new Term("javaProjectIdentifier", this.getJavaProject().getHandleIdentifier());
            Term categoryTerm = new Term("type", EnumElementCategory.RESOURCE_METHOD.toString());
            Term typeTerm = new Term("annotationName", annotationClassName);
            Set<IJaxrsResourceMethod> set = this.searchJaxrsElements(projectTerm, categoryTerm, typeTerm);
            return set;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public Set<IJaxrsResource> findResourcesByAnnotation(String annotationClassName) {
        if (annotationClassName == null) {
            return Collections.emptySet();
        }
        try {
            this.readWriteLock.readLock().lock();
            Term projectTerm = new Term("javaProjectIdentifier", this.getJavaProject().getHandleIdentifier());
            Term categoryTerm = new Term("type", EnumElementCategory.RESOURCE.toString());
            Term typeTerm = new Term("annotationName", annotationClassName);
            Set<IJaxrsResource> set = this.searchJaxrsElements(projectTerm, categoryTerm, typeTerm);
            return set;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public Set<JaxrsEndpoint> findEndpoints(IJaxrsElement element) {
        if (element == null) {
            return Collections.emptySet();
        }
        try {
            this.readWriteLock.readLock().lock();
            Term projectTerm = new Term("javaProjectIdentifier", this.getJavaProject().getHandleIdentifier());
            Term categoryTerm = new Term("type", EnumElementCategory.ENDPOINT.toString());
            Term jaxrsElementTerm = new Term("jaxrsElement", element.getIdentifier());
            Set<JaxrsEndpoint> set = this.searchJaxrsEndpoints(projectTerm, categoryTerm, jaxrsElementTerm);
            return set;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public Set<JaxrsEndpoint> findEndpoints(IJavaElement element) {
        if (element == null) {
            return Collections.emptySet();
        }
        try {
            this.readWriteLock.readLock().lock();
            Term projectTerm = new Term("javaProjectIdentifier", this.getJavaProject().getHandleIdentifier());
            Term categoryTerm = new Term("type", EnumElementCategory.ENDPOINT.toString());
            Term javaElementTerm = new Term("javaElement", element.getHandleIdentifier());
            Set<JaxrsEndpoint> set = this.searchJaxrsEndpoints(projectTerm, categoryTerm, javaElementTerm);
            return set;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public final Set<IJaxrsResource> findAllResources() {
        try {
            this.readWriteLock.readLock().lock();
            Term categoryTerm = new Term("type", EnumElementCategory.RESOURCE.toString());
            Set<IJaxrsResource> set = this.searchJaxrsElements(categoryTerm);
            return set;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public boolean add(JaxrsEndpoint endpoint) {
        try {
            this.readWriteLock.writeLock().lock();
            if (endpoint == null || this.endpoints.containsValue(endpoint)) {
                return false;
            }
            this.endpoints.put(endpoint.getIdentifier(), endpoint);
            this.indexationService.indexElement(endpoint);
            JBossJaxrsCorePlugin.notifyEndpointChanged(endpoint, 1);
            return true;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public List<IJaxrsEndpoint> getAllEndpoints() {
        return new ArrayList<IJaxrsEndpoint>(this.endpoints.values());
    }

    public JaxrsEndpoint getEndpoint(String identifier) {
        return this.endpoints.get(identifier);
    }

    public void removeEndpoints(IJaxrsElement removedElement) {
        try {
            this.readWriteLock.writeLock().lock();
            Set<JaxrsEndpoint> elementEndpoints = this.findEndpoints(removedElement);
            for (JaxrsEndpoint endpoint : elementEndpoints) {
                endpoint.remove();
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.javaProject == null ? 0 : this.javaProject.getHandleIdentifier().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public String toString() {
        return "JAX-RS Metamodel for project '" + this.javaProject.getElementName() + "'";
    }

    public String getStatus() {
        return "JAX-RS Metamodel for project '" + this.getProject().getName() + "' now has " + this.findAllApplications().size() + " Applications, " + this.findAllHttpMethods().size() + " HttpMethods, " + this.findAllResources().size() + " Resources and " + this.getAllEndpoints().size() + " Endpoints.";
    }
}

