/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JavaMethodSignature;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsJavaElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResourceField;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResourceMethod;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResourceProperty;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.search.JavaElementsSearcher;
import org.jboss.tools.ws.jaxrs.core.internal.utils.CollectionUtils;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.jdt.AnnotationUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.Flags;
import org.jboss.tools.ws.jaxrs.core.jdt.FlagsUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementKind;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsElement;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsResource;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsResourceField;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsResourceMethod;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsResourceProperty;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.JaxrsElementDelta;

public final class JaxrsResource
extends JaxrsJavaElement<IType>
implements IJaxrsResource {
    private final Map<String, JaxrsResourceField> resourceFields = new HashMap<String, JaxrsResourceField>();
    private final Map<String, JaxrsResourceProperty> resourceProperties = new HashMap<String, JaxrsResourceProperty>();
    private final Map<String, JaxrsResourceMethod> resourceMethods = new HashMap<String, JaxrsResourceMethod>();

    public static Builder from(IJavaElement javaElement, Set<String> httpMethodNames) throws JavaModelException {
        CompilationUnit ast = JdtUtils.parse(javaElement, (IProgressMonitor)new NullProgressMonitor());
        switch (javaElement.getElementType()) {
            case 5: {
                return new Builder(((ICompilationUnit)javaElement).findPrimaryType(), ast, httpMethodNames);
            }
            case 7: {
                return new Builder((IType)javaElement, ast, httpMethodNames);
            }
        }
        return null;
    }

    public static Builder from(IJavaElement javaElement, CompilationUnit ast, Set<String> httpMethodNames) {
        switch (javaElement.getElementType()) {
            case 5: {
                return new Builder(((ICompilationUnit)javaElement).findPrimaryType(), ast, httpMethodNames);
            }
            case 7: {
                return new Builder((IType)javaElement, ast, httpMethodNames);
            }
        }
        return null;
    }

    private JaxrsResource(Builder builder) {
        this(builder.javaType, (Map<String, Annotation>)builder.annotations, builder.metamodel, (JaxrsResource)null);
    }

    private JaxrsResource(IType javaType, Map<String, Annotation> annotations, JaxrsMetamodel metamodel, JaxrsResource primaryCopy) {
        super(javaType, annotations, metamodel, primaryCopy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JaxrsResource createWorkingCopy() {
        JaxrsResource jaxrsResource = this;
        synchronized (jaxrsResource) {
            JaxrsResource parentWorkingCopy = new JaxrsResource((IType)this.getJavaElement(), AnnotationUtils.createWorkingCopies(this.getAnnotations()), this.getMetamodel(), this);
            for (Map.Entry<String, JaxrsResourceField> entry : this.resourceFields.entrySet()) {
                entry.getValue().createWorkingCopy(parentWorkingCopy);
            }
            for (Map.Entry<String, JaxrsJavaElement> entry : this.resourceMethods.entrySet()) {
                ((JaxrsResourceMethod)entry.getValue()).createWorkingCopy(parentWorkingCopy);
            }
            for (Map.Entry<String, JaxrsJavaElement> entry : this.resourceProperties.entrySet()) {
                ((JaxrsResourceProperty)entry.getValue()).createWorkingCopy(parentWorkingCopy);
            }
            return parentWorkingCopy;
        }
    }

    @Override
    public JaxrsResource getWorkingCopy() {
        return (JaxrsResource)super.getWorkingCopy();
    }

    @Override
    public final boolean isRootResource() {
        return this.getPathAnnotation() != null;
    }

    @Override
    public boolean isSubresource() {
        return this.getPathAnnotation() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(IJavaElement javaElement, CompilationUnit ast) throws CoreException {
        JaxrsResource jaxrsResource = this;
        synchronized (jaxrsResource) {
            Flags annotationsFlags = FlagsUtils.computeElementFlags(this);
            JaxrsResource transientResource = JaxrsResource.from(javaElement, ast, this.getMetamodel().findAllHttpMethodNames()).build(false);
            Logger.debug("Updating {}\n\twith\n{}", this, transientResource);
            if (transientResource == null) {
                this.remove(annotationsFlags);
                return;
            }
            Flags updateAnnotationsFlags = this.updateAnnotations(transientResource.getAnnotations());
            JaxrsElementDelta delta = new JaxrsElementDelta((IJaxrsElement)this, 4, updateAnnotationsFlags);
            this.updateMethods(transientResource, ast);
            this.updateProperties(transientResource, ast);
            this.updateFields(transientResource, ast);
            if (this.isMarkedForRemoval()) {
                this.remove(annotationsFlags);
            } else if (this.hasMetamodel()) {
                this.getMetamodel().update(delta);
            }
        }
    }

    private void updateProperties(JaxrsResource transientResource, CompilationUnit ast) throws CoreException {
        List<JaxrsResourceProperty> allTransientInstanceProperties = transientResource.getAllProperties();
        List<JaxrsResourceProperty> allCurrentProperties = this.getAllProperties();
        List<JaxrsResourceProperty> addedProperties = CollectionUtils.difference(allTransientInstanceProperties, allCurrentProperties);
        for (JaxrsResourceProperty addedProperty : addedProperties) {
            JaxrsResourceProperty.from((IMethod)addedProperty.getJavaElement(), ast).buildInResource(this);
        }
        List<JaxrsResourceProperty> changedProperties = CollectionUtils.intersection(allCurrentProperties, allTransientInstanceProperties);
        for (JaxrsResourceProperty changedProperty : changedProperties) {
            changedProperty.update(transientResource.getProperties().get(changedProperty.getIdentifier()));
        }
        List<JaxrsResourceProperty> removedProperties = CollectionUtils.difference(allCurrentProperties, allTransientInstanceProperties);
        for (JaxrsResourceProperty removedProperty : removedProperties) {
            removedProperty.remove(Flags.NONE);
        }
    }

    private void updateFields(JaxrsResource transientResource, CompilationUnit ast) throws CoreException {
        List<JaxrsResourceField> allTransientInstanceFields = transientResource.getAllFields();
        List<JaxrsResourceField> allCurrentFields = this.getAllFields();
        List<JaxrsResourceField> addedFields = CollectionUtils.difference(allTransientInstanceFields, allCurrentFields);
        for (IJaxrsResourceField iJaxrsResourceField : addedFields) {
            JaxrsResourceField.from(iJaxrsResourceField.getJavaElement(), ast).withMetamodel(this.getMetamodel()).withParentResource(this).build();
        }
        List<JaxrsResourceField> list = CollectionUtils.intersection(allCurrentFields, allTransientInstanceFields);
        for (JaxrsResourceField changedField : list) {
            changedField.update(transientResource.getFields().get(changedField.getIdentifier()));
        }
        List<JaxrsResourceField> removedFields = CollectionUtils.difference(allCurrentFields, allTransientInstanceFields);
        for (JaxrsResourceField removedField : removedFields) {
            removedField.remove(FlagsUtils.computeElementFlags(removedField));
        }
    }

    private void updateMethods(JaxrsResource transientResource, CompilationUnit ast) throws CoreException {
        List<IJaxrsResourceMethod> allTransientInstanceMethods = transientResource.getAllMethods();
        List<IJaxrsResourceMethod> allCurrentMethods = this.getAllMethods();
        List<IJaxrsResourceMethod> addedMethods = CollectionUtils.difference(allTransientInstanceMethods, allCurrentMethods);
        for (IJaxrsResourceMethod addedMethod : addedMethods) {
            JaxrsResourceMethod.from(addedMethod.getJavaElement(), ast, this.getMetamodel().findAllHttpMethodNames()).buildInResource(this);
        }
        List<IJaxrsResourceMethod> changedMethods = CollectionUtils.intersection(allCurrentMethods, allTransientInstanceMethods);
        for (IJaxrsResourceMethod changedMethod : changedMethods) {
            ((JaxrsResourceMethod)changedMethod).update(transientResource.getMethods().get(changedMethod.getIdentifier()));
        }
        List<IJaxrsResourceMethod> removedMethods = CollectionUtils.difference(allCurrentMethods, allTransientInstanceMethods);
        for (IJaxrsResourceMethod removedMethod : removedMethods) {
            ((JaxrsResourceMethod)removedMethod).remove(Flags.NONE);
        }
    }

    @Override
    boolean isMarkedForRemoval() {
        boolean hasPathAnnotation = this.hasAnnotation("javax.ws.rs.Path");
        return !hasPathAnnotation && this.resourceMethods.size() <= 0;
    }

    @Override
    public final EnumElementKind getElementKind() {
        Annotation pathAnnotation = this.getAnnotation("javax.ws.rs.Path");
        if (pathAnnotation != null) {
            return EnumElementKind.ROOT_RESOURCE;
        }
        if (this.resourceMethods.size() > 0 || this.resourceFields.size() > 0) {
            return EnumElementKind.SUBRESOURCE;
        }
        return EnumElementKind.UNDEFINED_RESOURCE;
    }

    @Override
    public final String getName() {
        return ((IType)this.getJavaElement()).getFullyQualifiedName();
    }

    @Override
    public String getPathTemplate() {
        Annotation pathAnnotation = this.getAnnotation("javax.ws.rs.Path");
        if (pathAnnotation == null) {
            return null;
        }
        return pathAnnotation.getValue();
    }

    @Override
    public boolean hasPathTemplate() {
        Annotation pathAnnotation = this.getPathAnnotation();
        return pathAnnotation != null && pathAnnotation.getValue() != null;
    }

    public Annotation getPathAnnotation() {
        return this.getAnnotation("javax.ws.rs.Path");
    }

    @Override
    public Map<String, Annotation> getPathTemplateParameters() {
        HashMap<String, Annotation> proposals = new HashMap<String, Annotation>();
        proposals.putAll(AnnotationUtils.extractTemplateParameters(this.getPathAnnotation()));
        return proposals;
    }

    @Override
    public List<String> getConsumedMediaTypes() {
        Annotation consumesAnnotation = this.getAnnotation("javax.ws.rs.Consumes");
        if (consumesAnnotation != null) {
            return consumesAnnotation.getValues("value");
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getProducedMediaTypes() {
        Annotation producesAnnotation = this.getAnnotation("javax.ws.rs.Produces");
        if (producesAnnotation != null) {
            return producesAnnotation.getValues("value");
        }
        return Collections.emptyList();
    }

    public Annotation getProducesAnnotation() {
        return this.getAnnotation("javax.ws.rs.Produces");
    }

    @Override
    public final List<IJaxrsResourceMethod> getAllMethods() {
        return Collections.unmodifiableList(new ArrayList<JaxrsResourceMethod>(this.resourceMethods.values()));
    }

    public final List<JaxrsResourceField> getAllFields() {
        return Collections.unmodifiableList(new ArrayList<JaxrsResourceField>(this.resourceFields.values()));
    }

    public List<JaxrsResourceProperty> getAllProperties() {
        return Collections.unmodifiableList(new ArrayList<JaxrsResourceProperty>(this.resourceProperties.values()));
    }

    @Override
    public void resetProblemLevel() {
        super.resetProblemLevel();
        for (Map.Entry<String, JaxrsResourceMethod> entry : this.resourceMethods.entrySet()) {
            entry.getValue().resetProblemLevel();
        }
        for (Map.Entry<String, JaxrsJavaElement> entry : this.resourceFields.entrySet()) {
            ((JaxrsResourceField)entry.getValue()).resetProblemLevel();
        }
        for (Map.Entry<String, JaxrsJavaElement> entry : this.resourceProperties.entrySet()) {
            ((JaxrsResourceProperty)entry.getValue()).resetProblemLevel();
        }
    }

    public List<String> getPathParamValues() {
        Annotation aggregatorFieldPathParamAnnotation;
        ArrayList<String> pathParamValues = new ArrayList<String>();
        for (JaxrsResourceField field : this.resourceFields.values()) {
            aggregatorFieldPathParamAnnotation = field.getAnnotation("javax.ws.rs.PathParam");
            if (aggregatorFieldPathParamAnnotation == null || aggregatorFieldPathParamAnnotation.getValue() == null) continue;
            pathParamValues.add(aggregatorFieldPathParamAnnotation.getValue());
        }
        for (JaxrsResourceProperty properties : this.resourceProperties.values()) {
            aggregatorFieldPathParamAnnotation = properties.getAnnotation("javax.ws.rs.PathParam");
            if (aggregatorFieldPathParamAnnotation == null || aggregatorFieldPathParamAnnotation.getValue() == null) continue;
            pathParamValues.add(aggregatorFieldPathParamAnnotation.getValue());
        }
        return pathParamValues;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder().append(super.toString());
        for (IJaxrsResourceField iJaxrsResourceField : this.getAllFields()) {
            builder.append("\n\t").append(iJaxrsResourceField.toString());
        }
        for (IJaxrsResourceProperty iJaxrsResourceProperty : this.getAllProperties()) {
            builder.append("\n\t").append(iJaxrsResourceProperty.toString());
        }
        for (IJaxrsResourceMethod iJaxrsResourceMethod : this.getAllMethods()) {
            builder.append("\n\t").append(iJaxrsResourceMethod.toString());
        }
        return builder.toString();
    }

    protected void addField(JaxrsResourceField resourceField) {
        if (resourceField != null) {
            this.resourceFields.put(((IField)resourceField.getJavaElement()).getHandleIdentifier(), resourceField);
        }
    }

    public Map<String, JaxrsResourceField> getFields() {
        return Collections.unmodifiableMap(this.resourceFields);
    }

    protected void removeField(IJaxrsResourceField resourceField) throws CoreException {
        this.resourceFields.remove(resourceField.getJavaElement().getHandleIdentifier());
    }

    protected void addProperty(JaxrsResourceProperty resourceProperty) {
        if (resourceProperty != null) {
            this.resourceProperties.put(((IMethod)resourceProperty.getJavaElement()).getHandleIdentifier(), resourceProperty);
        }
    }

    public Map<String, JaxrsResourceProperty> getProperties() {
        return Collections.unmodifiableMap(this.resourceProperties);
    }

    protected void removeProperty(JaxrsResourceProperty resourceProperty) throws CoreException {
        this.resourceProperties.remove(((IMethod)resourceProperty.getJavaElement()).getHandleIdentifier());
    }

    protected void addMethod(JaxrsResourceMethod resourceMethod) {
        if (resourceMethod != null) {
            this.resourceMethods.put(((IMethod)resourceMethod.getJavaElement()).getHandleIdentifier(), resourceMethod);
        }
    }

    public Map<String, JaxrsResourceMethod> getMethods() {
        return Collections.unmodifiableMap(this.resourceMethods);
    }

    protected void removeMethod(IJaxrsResourceMethod method) throws CoreException {
        this.resourceMethods.remove(method.getJavaElement().getHandleIdentifier());
    }

    public JaxrsResourceField getField(String fieldName) {
        for (IJaxrsResourceField iJaxrsResourceField : this.resourceFields.values()) {
            if (!iJaxrsResourceField.getJavaElement().getElementName().equals(fieldName)) continue;
            return (JaxrsResourceField)iJaxrsResourceField;
        }
        return null;
    }

    public JaxrsResourceProperty getProperty(String propertyName) {
        for (IJaxrsResourceProperty iJaxrsResourceProperty : this.resourceProperties.values()) {
            if (!iJaxrsResourceProperty.getJavaElement().getElementName().equals(propertyName)) continue;
            return (JaxrsResourceProperty)iJaxrsResourceProperty;
        }
        return null;
    }

    public List<JaxrsResourceField> getFieldsAnnotatedWith(String annotationName) {
        ArrayList<JaxrsResourceField> annotatedFields = new ArrayList<JaxrsResourceField>();
        for (Map.Entry<String, JaxrsResourceField> entry : this.resourceFields.entrySet()) {
            JaxrsResourceField field = entry.getValue();
            if (!field.hasAnnotation(annotationName)) continue;
            annotatedFields.add(field);
        }
        return annotatedFields;
    }

    public JaxrsResourceField getFieldAnnotatedWith(String annotationName, String annotationValue) {
        for (Map.Entry<String, JaxrsResourceField> entry : this.resourceFields.entrySet()) {
            JaxrsResourceField field = entry.getValue();
            Annotation annotation = field.getAnnotation(annotationName);
            if (annotation == null || !annotationValue.equals(annotation.getValue())) continue;
            return field;
        }
        return null;
    }

    public List<JaxrsResourceProperty> getPropertiesAnnotatedWith(String annotationName) {
        ArrayList<JaxrsResourceProperty> annotatedProperties = new ArrayList<JaxrsResourceProperty>();
        for (Map.Entry<String, JaxrsResourceProperty> entry : this.resourceProperties.entrySet()) {
            JaxrsResourceProperty property = entry.getValue();
            if (!property.hasAnnotation(annotationName)) continue;
            annotatedProperties.add(property);
        }
        return annotatedProperties;
    }

    public JaxrsResourceProperty getPropertyAnnotatedWith(String annotationName, String annotationValue) {
        for (Map.Entry<String, JaxrsResourceProperty> entry : this.resourceProperties.entrySet()) {
            JaxrsResourceProperty property = entry.getValue();
            Annotation annotation = property.getAnnotation(annotationName);
            if (annotation == null || !annotationValue.equals(annotation.getValue())) continue;
            return property;
        }
        return null;
    }

    @Override
    public void remove(Flags flags) throws CoreException {
        super.remove(flags);
        for (IJaxrsResourceMethod iJaxrsResourceMethod : this.getAllMethods()) {
            ((JaxrsResourceMethod)iJaxrsResourceMethod).remove(FlagsUtils.computeElementFlags(iJaxrsResourceMethod));
        }
        for (IJaxrsResourceField iJaxrsResourceField : this.getAllFields()) {
            ((JaxrsResourceField)iJaxrsResourceField).remove(FlagsUtils.computeElementFlags(iJaxrsResourceField));
        }
        for (IJaxrsResourceProperty iJaxrsResourceProperty : this.getAllProperties()) {
            ((JaxrsResourceProperty)iJaxrsResourceProperty).remove(FlagsUtils.computeElementFlags(iJaxrsResourceProperty));
        }
    }

    /* synthetic */ JaxrsResource(Builder builder, JaxrsResource jaxrsResource) {
        this(builder);
    }

    public static final class Builder {
        private final IType javaType;
        private final CompilationUnit ast;
        private final Set<String> httpMethodNames;
        private Map<String, Annotation> annotations;
        private JaxrsMetamodel metamodel;

        private Builder(IType javaType, CompilationUnit ast, Set<String> httpMethodNames) {
            this.javaType = javaType;
            this.ast = ast;
            this.httpMethodNames = httpMethodNames;
        }

        public Builder withMetamodel(JaxrsMetamodel metamodel) {
            this.metamodel = metamodel;
            return this;
        }

        public JaxrsResource build() throws CoreException {
            return this.build(true);
        }

        JaxrsResource build(boolean joinMetamodel) throws CoreException {
            JaxrsResource resource;
            long start;
            block9: {
                block8: {
                    start = System.currentTimeMillis();
                    if (this.javaType != null && this.javaType.exists()) break block8;
                    long end = System.currentTimeMillis();
                    Logger.tracePerf("Built JAX-RS Resource in {}ms", end - start);
                    return null;
                }
                try {
                    JdtUtils.makeConsistentIfNecessary((IMember)this.javaType);
                    this.annotations = JdtUtils.resolveAllAnnotations((IMember)this.javaType, this.ast);
                    resource = new JaxrsResource(this, null);
                    IField[] iFieldArray = this.javaType.getFields();
                    int n = iFieldArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IField javaField = iFieldArray[n2];
                        JaxrsResourceField.from(javaField, this.ast).withParentResource(resource).withMetamodel(this.metamodel).build();
                        ++n2;
                    }
                    iFieldArray = this.javaType.getMethods();
                    n = iFieldArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        IField javaMethod = iFieldArray[n2];
                        JaxrsResourceProperty.from((IMethod)javaMethod, this.ast).buildInResource(resource);
                        ++n2;
                    }
                    Set<IMethod> javaMethods = JavaElementsSearcher.findResourceMethods((IJavaElement)this.javaType, this.httpMethodNames, (IProgressMonitor)new NullProgressMonitor());
                    for (IMethod javaMethod : javaMethods) {
                        JavaMethodSignature methodSignature = JdtUtils.resolveMethodSignature(javaMethod, this.ast);
                        JaxrsResourceMethod.from(javaMethod, this.ast, this.httpMethodNames).withJavaMethodSignature(methodSignature).buildInResource(resource);
                    }
                    if (!resource.isSubresource() || !resource.resourceMethods.isEmpty()) break block9;
                    Logger.trace("Returning a *null* element for {}", this.javaType.getElementName());
                }
                catch (Throwable throwable) {
                    long end = System.currentTimeMillis();
                    Logger.tracePerf("Built JAX-RS Resource in {}ms", end - start);
                    throw throwable;
                }
                long end = System.currentTimeMillis();
                Logger.tracePerf("Built JAX-RS Resource in {}ms", end - start);
                return null;
            }
            if (joinMetamodel) {
                resource.joinMetamodel();
            }
            JaxrsResource jaxrsResource = resource;
            long end = System.currentTimeMillis();
            Logger.tracePerf("Built JAX-RS Resource in {}ms", end - start);
            return jaxrsResource;
        }
    }
}

