/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JavaMethodSignature;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParamAnnotations;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResource;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResourceElement;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.jdt.AnnotationUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.Flags;
import org.jboss.tools.ws.jaxrs.core.jdt.FlagsUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.SourceType;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementKind;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsElement;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsResourceProperty;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.JaxrsElementDelta;

public class JaxrsResourceProperty
extends JaxrsResourceElement<IMethod>
implements IJaxrsResourceProperty {
    private JavaMethodSignature methodSignature;

    public static Builder from(IMethod method, CompilationUnit ast) {
        return new Builder(method, ast);
    }

    private JaxrsResourceProperty(Builder builder) {
        this(builder.javaMethod, builder.annotations, builder.metamodel, builder.javaPropertyType, builder.methodSignature, builder.parentResource, null);
    }

    private JaxrsResourceProperty(IMethod javaMethod, Map<String, Annotation> annotations, JaxrsMetamodel metamodel, SourceType javaPropertyType, JavaMethodSignature methodSignature, JaxrsResource parentResource, JaxrsResourceProperty primaryCopy) {
        super(javaMethod, annotations, metamodel, javaPropertyType, parentResource, primaryCopy);
        this.methodSignature = methodSignature;
        if (this.getParentResource() != null) {
            this.getParentResource().addProperty(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JaxrsResourceProperty createWorkingCopy() {
        JaxrsResourceProperty jaxrsResourceProperty = this;
        synchronized (jaxrsResourceProperty) {
            JaxrsResource parentWorkingCopy = this.getParentResource().getWorkingCopy();
            return parentWorkingCopy.getProperties().get(((IMethod)this.javaElement).getHandleIdentifier());
        }
    }

    protected JaxrsResourceProperty createWorkingCopy(JaxrsResource parentWorkingCopy) {
        return new JaxrsResourceProperty((IMethod)this.getJavaElement(), AnnotationUtils.createWorkingCopies(this.getAnnotations()), this.getMetamodel(), this.getType(), this.getMethodSignature().createWorkingcopy(), parentWorkingCopy, this);
    }

    @Override
    public JaxrsResourceProperty getWorkingCopy() {
        return (JaxrsResourceProperty)super.getWorkingCopy();
    }

    @Override
    public JaxrsResource getParentResource() {
        return this.parentResource;
    }

    public JavaMethodSignature getMethodSignature() {
        return this.methodSignature;
    }

    @Override
    public void update(IJavaElement javaElement, CompilationUnit ast) throws CoreException {
        if (javaElement == null) {
            this.remove(FlagsUtils.computeElementFlags(this));
        } else {
            switch (javaElement.getElementType()) {
                case 5: {
                    IType primaryType = ((ICompilationUnit)javaElement).findPrimaryType();
                    if (primaryType == null) break;
                    IField field = primaryType.getField(((IMethod)this.getJavaElement()).getElementName());
                    this.update((IJavaElement)field, ast);
                    break;
                }
                case 9: {
                    this.update(JaxrsResourceProperty.from((IMethod)javaElement, ast).buildTransient());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(JaxrsResourceProperty transientProperty) throws CoreException {
        JaxrsResourceProperty jaxrsResourceProperty = this;
        synchronized (jaxrsResourceProperty) {
            Flags annotationsFlags = FlagsUtils.computeElementFlags(this);
            if (transientProperty == null) {
                this.remove(annotationsFlags);
            } else {
                Flags updateAnnotationsFlags = this.updateAnnotations(transientProperty.getAnnotations());
                JaxrsElementDelta delta = new JaxrsElementDelta((IJaxrsElement)this, 4, updateAnnotationsFlags);
                if (updateAnnotationsFlags.hasValue(2) && this.isMarkedForRemoval()) {
                    this.remove(annotationsFlags);
                } else if (this.hasMetamodel()) {
                    this.getMetamodel().update(delta);
                }
            }
        }
    }

    @Override
    boolean isMarkedForRemoval() {
        boolean hasPathParamAnnotation = this.hasAnnotation("javax.ws.rs.PathParam");
        boolean hasQueryParamAnnotation = this.hasAnnotation("javax.ws.rs.QueryParam");
        boolean hasMatrixParamAnnotation = this.hasAnnotation("javax.ws.rs.MatrixParam");
        return !hasPathParamAnnotation && !hasQueryParamAnnotation && !hasMatrixParamAnnotation;
    }

    @Override
    public void remove(Flags flags) throws CoreException {
        this.getParentResource().removeProperty(this);
        super.remove(flags);
    }

    public Annotation getPathParamAnnotation() {
        return this.getAnnotation("javax.ws.rs.PathParam");
    }

    public Annotation getQueryParamAnnotation() {
        return this.getAnnotation("javax.ws.rs.QueryParam");
    }

    public Annotation getMatrixParamAnnotation() {
        return this.getAnnotation("javax.ws.rs.MatrixParam");
    }

    public Annotation getDefaultValueAnnotation() {
        return this.getAnnotation("javax.ws.rs.DefaultValue");
    }

    public Annotation getBeanParamAnnotation() {
        return this.getAnnotation("javax.ws.rs.BeanParam");
    }

    @Override
    public EnumElementKind getElementKind() {
        if (this.getPathParamAnnotation() != null) {
            return EnumElementKind.PATH_PARAM_PROPERTY;
        }
        if (this.getQueryParamAnnotation() != null) {
            return EnumElementKind.QUERY_PARAM_PROPERTY;
        }
        if (this.getMatrixParamAnnotation() != null) {
            return EnumElementKind.MATRIX_PARAM_PROPERTY;
        }
        if (this.getBeanParamAnnotation() != null) {
            return EnumElementKind.BEAN_PARAM_PROPERTY;
        }
        return EnumElementKind.UNDEFINED_RESOURCE_PROPERTY;
    }

    /* synthetic */ JaxrsResourceProperty(Builder builder, JaxrsResourceProperty jaxrsResourceProperty) {
        this(builder);
    }

    public static class Builder {
        private final IMethod javaMethod;
        private final CompilationUnit ast;
        private Map<String, Annotation> annotations;
        private JaxrsResource parentResource;
        private JaxrsMetamodel metamodel;
        private SourceType javaPropertyType;
        private JavaMethodSignature methodSignature;

        private Builder(IMethod javaMethod, CompilationUnit ast) {
            this.javaMethod = javaMethod;
            this.ast = ast;
        }

        public Builder withAnnotations(Map<String, Annotation> annotations) {
            this.annotations = annotations;
            return this;
        }

        public Builder withJavaMethodSignature(JavaMethodSignature javaMethodSignature) {
            this.methodSignature = javaMethodSignature;
            return this;
        }

        public JaxrsResourceProperty buildTransient() throws CoreException {
            return this.buildInResource(null);
        }

        JaxrsResourceProperty buildInResource(JaxrsResource parentResource) throws CoreException {
            long start;
            block13: {
                block12: {
                    block11: {
                        block10: {
                            start = System.currentTimeMillis();
                            try {
                                if (this.javaMethod != null && this.javaMethod.exists() && this.javaMethod.isStructureKnown()) break block10;
                            }
                            catch (Throwable throwable) {
                                long end = System.currentTimeMillis();
                                Logger.tracePerf("Built JAX-RS Resource Method in {}ms", end - start);
                                throw throwable;
                            }
                            long end = System.currentTimeMillis();
                            Logger.tracePerf("Built JAX-RS Resource Method in {}ms", end - start);
                            return null;
                        }
                        JdtUtils.makeConsistentIfNecessary((IMember)this.javaMethod);
                        this.parentResource = parentResource;
                        if (parentResource != null) {
                            this.metamodel = parentResource.getMetamodel();
                        }
                        if (this.annotations == null) {
                            this.annotations = JdtUtils.resolveAllAnnotations((IMember)this.javaMethod, this.ast);
                        }
                        if (JaxrsParamAnnotations.matchesAtLeastOne(this.annotations.keySet())) break block11;
                        long end = System.currentTimeMillis();
                        Logger.tracePerf("Built JAX-RS Resource Method in {}ms", end - start);
                        return null;
                    }
                    if (this.methodSignature == null) {
                        this.methodSignature = JdtUtils.resolveMethodSignature(this.javaMethod, this.ast);
                    }
                    if (this.methodSignature != null) break block12;
                    long end = System.currentTimeMillis();
                    Logger.tracePerf("Built JAX-RS Resource Method in {}ms", end - start);
                    return null;
                }
                this.javaPropertyType = JdtUtils.getPropertyType(this.methodSignature);
                if (this.javaPropertyType != null) break block13;
                long end = System.currentTimeMillis();
                Logger.tracePerf("Built JAX-RS Resource Method in {}ms", end - start);
                return null;
            }
            JaxrsResourceProperty resourceProperty = new JaxrsResourceProperty(this, null);
            if (parentResource != null) {
                resourceProperty.joinMetamodel();
            }
            JaxrsResourceProperty jaxrsResourceProperty = resourceProperty;
            long end = System.currentTimeMillis();
            Logger.tracePerf("Built JAX-RS Resource Method in {}ms", end - start);
            return jaxrsResourceProperty;
        }
    }
}

