/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.search;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsHttpMethod;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsJavaApplication;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsJavaElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsNameBinding;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParamConverterProvider;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParameterAggregator;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParameterAggregatorField;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParameterAggregatorProperty;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsProvider;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResource;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResourceField;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResourceMethod;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResourceProperty;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsWebxmlApplication;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.search.IndexedObjectType;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementCategory;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementKind;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsApplication;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsElement;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsEndpoint;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsResourceMethod;

public class LuceneDocumentFactory {
    public static Term getIdentifierTerm(IMarker marker) {
        return new Term("markerIdentifier", LuceneDocumentFactory.getIdentifierValue(marker));
    }

    public static Term getJavaClassNameTerm(String className) {
        return new Term("javaClassName", className);
    }

    public static Term getElementCategoryTerm(EnumElementCategory category) {
        return new Term("type", category.toString());
    }

    private static String getIdentifierValue(IMarker marker) {
        return String.valueOf(IndexedObjectType.PROBLEM_MARKER.getPrefix()) + Long.toString(marker.getId());
    }

    public static Term getIdentifierTerm(IJaxrsElement element) {
        return new Term("elementIdentifier", LuceneDocumentFactory.getIdentifierValue(element));
    }

    private static String getIdentifierValue(IJaxrsElement element) {
        return String.valueOf(IndexedObjectType.JAX_RS_ELEMENT.getPrefix()) + element.getIdentifier();
    }

    public static Term getIdentifierTerm(IJavaElement element) {
        return new Term("elementIdentifier", LuceneDocumentFactory.getIdentifierValue(element));
    }

    private static String getIdentifierValue(IJavaElement element) {
        return String.valueOf(IndexedObjectType.JAX_RS_ELEMENT.getPrefix()) + element.getHandleIdentifier();
    }

    public static Term getIdentifierTerm(IJaxrsEndpoint endpoint) {
        return new Term("elementIdentifier", LuceneDocumentFactory.getIdentifierValue(endpoint));
    }

    public static String getIdentifierValue(IJaxrsEndpoint endpoint) {
        return String.valueOf(IndexedObjectType.JAX_RS_ENDPOINT.getPrefix()) + endpoint.getIdentifier();
    }

    public static Term getResourcePathTerm(IResource resource) {
        return new Term("resource", resource.getFullPath().toPortableString());
    }

    public static Term getMarkerTypeTerm() {
        return new Term("type", IMarker.class.getSimpleName());
    }

    public static Document createDocument(IJaxrsElement element) {
        switch (element.getElementKind().getCategory()) {
            case APPLICATION: {
                if (((IJaxrsApplication)element).isJavaApplication()) {
                    return LuceneDocumentFactory.createJavaApplicationDocument((JaxrsJavaApplication)element);
                }
                return LuceneDocumentFactory.createWebxmlApplicationDocument((JaxrsWebxmlApplication)element);
            }
            case HTTP_METHOD: {
                return LuceneDocumentFactory.createHttpMethodDocument((JaxrsHttpMethod)element);
            }
            case NAME_BINDING: {
                return LuceneDocumentFactory.createNameBindingDocument((JaxrsNameBinding)element);
            }
            case PARAM_CONVERTER_PROVIDER: {
                return LuceneDocumentFactory.createParamConverterProviderDocument((JaxrsParamConverterProvider)element);
            }
            case PROVIDER: {
                return LuceneDocumentFactory.createProviderDocument((JaxrsProvider)element);
            }
            case RESOURCE: {
                return LuceneDocumentFactory.createResourceDocument((JaxrsResource)element);
            }
            case RESOURCE_FIELD: {
                return LuceneDocumentFactory.createResourceFieldDocument((JaxrsResourceField)element);
            }
            case RESOURCE_PROPERTY: {
                return LuceneDocumentFactory.createResourcePropertyDocument((JaxrsResourceProperty)element);
            }
            case RESOURCE_METHOD: {
                return LuceneDocumentFactory.createResourceMethodDocument((JaxrsResourceMethod)element);
            }
            case PARAMETER_AGGREGATOR: {
                return LuceneDocumentFactory.createParameterAggregatorDocument((JaxrsParameterAggregator)element);
            }
            case PARAMETER_AGGREGATOR_FIELD: {
                return LuceneDocumentFactory.createParameterAggregatorFieldDocument((JaxrsParameterAggregatorField)element);
            }
            case PARAMETER_AGGREGATOR_PROPERTY: {
                return LuceneDocumentFactory.createParameterAggregatorPropertyDocument((JaxrsParameterAggregatorProperty)element);
            }
            case ENDPOINT: 
            case UNDEFINED: {
                break;
            }
        }
        return null;
    }

    public static Document createDocument(IJaxrsEndpoint endpoint) {
        Document document = new Document();
        LuceneDocumentFactory.addFieldToDocument(document, "elementIdentifier", LuceneDocumentFactory.getIdentifierValue(endpoint));
        LuceneDocumentFactory.addFieldToDocument(document, "javaProjectIdentifier", LuceneDocumentFactory.getHandleIdentifier((IJavaElement)endpoint.getJavaProject()));
        LuceneDocumentFactory.addFieldToDocument(document, "type", endpoint.getElementCategory().toString());
        LuceneDocumentFactory.addFieldToDocument(document, "consumedMediaType", endpoint.getConsumedMediaTypes());
        LuceneDocumentFactory.addFieldToDocument(document, "producedMediaType", endpoint.getProducedMediaTypes());
        LuceneDocumentFactory.addFieldToDocument(document, "uriPathTemplate", endpoint.getUriPathTemplate());
        if (endpoint.getHttpMethod() != null) {
            LuceneDocumentFactory.addFieldToDocument(document, "httpVerb", endpoint.getHttpMethod().getHttpVerb());
        }
        if (endpoint.getApplication() != null) {
            LuceneDocumentFactory.addFieldToDocument(document, "jaxrsElement", endpoint.getApplication().getIdentifier());
        }
        LuceneDocumentFactory.addFieldToDocument(document, "jaxrsElement", endpoint.getHttpMethod().getIdentifier());
        for (IJaxrsResourceMethod resourceMethod : endpoint.getResourceMethods()) {
            LuceneDocumentFactory.addFieldToDocument(document, "jaxrsElement", resourceMethod.getIdentifier());
            LuceneDocumentFactory.addFieldToDocument(document, "javaElement", resourceMethod.getJavaElement().getHandleIdentifier());
            JaxrsResource parentResource = (JaxrsResource)resourceMethod.getParentResource();
            LuceneDocumentFactory.addFieldToDocument(document, "jaxrsElement", parentResource.getIdentifier());
            LuceneDocumentFactory.addFieldToDocument(document, "javaElement", ((IType)parentResource.getJavaElement()).getHandleIdentifier());
            for (JaxrsResourceField resourceField : parentResource.getAllFields()) {
                LuceneDocumentFactory.addFieldToDocument(document, "jaxrsElement", resourceField.getIdentifier());
                LuceneDocumentFactory.addFieldToDocument(document, "javaElement", ((IField)resourceField.getJavaElement()).getHandleIdentifier());
            }
            for (JaxrsResourceProperty resourceProperty : parentResource.getAllProperties()) {
                LuceneDocumentFactory.addFieldToDocument(document, "jaxrsElement", resourceProperty.getIdentifier());
                LuceneDocumentFactory.addFieldToDocument(document, "javaElement", ((IMethod)resourceProperty.getJavaElement()).getHandleIdentifier());
            }
        }
        return document;
    }

    private static void addFieldToDocument(Document document, String name, String value) {
        if (name == null || value == null) {
            return;
        }
        document.add((Fieldable)new Field(name, value, Field.Store.YES, Field.Index.NOT_ANALYZED));
    }

    private static void addFieldToDocument(Document document, String name, Collection<String> values) {
        if (name == null || values == null || values.isEmpty()) {
            return;
        }
        for (String value : values) {
            document.add((Fieldable)new Field(name, value, Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
    }

    private static String getHandleIdentifier(IJavaElement javaElement) {
        if (javaElement == null) {
            return null;
        }
        return javaElement.getHandleIdentifier();
    }

    private static Document createBaseDocument(JaxrsJavaElement<?> element) {
        Document document = new Document();
        LuceneDocumentFactory.addFieldToDocument(document, "javaProjectIdentifier", LuceneDocumentFactory.getHandleIdentifier((IJavaElement)element.getMetamodel().getJavaProject()));
        LuceneDocumentFactory.addFieldToDocument(document, "type", element.getElementKind().getCategory().toString());
        LuceneDocumentFactory.addFieldToDocument(document, "elementIdentifier", LuceneDocumentFactory.getIdentifierValue(element));
        if (element.getJavaElement() != null) {
            LuceneDocumentFactory.addFieldToDocument(document, "javaElement", Boolean.TRUE.toString());
            LuceneDocumentFactory.addFieldToDocument(document, "compilationUnitIdentifier", LuceneDocumentFactory.getHandleIdentifier(((IMember)element.getJavaElement()).getAncestor(5)));
            LuceneDocumentFactory.addFieldToDocument(document, "packageFragmentRootIdentifier", LuceneDocumentFactory.getHandleIdentifier(((IMember)element.getJavaElement()).getAncestor(3)));
            if (((IMember)element.getJavaElement()).getElementType() == 7) {
                LuceneDocumentFactory.addFieldToDocument(document, "javaClassName", ((IType)element.getJavaElement()).getFullyQualifiedName());
                if (element.getResource() != null) {
                    LuceneDocumentFactory.addFieldToDocument(document, "resource", element.getResource().getFullPath().toPortableString());
                }
            }
        }
        for (Map.Entry<String, Annotation> entry : element.getAnnotations().entrySet()) {
            LuceneDocumentFactory.addFieldToDocument(document, "annotationName", entry.getValue().getFullyQualifiedName());
            LuceneDocumentFactory.addFieldToDocument(document, "parentIdentifier", LuceneDocumentFactory.getHandleIdentifier(entry.getValue().getJavaParent()));
        }
        return document;
    }

    private static Document createJavaApplicationDocument(JaxrsJavaApplication javaApplication) {
        Document document = LuceneDocumentFactory.createBaseDocument(javaApplication);
        LuceneDocumentFactory.addFieldToDocument(document, "applicationPath", javaApplication.getApplicationPath());
        LuceneDocumentFactory.addFieldToDocument(document, "javaApplication", Boolean.TRUE.toString());
        LuceneDocumentFactory.addFieldToDocument(document, "javaApplicationOverriden", Boolean.toString(javaApplication.isOverriden()));
        LuceneDocumentFactory.addFieldToDocument(document, "resource", javaApplication.getResource().getFullPath().toPortableString());
        return document;
    }

    private static Document createParameterAggregatorDocument(JaxrsParameterAggregator parameterAggregator) {
        Document document = LuceneDocumentFactory.createBaseDocument(parameterAggregator);
        return document;
    }

    private static Document createParameterAggregatorFieldDocument(JaxrsParameterAggregatorField parameterAggregatorField) {
        Document document = LuceneDocumentFactory.createBaseDocument(parameterAggregatorField);
        return document;
    }

    private static Document createParameterAggregatorPropertyDocument(JaxrsParameterAggregatorProperty parameterAggregatorMethod) {
        Document document = LuceneDocumentFactory.createBaseDocument(parameterAggregatorMethod);
        if (parameterAggregatorMethod.getType() != null) {
            LuceneDocumentFactory.addFieldToDocument(document, "type", parameterAggregatorMethod.getType().getErasureName());
            List<IType> typeArguments = parameterAggregatorMethod.getType().getTypeArguments();
            for (IType typeArg : typeArguments) {
                LuceneDocumentFactory.addFieldToDocument(document, "type", typeArg.getFullyQualifiedName());
            }
        }
        return document;
    }

    private static Document createWebxmlApplicationDocument(JaxrsWebxmlApplication webxmlApplication) {
        Document document = new Document();
        LuceneDocumentFactory.addFieldToDocument(document, "javaProjectIdentifier", webxmlApplication.getMetamodel().getJavaProject().getHandleIdentifier());
        LuceneDocumentFactory.addFieldToDocument(document, "type", webxmlApplication.getElementKind().getCategory().toString());
        LuceneDocumentFactory.addFieldToDocument(document, "elementIdentifier", LuceneDocumentFactory.getIdentifierValue(webxmlApplication));
        LuceneDocumentFactory.addFieldToDocument(document, "webXmlApplication", Boolean.TRUE.toString());
        LuceneDocumentFactory.addFieldToDocument(document, "webXmlApplicationOverridesJavaApplication", Boolean.toString(webxmlApplication.isOverride()));
        LuceneDocumentFactory.addFieldToDocument(document, "resource", webxmlApplication.getResource().getFullPath().toPortableString());
        LuceneDocumentFactory.addFieldToDocument(document, "applicationPath", webxmlApplication.getApplicationPath());
        LuceneDocumentFactory.addFieldToDocument(document, "javaClassName", webxmlApplication.getJavaClassName());
        return document;
    }

    private static Document createHttpMethodDocument(JaxrsHttpMethod httpMethod) {
        Document document = LuceneDocumentFactory.createBaseDocument(httpMethod);
        LuceneDocumentFactory.addFieldToDocument(document, "httpVerb", httpMethod.getHttpVerb());
        LuceneDocumentFactory.addFieldToDocument(document, "javaClassName", httpMethod.getJavaClassName());
        if (httpMethod.isBuiltIn()) {
            LuceneDocumentFactory.addFieldToDocument(document, "builtInHttpMethod", "true");
        }
        return document;
    }

    private static Document createNameBindingDocument(JaxrsNameBinding nameBinding) {
        Document document = LuceneDocumentFactory.createBaseDocument(nameBinding);
        return document;
    }

    private static Document createProviderDocument(JaxrsProvider provider) {
        Document document = LuceneDocumentFactory.createBaseDocument(provider);
        for (Map.Entry<EnumElementKind, IType> entry : provider.getProvidedTypes().entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            LuceneDocumentFactory.addFieldToDocument(document, "providerKind:" + entry.getKey().toString(), entry.getValue().getFullyQualifiedName());
        }
        LuceneDocumentFactory.addFieldToDocument(document, "consumedMediaType", provider.getConsumedMediaTypes());
        LuceneDocumentFactory.addFieldToDocument(document, "producedMediaType", provider.getProducedMediaTypes());
        return document;
    }

    private static Document createParamConverterProviderDocument(JaxrsParamConverterProvider paramConverterProvider) {
        Document document = LuceneDocumentFactory.createBaseDocument(paramConverterProvider);
        return document;
    }

    private static Document createResourceDocument(JaxrsResource resource) {
        Document document = LuceneDocumentFactory.createBaseDocument(resource);
        return document;
    }

    private static Document createResourceFieldDocument(JaxrsResourceField resourceField) {
        Document document = LuceneDocumentFactory.createBaseDocument(resourceField);
        return document;
    }

    private static Document createResourcePropertyDocument(JaxrsResourceProperty resourceProperty) {
        Document document = LuceneDocumentFactory.createBaseDocument(resourceProperty);
        return document;
    }

    private static Document createResourceMethodDocument(JaxrsResourceMethod resourceMethod) {
        Document document = LuceneDocumentFactory.createBaseDocument(resourceMethod);
        if (resourceMethod.getReturnedType() != null) {
            LuceneDocumentFactory.addFieldToDocument(document, "returnedTypeName", resourceMethod.getReturnedType().getErasureName());
            List<IType> typeArguments = resourceMethod.getReturnedType().getTypeArguments();
            for (IType typeArg : typeArguments) {
                LuceneDocumentFactory.addFieldToDocument(document, "type", typeArg.getFullyQualifiedName());
            }
        }
        return document;
    }
}

