/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.jdt;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JavaMethodSignature;
import org.jboss.tools.ws.jaxrs.core.internal.utils.CollectionUtils;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJavaMethodSignature;

public class CompilationUnitsRepository {
    private static final CompilationUnitsRepository instance = new CompilationUnitsRepository();
    private final Map<ICompilationUnit, Map<String, JavaMethodSignature>> methodDeclarationsMap = new HashMap<ICompilationUnit, Map<String, JavaMethodSignature>>();
    private final Map<IPath, CompilationUnit> astMap = new HashMap<IPath, CompilationUnit>();
    private final Map<ICompilationUnit, Map<Integer, Problem>> problemsMap = new HashMap<ICompilationUnit, Map<Integer, Problem>>();

    private CompilationUnitsRepository() {
    }

    public static CompilationUnitsRepository getInstance() {
        return instance;
    }

    public void clear() {
        this.methodDeclarationsMap.clear();
        this.astMap.clear();
        this.problemsMap.clear();
    }

    public CompilationUnit getAST(ICompilationUnit compilationUnit) throws JavaModelException {
        if (compilationUnit == null || compilationUnit.getResource() == null) {
            return null;
        }
        IResource resource = compilationUnit.getResource();
        IPath resourcePath = resource.getFullPath();
        if (!this.astMap.containsKey(resourcePath)) {
            Logger.trace("Adding {}'s AST in CompilationUnitsRepository cache.", compilationUnit.getElementName());
            this.recordAST(compilationUnit);
        } else {
            Logger.trace("CompilationUnitsRepository cache contains {}'s AST.", compilationUnit.getElementName());
        }
        return this.astMap.get(resourcePath);
    }

    public CompilationUnit getAST(IResource resource) throws JavaModelException {
        ICompilationUnit compilationUnit = JdtUtils.getCompilationUnit(resource);
        return this.getAST(compilationUnit);
    }

    public CompilationUnit recordAST(ICompilationUnit compilationUnit) throws JavaModelException {
        if (compilationUnit == null || !compilationUnit.exists()) {
            return null;
        }
        CompilationUnit compilationUnitAST = JdtUtils.parse(compilationUnit, (IProgressMonitor)new NullProgressMonitor());
        this.astMap.put(compilationUnit.getResource().getFullPath(), compilationUnitAST);
        Map<String, JavaMethodSignature> methodSignatures = JdtUtils.resolveMethodSignatures(compilationUnit.findPrimaryType(), compilationUnitAST);
        this.methodDeclarationsMap.put(compilationUnit, methodSignatures);
        return compilationUnitAST;
    }

    public Map<String, JavaMethodSignature> mergeAST(ICompilationUnit compilationUnit, CompilationUnit compilationUnitAST, boolean computeDiffs) throws JavaModelException {
        HashMap<String, JavaMethodSignature> diffs = new HashMap<String, JavaMethodSignature>();
        IType[] iTypeArray = compilationUnit.getTypes();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            diffs.putAll(this.mergeAST(type, compilationUnitAST, computeDiffs));
            ++n2;
        }
        return diffs;
    }

    private Map<String, JavaMethodSignature> mergeAST(IType type, CompilationUnit compilationUnitAST, boolean computeDiffs) throws JavaModelException {
        ICompilationUnit compilationUnit = type.getCompilationUnit();
        Map<String, JavaMethodSignature> methodSignatures = JdtUtils.resolveMethodSignatures(type, compilationUnitAST);
        HashMap<String, JavaMethodSignature> diffs = new HashMap<String, JavaMethodSignature>();
        if (computeDiffs) {
            Map<String, JavaMethodSignature> workingCopyDeclarations = methodSignatures;
            Map<String, JavaMethodSignature> controlDeclarations = this.methodDeclarationsMap.get(compilationUnit);
            diffs.putAll(CollectionUtils.difference(workingCopyDeclarations, controlDeclarations));
            if (diffs.size() > 0) {
                Logger.trace("Found diffs in method signatures:", diffs);
            }
        }
        this.astMap.put(compilationUnit.getResource().getFullPath(), compilationUnitAST);
        this.methodDeclarationsMap.put(compilationUnit, methodSignatures);
        return diffs;
    }

    public IJavaMethodSignature getMethodSignature(IMethod javaMethod) throws JavaModelException {
        ICompilationUnit compilationUnit = javaMethod.getCompilationUnit();
        if (!this.methodDeclarationsMap.containsKey(compilationUnit)) {
            this.recordAST(compilationUnit);
        }
        Map<String, JavaMethodSignature> methodSignatures = this.methodDeclarationsMap.get(compilationUnit);
        return methodSignatures.get(javaMethod.getHandleIdentifier());
    }

    public void removeAST(ICompilationUnit compilationUnit) {
        IPath fullPath = compilationUnit.getResource().getFullPath();
        Logger.trace("Removing {}'s AST from CompilationUnitsRepository (path={})", compilationUnit, fullPath);
        this.methodDeclarationsMap.remove(compilationUnit);
        this.astMap.remove(fullPath);
        this.problemsMap.remove(compilationUnit);
    }

    public Map<IProblem, IJavaElement> mergeProblems(ICompilationUnit compilationUnit, IProblem[] problems) throws JavaModelException {
        Map<Integer, Problem> lastProblems = this.problemsMap.get(compilationUnit);
        HashMap<Integer, Problem> newProblems = new HashMap<Integer, Problem>();
        IProblem[] iProblemArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            IProblem p = iProblemArray[n2];
            int problemLocation = p.getSourceStart();
            IJavaElement element = JdtUtils.getElementAt(compilationUnit, problemLocation);
            if (element instanceof IAnnotation) {
                newProblems.put(p.getID(), new Problem(p, element));
            }
            ++n2;
        }
        HashMap<IProblem, IJavaElement> fixedProblems = new HashMap<IProblem, IJavaElement>();
        if (lastProblems != null) {
            for (Map.Entry<Integer, Problem> entry : lastProblems.entrySet()) {
                if (newProblems.containsKey(entry.getKey())) continue;
                fixedProblems.put(entry.getValue().getProblem(), entry.getValue().getJavaElement());
            }
        }
        this.problemsMap.put(compilationUnit, newProblems);
        return fixedProblems;
    }

    static class Problem {
        private final IProblem problem;
        private final IJavaElement javaElement;

        public Problem(IProblem problem, IJavaElement javaElement) {
            this.problem = problem;
            this.javaElement = javaElement;
        }

        public IProblem getProblem() {
            return this.problem;
        }

        public IJavaElement getJavaElement() {
            return this.javaElement;
        }
    }
}

