/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.jdt;

import java.util.HashSet;
import java.util.Map;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsWebxmlApplication;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.jdt.Flags;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IAnnotatedElement;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsElement;

public class FlagsUtils {
    private FlagsUtils() {
    }

    public static Flags computeElementFlags(IJaxrsElement element) {
        Flags flags = new Flags();
        if (element == null) {
            return flags;
        }
        JaxrsMetamodel metamodel = (JaxrsMetamodel)element.getMetamodel();
        HashSet<String> httpMethodNames = new HashSet<String>();
        if (metamodel != null) {
            httpMethodNames.addAll(metamodel.findAllHttpMethodNames());
        }
        if (element instanceof IAnnotatedElement) {
            Map<String, Annotation> annotations = ((IAnnotatedElement)((Object)element)).getAnnotations();
            for (Map.Entry<String, Annotation> entry : annotations.entrySet()) {
                String annotationName = entry.getValue().getFullyQualifiedName();
                if (annotationName.equals("javax.ws.rs.ApplicationPath")) {
                    flags.addFlags(16);
                    continue;
                }
                if (annotationName.equals("javax.ws.rs.BeanParam")) {
                    flags.addFlags(0x1000000);
                    continue;
                }
                if (annotationName.equals("javax.ws.rs.Consumes")) {
                    flags.addFlags(8192);
                    continue;
                }
                if (annotationName.equals("javax.ws.rs.DefaultValue")) {
                    flags.addFlags(4096);
                    continue;
                }
                if (annotationName.equals("javax.ws.rs.FormParam")) {
                    flags.addFlags(0x2000000);
                    continue;
                }
                if (annotationName.equals("javax.ws.rs.MatrixParam")) {
                    flags.addFlags(2048);
                    continue;
                }
                if (annotationName.equals("javax.ws.rs.NameBinding")) {
                    flags.addFlags(0x400000);
                    continue;
                }
                if (annotationName.equals("javax.ws.rs.Path")) {
                    flags.addFlags(8);
                    continue;
                }
                if (annotationName.equals("javax.ws.rs.PathParam")) {
                    flags.addFlags(512);
                    continue;
                }
                if (annotationName.equals("javax.ws.rs.ext.Provider")) {
                    flags.addFlags(524288);
                    continue;
                }
                if (annotationName.equals("javax.ws.rs.Produces")) {
                    flags.addFlags(16384);
                    continue;
                }
                if (annotationName.equals("javax.ws.rs.QueryParam")) {
                    flags.addFlags(1024);
                    continue;
                }
                if (annotationName.equals("java.lang.annotation.Retention")) {
                    flags.addFlags(262144);
                    continue;
                }
                if (annotationName.equals("java.lang.annotation.Target")) {
                    flags.addFlags(131072);
                    continue;
                }
                if (!httpMethodNames.contains(annotationName)) continue;
                flags.addFlags(256);
            }
        } else if (element instanceof JaxrsWebxmlApplication) {
            JaxrsWebxmlApplication webxmlApplication = (JaxrsWebxmlApplication)element;
            if (webxmlApplication.isOverride()) {
                flags.addFlags(64);
            }
            flags.addFlags(32);
            flags.addFlags(16);
        }
        return flags;
    }
}

