/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.cnf;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.ws.jaxrs.core.JBossJaxrsCorePlugin;
import org.jboss.tools.ws.jaxrs.core.configuration.ProjectNatureUtils;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsEndpoint;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsMetamodelChangedListener;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.JaxrsEndpointDelta;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.JaxrsMetamodelDelta;
import org.jboss.tools.ws.jaxrs.ui.cnf.UriPathTemplateCategory;
import org.jboss.tools.ws.jaxrs.ui.cnf.UriPathTemplateElement;
import org.jboss.tools.ws.jaxrs.ui.internal.utils.Logger;

public class UriMappingsContentProvider
implements ITreeContentProvider,
IJaxrsMetamodelChangedListener {
    private TreeViewer viewer;
    private Map<IProject, UriPathTemplateCategory> uriPathTemplateCategories = new HashMap<IProject, UriPathTemplateCategory>();

    public UriMappingsContentProvider() {
        Logger.debug("*** Instantiating the UriMappingsContentProvider ***");
        JBossJaxrsCorePlugin.getDefault().addJaxrsMetamodelChangedListener((IJaxrsMetamodelChangedListener)this);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IProject) {
            return this.getChildren((IProject)parentElement);
        }
        if (parentElement instanceof ITreeContentProvider) {
            Logger.debug("Displaying the children of '{}'", parentElement);
            return ((ITreeContentProvider)parentElement).getChildren(parentElement);
        }
        Logger.debug("*** No children for parent of type '{}' ***", parentElement.getClass().getName());
        return new Object[0];
    }

    private Object[] getChildren(IProject project) {
        if (!this.uriPathTemplateCategories.containsKey(project)) {
            UriPathTemplateCategory uriPathTemplateCategory = new UriPathTemplateCategory(this, project);
            this.uriPathTemplateCategories.put(project, uriPathTemplateCategory);
        }
        Logger.debug("Displaying the UriPathTemplateCategory for project '{}'", project.getName());
        return new Object[]{this.uriPathTemplateCategories.get(project)};
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IProject) {
            Logger.trace("Project '{}' has children: true", ((IProject)element).getName());
            return true;
        }
        if (element instanceof ITreeContentProvider) {
            boolean hasChildren = ((ITreeContentProvider)element).hasChildren(element);
            Logger.trace("Element {} has children: {}", element, hasChildren);
            return hasChildren;
        }
        Logger.debug("Element '{}' has no children", element);
        return false;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TreeViewer)viewer;
    }

    public void dispose() {
        JBossJaxrsCorePlugin.getDefault().removeListener((IJaxrsMetamodelChangedListener)this);
        this.uriPathTemplateCategories = null;
    }

    public void notifyEndpointChanged(JaxrsEndpointDelta delta) {
        switch (delta.getKind()) {
            case 1: 
            case 2: {
                this.refreshContent(delta.getEndpoint().getMetamodel());
                break;
            }
            case 4: {
                this.refreshContent(delta.getEndpoint());
            }
        }
    }

    public void notifyEndpointProblemLevelChanged(IJaxrsEndpoint endpoint) {
        IProject project = endpoint.getProject();
        if (!this.uriPathTemplateCategories.containsKey(project)) {
            this.refreshTarget(project);
        } else {
            UriPathTemplateCategory uriPathTemplateCategory = this.uriPathTemplateCategories.get(project);
            UriPathTemplateElement target = uriPathTemplateCategory.getUriPathTemplateElement(endpoint);
            if (target != null) {
                Logger.debug("Refreshing navigator view at level: '{}'", target.getClass().getName());
                this.updateContent(target);
            }
        }
    }

    public void notifyMetamodelProblemLevelChanged(IJaxrsMetamodel metamodel) {
        if (metamodel == null) {
            return;
        }
        IProject project = metamodel.getProject();
        if (this.uriPathTemplateCategories != null) {
            if (!this.uriPathTemplateCategories.containsKey(project)) {
                Logger.debug("Adding a UriPathTemplateCategory for project '{}' (case #1)", project.getName());
                UriPathTemplateCategory uriPathTemplateCategory = new UriPathTemplateCategory(this, metamodel.getJavaProject());
                this.uriPathTemplateCategories.put(project, uriPathTemplateCategory);
                this.refreshTarget(this.uriPathTemplateCategories.get(project));
            }
            this.updateContent(this.uriPathTemplateCategories.get(project));
        }
    }

    public void notifyMetamodelChanged(JaxrsMetamodelDelta delta) {
        IProject project = delta.getMetamodel().getProject();
        if (delta.getKind() == 2 && this.uriPathTemplateCategories != null) {
            this.uriPathTemplateCategories.remove(project);
        }
        this.refreshTarget(project);
    }

    public void refreshContent(IJaxrsMetamodel metamodel) {
        try {
            IProject project = metamodel.getProject();
            if (this.uriPathTemplateCategories != null) {
                if (!ProjectNatureUtils.isProjectNatureInstalled((IProject)project, (String)"org.jboss.tools.ws.jaxrs.nature")) {
                    Logger.debug("*** Project '{}' has no JAX-RS nature installed. ***", project.getName());
                    if (this.uriPathTemplateCategories.containsKey(project)) {
                        this.uriPathTemplateCategories.remove(project);
                        this.refreshTarget(project);
                    }
                } else if (!this.uriPathTemplateCategories.containsKey(project)) {
                    Logger.debug("Adding a UriPathTemplateCategory for project '{}' (case #1)", project.getName());
                    UriPathTemplateCategory uriPathTemplateCategory = new UriPathTemplateCategory(this, project);
                    this.uriPathTemplateCategories.put(project, uriPathTemplateCategory);
                    this.refreshTarget(project);
                } else {
                    Logger.debug("Refreshing UriPathTemplateCategory for project '{}' (case #2)", project.getName());
                    this.refreshTarget(this.uriPathTemplateCategories.get(project));
                }
            }
        }
        catch (CoreException coreException) {}
    }

    private void refreshContent(IJaxrsEndpoint endpoint) {
        IProject project = endpoint.getProject();
        if (!this.uriPathTemplateCategories.containsKey(project)) {
            this.refreshTarget(project);
        } else {
            UriPathTemplateCategory uriPathTemplateCategory = this.uriPathTemplateCategories.get(project);
            UriPathTemplateElement target = uriPathTemplateCategory.getUriPathTemplateElement(endpoint);
            if (target != null) {
                Logger.debug("Refreshing navigator view at level: '{}'", target.getClass().getName());
                this.refreshTarget(target);
            }
        }
    }

    private void refreshTarget(final Object target) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (UriMappingsContentProvider.this.viewer != null) {
                    TreePath[] treePaths = UriMappingsContentProvider.this.viewer.getExpandedTreePaths();
                    Logger.debug("*** Refreshing the viewer (busy: {}) ***", UriMappingsContentProvider.this.viewer.isBusy());
                    UriMappingsContentProvider.this.viewer.refresh(target, true);
                    UriMappingsContentProvider.this.viewer.setExpandedTreePaths(treePaths);
                    Logger.debug("*** Refreshing the viewer... done ***");
                } else {
                    Logger.debug("*** Cannot refresh: viewer is null :-( ***");
                }
            }
        });
    }

    protected void updateContent(final Object target) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (UriMappingsContentProvider.this.viewer != null && target != null) {
                    TreePath[] treePaths = UriMappingsContentProvider.this.viewer.getExpandedTreePaths();
                    Logger.debug("*** Updating the viewer at target level: {} (viewer busy: {}) ***", target, UriMappingsContentProvider.this.viewer.isBusy());
                    UriMappingsContentProvider.this.viewer.update(target, null);
                    UriMappingsContentProvider.this.viewer.setExpandedTreePaths(treePaths);
                    Logger.debug("*** Refreshing the viewer... done ***");
                } else {
                    Logger.debug("*** Cannot refresh: viewer is null :-( ***");
                }
            }
        });
    }

    public static class LoadingStub {
        private final IJavaProject javaProject;

        public LoadingStub(IJavaProject javaProject) {
            this.javaProject = javaProject;
        }

        public String toString() {
            return "Loading Stub on '" + this.javaProject.getElementName() + "'";
        }
    }
}

