/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.internal.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsBaseElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsJavaElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParameterAggregator;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParameterAggregatorField;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParameterAggregatorProperty;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResource;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResourceMethod;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.jdt.AnnotationUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.SourceType;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementCategory;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IAnnotatedSourceType;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJavaMethodParameter;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsProvider;
import org.jboss.tools.ws.jaxrs.ui.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.AbstractJaxrsElementValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.IMarkerManager;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsParameterValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsValidationMessages;
import org.jboss.tools.ws.jaxrs.ui.preferences.JaxrsPreferences;

public class JaxrsResourceMethodValidatorDelegate
extends AbstractJaxrsElementValidatorDelegate<JaxrsResourceMethod> {
    public JaxrsResourceMethodValidatorDelegate(IMarkerManager markerManager) {
        super(markerManager);
    }

    @Override
    void internalValidate(JaxrsResourceMethod resourceMethod, CompilationUnit ast) throws CoreException {
        Logger.debug("Validating element {}", resourceMethod);
        this.validatePublicModifierOnJavaMethod(resourceMethod);
        this.validatePathAnnotationValue(resourceMethod, ast);
        this.validateNoUnboundPathAnnotationTemplateParameters(resourceMethod, ast);
        this.validateNoUnboundPathParamAnnotationValues(resourceMethod, ast);
        this.validateNoUnauthorizedContextAnnotationOnJavaMethodParameters(resourceMethod);
        this.validateAtMostOneMethodParameterWithoutAnnotation(resourceMethod);
        this.validateAtLeastOneProviderWithBinding(resourceMethod);
        this.validateParameterTypes(resourceMethod);
    }

    private void validatePathAnnotationValue(JaxrsResourceMethod resourceMethod, CompilationUnit ast) throws JavaModelException, CoreException {
        Annotation pathAnnotation = resourceMethod.getPathAnnotation();
        if (pathAnnotation != null && pathAnnotation.getValue() != null && !AnnotationUtils.isValidAnnotationValue((String)pathAnnotation.getValue())) {
            ISourceRange range = JdtUtils.resolveMemberPairValueRange((IAnnotation)pathAnnotation.getJavaAnnotation(), (String)"value", (CompilationUnit)ast);
            this.markerManager.addMarker((JaxrsBaseElement)resourceMethod, range, JaxrsValidationMessages.RESOURCE_METHOD_INVALID_PATH_ANNOTATION_VALUE, new String[]{pathAnnotation.getValue()}, JaxrsPreferences.RESOURCE_METHOD_INVALID_PATH_ANNOTATION_VALUE);
        }
    }

    private void validateParameterTypes(JaxrsResourceMethod resourceMethod) throws CoreException {
        Set allParamConverterProviders = resourceMethod.getMetamodel().findAllParamConverterProviders();
        if (allParamConverterProviders != null && !allParamConverterProviders.isEmpty()) {
            return;
        }
        JaxrsParameterValidatorDelegate parameterValidatorDelegate = new JaxrsParameterValidatorDelegate();
        List methodParameters = resourceMethod.getJavaMethodParameters();
        for (IJavaMethodParameter methodParameter : methodParameters) {
            if (!methodParameter.hasAnnotation("javax.ws.rs.PathParam") && !methodParameter.hasAnnotation("javax.ws.rs.QueryParam") && !methodParameter.hasAnnotation("javax.ws.rs.MatrixParam") && !methodParameter.hasAnnotation("javax.ws.rs.CookieParam") && !methodParameter.hasAnnotation("javax.ws.rs.HeaderParam")) continue;
            SourceType type = methodParameter.getType();
            if (!type.exists()) {
                return;
            }
            boolean isValid = parameterValidatorDelegate.validate(type);
            if (isValid) continue;
            this.markerManager.addMarker((JaxrsBaseElement)resourceMethod, methodParameter.getType().getNameRange(), JaxrsValidationMessages.RESOURCE_METHOD_INVALID_ANNOTATED_PARAMETER_TYPE, new String[]{type.getErasureName()}, JaxrsPreferences.RESOURCE_METHOD_INVALID_ANNOTATED_PARAMETER_TYPE);
        }
    }

    private void validateAtLeastOneProviderWithBinding(JaxrsResourceMethod resourceMethod) throws CoreException {
        if (resourceMethod == null) {
            return;
        }
        Map nameBindingAnnotations = resourceMethod.getNameBindingAnnotations();
        if (nameBindingAnnotations.isEmpty()) {
            return;
        }
        JaxrsMetamodel metamodel = resourceMethod.getMetamodel();
        block0: for (Map.Entry entry : nameBindingAnnotations.entrySet()) {
            String nameBindingAnnotationClassName = (String)entry.getKey();
            Set annotatedProviders = metamodel.findProvidersByAnnotation(nameBindingAnnotationClassName);
            for (IJaxrsProvider provider : annotatedProviders) {
                if (resourceMethod.getNameBindingAnnotations().keySet().containsAll(provider.getNameBindingAnnotations().keySet())) continue block0;
            }
            ISourceRange nameRange = ((Annotation)entry.getValue()).getJavaAnnotation().getNameRange();
            this.markerManager.addMarker((JaxrsBaseElement)resourceMethod, nameRange, JaxrsValidationMessages.PROVIDER_MISSING_BINDING, new String[]{nameBindingAnnotationClassName}, JaxrsPreferences.PROVIDER_MISSING_BINDING);
        }
    }

    private void validateAtMostOneMethodParameterWithoutAnnotation(JaxrsResourceMethod resourceMethod) throws CoreException {
        int counter = 0;
        for (IJavaMethodParameter parameter : resourceMethod.getJavaMethodParameters()) {
            Map jaxrsAnnotations = parameter.getAnnotations();
            if (jaxrsAnnotations.size() != 0) continue;
            ++counter;
        }
        if (counter > 1) {
            ISourceRange nameRange = ((IMethod)resourceMethod.getJavaElement()).getNameRange();
            this.markerManager.addMarker((JaxrsBaseElement)resourceMethod, nameRange, JaxrsValidationMessages.RESOURCE_METHOD_MORE_THAN_ONE_UNANNOTATED_PARAMETER, new String[0], JaxrsPreferences.RESOURCE_METHOD_MORE_THAN_ONE_UNANNOTATED_PARAMETER);
        }
    }

    private void validateNoUnauthorizedContextAnnotationOnJavaMethodParameters(JaxrsResourceMethod resourceMethod) throws CoreException {
        for (IJavaMethodParameter parameter : resourceMethod.getJavaMethodParameters()) {
            String typeName;
            Annotation contextAnnotation = parameter.getAnnotation("javax.ws.rs.core.Context");
            String string = typeName = parameter.getType() != null ? parameter.getType().getErasureName() : null;
            if (contextAnnotation == null || typeName == null || CONTEXT_TYPE_NAMES.contains(typeName)) continue;
            ISourceRange range = contextAnnotation.getJavaAnnotation().getSourceRange();
            this.markerManager.addMarker((JaxrsBaseElement)resourceMethod, range, JaxrsValidationMessages.RESOURCE_METHOD_ILLEGAL_CONTEXT_ANNOTATION, new String[]{CONTEXT_TYPE_NAMES.toString()}, JaxrsPreferences.RESOURCE_METHOD_ILLEGAL_CONTEXT_ANNOTATION);
        }
    }

    private void validateNoUnboundPathAnnotationTemplateParameters(JaxrsResourceMethod resourceMethod, CompilationUnit ast) throws CoreException {
        Map pathTemplateParameters = resourceMethod.getPathTemplateParameters();
        pathTemplateParameters.putAll(resourceMethod.getParentResource().getPathTemplateParameters());
        ArrayList<String> actualPathParamValues = new ArrayList<String>();
        for (IJavaMethodParameter iJavaMethodParameter : resourceMethod.getJavaMethodParameters()) {
            JaxrsParameterAggregator parameterAggregator;
            SourceType beanParameterType;
            Annotation beanParamAnnotation;
            Annotation pathParamAnnotation = iJavaMethodParameter.getAnnotation("javax.ws.rs.PathParam");
            if (pathParamAnnotation != null && pathParamAnnotation.getValue() != null) {
                actualPathParamValues.add(pathParamAnnotation.getValue());
            }
            if ((beanParamAnnotation = iJavaMethodParameter.getAnnotation("javax.ws.rs.BeanParam")) == null || (beanParameterType = iJavaMethodParameter.getType()) == null || (parameterAggregator = (JaxrsParameterAggregator)resourceMethod.getMetamodel().findElement(beanParameterType.getErasureName(), EnumElementCategory.PARAMETER_AGGREGATOR)) == null) continue;
            actualPathParamValues.addAll(parameterAggregator.getPathParamValues());
        }
        actualPathParamValues.addAll(resourceMethod.getParentResource().getPathParamValues());
        for (Map.Entry entry : pathTemplateParameters.entrySet()) {
            String pathTemplateParameter = (String)entry.getKey();
            if (actualPathParamValues.contains(pathTemplateParameter)) continue;
            Annotation pathTemplateParameterAnnotation = (Annotation)entry.getValue();
            ISourceRange range = this.resolveAnnotationParamSourceRange(pathTemplateParameterAnnotation, pathTemplateParameter, ast);
            this.markerManager.addMarker((JaxrsBaseElement)resourceMethod, range, JaxrsValidationMessages.RESOURCE_METHOD_UNBOUND_PATH_ANNOTATION_TEMPLATE_PARAMETER, new String[]{pathTemplateParameter}, JaxrsPreferences.RESOURCE_METHOD_UNBOUND_PATH_ANNOTATION_TEMPLATE_PARAMETER);
        }
    }

    private void validateNoUnboundPathParamAnnotationValues(JaxrsResourceMethod resourceMethod, CompilationUnit ast) throws CoreException {
        Map pathParamValueProposals = resourceMethod.getPathTemplateParameters();
        pathParamValueProposals.putAll(resourceMethod.getParentResource().getPathTemplateParameters());
        for (IJavaMethodParameter parameter : resourceMethod.getJavaMethodParameters()) {
            JaxrsParameterAggregator parameterAggregator;
            SourceType beanParameterType;
            Annotation beanParamAnnotation;
            if (parameter.hasAnnotation("javax.ws.rs.PathParam")) {
                this.validatePathParamAnnotation((IAnnotatedSourceType)parameter, resourceMethod, pathParamValueProposals, ast);
            }
            if (!parameter.hasAnnotation("javax.ws.rs.BeanParam") || (beanParamAnnotation = parameter.getAnnotation("javax.ws.rs.BeanParam")) == null || (beanParameterType = parameter.getType()) == null || (parameterAggregator = (JaxrsParameterAggregator)resourceMethod.getMetamodel().findElement(beanParameterType.getErasureName(), EnumElementCategory.PARAMETER_AGGREGATOR)) == null) continue;
            for (JaxrsParameterAggregatorProperty aggregatorProperty : parameterAggregator.getAllProperties()) {
                this.validatePathParamAnnotation((JaxrsJavaElement<?>)aggregatorProperty, parameterAggregator, parameter, resourceMethod, pathParamValueProposals, ast);
            }
            for (JaxrsParameterAggregatorField aggregatorField : parameterAggregator.getAllFields()) {
                this.validatePathParamAnnotation((JaxrsJavaElement<?>)aggregatorField, parameterAggregator, parameter, resourceMethod, pathParamValueProposals, ast);
            }
        }
    }

    private void validatePathParamAnnotation(JaxrsJavaElement<?> aggregatorElement, JaxrsParameterAggregator parameterAggregator, IJavaMethodParameter resourceMethodParameter, JaxrsResourceMethod resourceMethod, Map<String, Annotation> pathParamValueProposals, CompilationUnit ast) throws CoreException {
        Annotation pathParamAnnotation = aggregatorElement.getAnnotation("javax.ws.rs.PathParam");
        if (pathParamAnnotation != null && pathParamAnnotation.getValue() != null) {
            SourceType type;
            String pathParamValue = pathParamAnnotation.getValue();
            if (!alphaNumPattern.matcher(pathParamValue).matches()) {
                ISourceRange range = JdtUtils.resolveMemberPairValueRange((IAnnotation)pathParamAnnotation.getJavaAnnotation(), (String)"value", (CompilationUnit)ast);
                this.markerManager.addMarker((JaxrsBaseElement)aggregatorElement, range, JaxrsValidationMessages.RESOURCE_METHOD_INVALID_PATHPARAM_ANNOTATION_VALUE, new String[]{pathParamValue}, JaxrsPreferences.RESOURCE_METHOD_INVALID_PATHPARAM_ANNOTATION_VALUE);
            }
            if (!pathParamValueProposals.keySet().contains(pathParamValue) && (type = resourceMethodParameter.getType()) != null) {
                ISourceRange range = type.getNameRange();
                this.markerManager.addMarker((JaxrsBaseElement)resourceMethod, range, JaxrsValidationMessages.RESOURCE_METHOD_UNBOUND_PATHPARAM_ANNOTATION_VALUE_IN_AGGREGATOR, new String[]{pathParamValue, parameterAggregator.getName(), resourceMethod.getName(), resourceMethod.getParentResource().getName()}, JaxrsPreferences.RESOURCE_METHOD_UNBOUND_PATHPARAM_ANNOTATION_VALUE);
            }
        }
    }

    private void validatePathParamAnnotation(IAnnotatedSourceType annotatedElement, JaxrsResourceMethod resourceMethod, Map<String, Annotation> pathTemplateValues, CompilationUnit ast) throws CoreException {
        Annotation pathParamAnnotation = annotatedElement.getAnnotation("javax.ws.rs.PathParam");
        if (pathParamAnnotation != null && pathParamAnnotation.getValue() != null) {
            String pathParamValue = pathParamAnnotation.getValue();
            if (!alphaNumPattern.matcher(pathParamValue).matches()) {
                ISourceRange range = JdtUtils.resolveMemberPairValueRange((IAnnotation)pathParamAnnotation.getJavaAnnotation(), (String)"value", (CompilationUnit)ast);
                this.markerManager.addMarker((JaxrsBaseElement)resourceMethod, range, JaxrsValidationMessages.RESOURCE_METHOD_INVALID_PATHPARAM_ANNOTATION_VALUE, new String[]{pathParamValue}, JaxrsPreferences.RESOURCE_METHOD_INVALID_PATHPARAM_ANNOTATION_VALUE);
            } else if (!pathTemplateValues.keySet().contains(pathParamValue)) {
                ISourceRange range = JdtUtils.resolveMemberPairValueRange((IAnnotation)pathParamAnnotation.getJavaAnnotation(), (String)"value", (CompilationUnit)ast);
                this.markerManager.addMarker((JaxrsBaseElement)resourceMethod, range, JaxrsValidationMessages.RESOURCE_METHOD_UNBOUND_PATHPARAM_ANNOTATION_VALUE, new String[]{pathParamValue, resourceMethod.getName(), ((IType)resourceMethod.getParentResource().getJavaElement()).getFullyQualifiedName()}, JaxrsPreferences.RESOURCE_METHOD_UNBOUND_PATHPARAM_ANNOTATION_VALUE);
            }
        }
    }

    private ISourceRange resolveAnnotationParamSourceRange(Annotation pathTemplateParameterAnnotation, String pathTemplateParameter, CompilationUnit ast) throws JavaModelException {
        ISourceRange valueRange = JdtUtils.resolveMemberPairValueRange((IAnnotation)pathTemplateParameterAnnotation.getJavaAnnotation(), (String)"value", (CompilationUnit)ast);
        String annotationValue = pathTemplateParameterAnnotation.getValue();
        Pattern p = Pattern.compile("\\{\\s*" + Pattern.quote(pathTemplateParameter));
        Matcher matcher = p.matcher(annotationValue);
        if (matcher.find()) {
            int start = matcher.start();
            int end = annotationValue.indexOf(125, start);
            return new SourceRange(valueRange.getOffset() + start + 1, end - start + 1);
        }
        return valueRange;
    }

    private void validatePublicModifierOnJavaMethod(JaxrsResourceMethod resourceMethod) throws CoreException {
        IMethod javaMethod = (IMethod)resourceMethod.getJavaElement();
        JaxrsResource parentResource = resourceMethod.getParentResource();
        if (javaMethod == null || parentResource == null || parentResource.getJavaElement() == null || !javaMethod.exists()) {
            return;
        }
        if (!((IType)parentResource.getJavaElement()).isInterface() && !Flags.isPublic((int)javaMethod.getFlags())) {
            ISourceRange nameRange = javaMethod.getNameRange();
            this.markerManager.addMarker((JaxrsBaseElement)resourceMethod, nameRange, JaxrsValidationMessages.RESOURCE_METHOD_NO_PUBLIC_MODIFIER, new String[]{resourceMethod.getName()}, JaxrsPreferences.RESOURCE_METHOD_NO_PUBLIC_MODIFIER);
        }
    }
}

