/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.wizards;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.jst.javaee.web.ServletMapping;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.core.wtp.WtpUtils;
import org.jboss.tools.ws.jaxrs.ui.cnf.UriPathTemplateCategory;
import org.jboss.tools.ws.jaxrs.ui.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.ui.wizards.JaxrsApplicationCreationMessages;
import org.jboss.tools.ws.jaxrs.ui.wizards.JaxrsElementCreationUtils;

public class JaxrsApplicationCreationWizardPage
extends NewClassWizardPage {
    private final boolean canSkipApplicationCreation;
    private Button createWebxmlApplicationButton = null;
    private Button createJavaApplicationButton = null;
    private Button skipApplicationButton = null;
    private int applicationMode = 0;
    public static final int APPLICATION_JAVA = 0;
    public static final int APPLICATION_WEB_XML = 1;
    public static final int SKIP_APPLICATION = 2;
    private Text javaApplicationApplicationPathText = null;
    private Status javaApplicationApplicationPathStatus = new Status(0, "org.jboss.tools.ws.jaxrs.ui", null);
    private Text webxmlApplicationApplicationPathText = null;
    private Status webxmlApplicationApplicationPathStatus = new Status(0, "org.jboss.tools.ws.jaxrs.ui", null);
    private String applicationPath = "/rest";
    private Composite javaApplicationControlsContainer;
    private Composite webxmlApplicationControlsContainer;
    private boolean applicationAlreadyExists = false;

    public JaxrsApplicationCreationWizardPage(boolean canSkipApplicationCreation) {
        this.setTitle(JaxrsApplicationCreationMessages.JaxrsApplicationCreationWizardPage_Title);
        this.setDescription(JaxrsApplicationCreationMessages.JaxrsApplicationCreationWizardPage_Description);
        this.canSkipApplicationCreation = canSkipApplicationCreation;
    }

    public void init(IStructuredSelection selection) {
        super.init(selection);
        this.setDefaultValues(selection);
        this.setSuperClass("javax.ws.rs.core.Application", true);
    }

    public void setApplicationAlreadyExists(boolean alreadyExists) {
        this.applicationAlreadyExists = alreadyExists;
        this.setApplicationMode(2);
    }

    public void setDefaultValues(IStructuredSelection selection) {
        this.setSuperClass("javax.ws.rs.core.Application", false);
        IJavaElement selectedJavaElement = this.getInitialJavaElement(selection);
        if (selectedJavaElement != null && !selectedJavaElement.exists()) {
            this.setPackageFragmentRoot(null, true);
            this.initTypePage(null);
            return;
        }
        if (selectedJavaElement instanceof IJavaProject) {
            this.setDefaultValues((IJavaProject)selectedJavaElement);
        } else if (selectedJavaElement instanceof IPackageFragmentRoot) {
            this.setDefaultValues((IPackageFragmentRoot)selectedJavaElement);
        } else if (selectedJavaElement instanceof IPackageFragment) {
            this.setDefaultValues((IPackageFragment)selectedJavaElement);
        } else if (selectedJavaElement instanceof ICompilationUnit) {
            this.setDefaultValues((ICompilationUnit)selectedJavaElement);
        } else if (selectedJavaElement instanceof IType) {
            this.setDefaultValues((IType)selectedJavaElement);
        } else if (selection.getFirstElement() instanceof UriPathTemplateCategory) {
            this.setDefaultValues((UriPathTemplateCategory)selection.getFirstElement());
        }
    }

    private void setDefaultValues(IJavaProject javaProject) {
        try {
            IPackageFragmentRoot firstPackageFragmentRoot = JaxrsElementCreationUtils.getFirstPackageFragmentRoot(javaProject);
            this.setPackageFragmentRoot(firstPackageFragmentRoot, true);
            IPackageFragment suggestedPackage = JaxrsElementCreationUtils.getSuggestedPackage(JaxrsElementCreationUtils.getProjectTopLevelPackage(firstPackageFragmentRoot));
            this.setPackageFragment(suggestedPackage, true);
            this.setTypeName(JaxrsElementCreationUtils.getSuggestedApplicationTypeName(suggestedPackage), true);
        }
        catch (CoreException e) {
            Logger.error("Failed to retrieve the default package of the first source folder in project '" + javaProject.getElementName() + "'", e);
        }
    }

    private void setDefaultValues(IPackageFragmentRoot packageFragmentRoot) {
        this.setPackageFragmentRoot(packageFragmentRoot, true);
        this.setDefaultValues(packageFragmentRoot.getJavaProject());
    }

    private void setDefaultValues(IPackageFragment packageFragment) {
        this.setPackageFragmentRoot((IPackageFragmentRoot)packageFragment.getAncestor(3), true);
        this.setPackageFragment(packageFragment, true);
        this.setTypeName(JaxrsElementCreationUtils.getSuggestedApplicationTypeName(packageFragment), true);
    }

    private void setDefaultValues(ICompilationUnit compilationUnit) {
        this.setPackageFragmentRoot((IPackageFragmentRoot)compilationUnit.getAncestor(3), true);
        IPackageFragment packageFragment = (IPackageFragment)compilationUnit.getAncestor(4);
        this.setPackageFragment(packageFragment, true);
        this.setTypeName(JaxrsElementCreationUtils.getSuggestedApplicationTypeName(packageFragment), true);
    }

    private void setDefaultValues(IType type) {
        this.setDefaultValues(type.getCompilationUnit());
    }

    private void setDefaultValues(UriPathTemplateCategory category) {
        IJavaProject javaProject = category.getJavaProject();
        try {
            IPackageFragmentRoot[] packageFragmentRoots;
            IPackageFragmentRoot[] iPackageFragmentRootArray = packageFragmentRoots = javaProject.getAllPackageFragmentRoots();
            int n = packageFragmentRoots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
                if (packageFragmentRoot.getKind() == 1) {
                    this.setDefaultValues(packageFragmentRoot);
                    break;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            Logger.error("Failed to set the default values from project '" + javaProject.getElementName() + "'", e);
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        int nColumns = 1;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        Label applicationStyleLabel = new Label(composite, 0);
        applicationStyleLabel.setText(JaxrsApplicationCreationMessages.JaxrsApplicationCreationWizardPage_ApplicationStyle);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)applicationStyleLabel);
        this.createJavaApplicationControls(composite);
        this.createWebxmlApplicationControls(composite);
        this.createSkipApplicationControls(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        this.doStatusUpdate();
        this.updateApplicationCreationModeControls();
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        this.doStatusUpdate();
    }

    private void doStatusUpdate() {
        Status applicationAlreadyExistsWarningStatus = new Status(2, "org.jboss.tools.ws.jaxrs.ui", JaxrsApplicationCreationMessages.JaxrsApplicationCreationWizardPage_ApplicationAlreadyExistsWarning);
        if (this.applicationMode == 0 && !this.applicationAlreadyExists) {
            IStatus[] status = new IStatus[]{this.fContainerStatus, this.fPackageStatus, this.fTypeNameStatus, this.fModifierStatus, this.fSuperClassStatus, this.fSuperInterfacesStatus, this.javaApplicationApplicationPathStatus};
            this.updateStatus(status);
        } else if (this.applicationMode == 0 && this.applicationAlreadyExists) {
            IStatus[] status = new IStatus[]{this.fContainerStatus, this.fPackageStatus, this.fTypeNameStatus, this.fModifierStatus, this.fSuperClassStatus, this.fSuperInterfacesStatus, this.javaApplicationApplicationPathStatus, applicationAlreadyExistsWarningStatus};
            this.updateStatus(status);
        } else if (this.applicationMode == 1 && !this.applicationAlreadyExists) {
            IStatus[] status = new IStatus[]{this.webxmlApplicationApplicationPathStatus};
            this.updateStatus(status);
        } else if (this.applicationMode == 1 && !this.applicationAlreadyExists) {
            IStatus[] status = new IStatus[]{this.webxmlApplicationApplicationPathStatus, applicationAlreadyExistsWarningStatus};
            this.updateStatus(status);
        } else if (this.applicationMode == 2 && !this.applicationAlreadyExists) {
            IStatus[] status = new IStatus[]{new Status(2, "org.jboss.tools.ws.jaxrs.ui", JaxrsApplicationCreationMessages.JaxrsApplicationCreationWizardPage_SkipApplicationCreationWarning)};
            this.updateStatus(status);
        } else if (this.applicationMode == 2 && this.applicationAlreadyExists) {
            IStatus[] status = new IStatus[]{new Status(2, "org.jboss.tools.ws.jaxrs.ui", "")};
            this.updateStatus(status);
        }
    }

    private void createJavaApplicationControls(Composite composite) {
        Composite containerComposite = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(containerComposite);
        GridDataFactory.fillDefaults().indent(30, 0).align(4, 0x1000000).grab(true, false).applyTo((Control)containerComposite);
        this.createContainerControls(containerComposite, 4);
        this.createJavaApplicationButton = new Button(composite, 16);
        this.createJavaApplicationButton.setText(JaxrsApplicationCreationMessages.JaxrsApplicationCreationWizardPage_JavaApplicationCreation);
        this.createJavaApplicationButton.setSelection(true);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)this.createJavaApplicationButton);
        this.createJavaApplicationButton.addSelectionListener(this.onSelectJavaApplication());
        this.javaApplicationControlsContainer = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(this.javaApplicationControlsContainer);
        GridDataFactory.fillDefaults().indent(30, 0).align(4, 0x1000000).grab(true, false).applyTo((Control)this.javaApplicationControlsContainer);
        this.createPackageControls(this.javaApplicationControlsContainer, 4);
        this.createTypeNameControls(this.javaApplicationControlsContainer, 4);
        Label applicationPathLabel = new Label(this.javaApplicationControlsContainer, 0);
        applicationPathLabel.setText("Application path:");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)applicationPathLabel);
        this.javaApplicationApplicationPathText = new Text(this.javaApplicationControlsContainer, 2048);
        this.javaApplicationApplicationPathText.setText(this.getApplicationPath());
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).grab(true, false).applyTo((Control)this.javaApplicationApplicationPathText);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)new Label(this.javaApplicationControlsContainer, 0));
        this.javaApplicationApplicationPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                JaxrsApplicationCreationWizardPage.this.onJavaApplicationPathChange();
                JaxrsApplicationCreationWizardPage.this.doStatusUpdate();
            }
        });
        this.createCommentControls(this.javaApplicationControlsContainer, 4);
        this.enableCommentControl(true);
    }

    protected IStatus superClassChanged() {
        IStatus status = super.superClassChanged();
        if (status.getSeverity() == 4) {
            return status;
        }
        if (this.getJavaProject() != null && this.getJavaProject().exists() && this.getSuperClass() != null && !this.getSuperClass().isEmpty()) {
            try {
                IType selectedSuperClass = this.getJavaProject().findType(this.getSuperClass());
                List selectedSuperClassHierarchy = JdtUtils.findSupertypes((IType)selectedSuperClass);
                if (selectedSuperClassHierarchy != null) {
                    for (IType type : selectedSuperClassHierarchy) {
                        if (!type.getFullyQualifiedName().equals("javax.ws.rs.core.Application")) continue;
                        return status;
                    }
                    return new Status(4, "org.jboss.tools.ws.jaxrs.ui", JaxrsApplicationCreationMessages.JaxrsApplicationCreationWizardPage_IllegalTypeHierarchy);
                }
            }
            catch (CoreException e) {
                Logger.error("Failed to retrieve type hierarchy for '" + this.getSuperClass() + "'", e);
            }
        }
        return status;
    }

    private void onJavaApplicationPathChange() {
        this.applicationPath = this.javaApplicationApplicationPathText.getText();
        this.javaApplicationApplicationPathStatus = this.getApplicationPath() == null ? new Status(2, "org.jboss.tools.ws.jaxrs.ui", JaxrsApplicationCreationMessages.JaxrsApplicationCreationWizardPage_EmptyApplicationPath) : new Status(0, "org.jboss.tools.ws.jaxrs.ui", null);
        this.doStatusUpdate();
    }

    private SelectionListener onSelectJavaApplication() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JaxrsApplicationCreationWizardPage.this.applicationMode = 0;
                JaxrsApplicationCreationWizardPage.this.updateApplicationCreationModeControls();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    private void createWebxmlApplicationControls(Composite composite) {
        this.createWebxmlApplicationButton = new Button(composite, 16);
        this.createWebxmlApplicationButton.setText(JaxrsApplicationCreationMessages.JaxrsApplicationCreationWizardPage_WebxmlApplicationCreation);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)this.createWebxmlApplicationButton);
        this.createWebxmlApplicationButton.addSelectionListener(this.onSelectWebxmlApplication());
        this.webxmlApplicationControlsContainer = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(this.webxmlApplicationControlsContainer);
        GridDataFactory.fillDefaults().indent(30, 0).align(4, 0x1000000).grab(true, false).applyTo((Control)this.webxmlApplicationControlsContainer);
        Label applicationPathLabel = new Label(this.webxmlApplicationControlsContainer, 0);
        applicationPathLabel.setText("Application path:");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)applicationPathLabel);
        this.webxmlApplicationApplicationPathText = new Text(this.webxmlApplicationControlsContainer, 2048);
        this.webxmlApplicationApplicationPathText.setText(this.getApplicationPath());
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).grab(true, false).applyTo((Control)this.webxmlApplicationApplicationPathText);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)new Label(composite, 0));
        this.webxmlApplicationApplicationPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                JaxrsApplicationCreationWizardPage.this.onWebxmlApplicationPathChange();
                JaxrsApplicationCreationWizardPage.this.doStatusUpdate();
            }
        });
    }

    private void onWebxmlApplicationPathChange() {
        this.applicationPath = this.webxmlApplicationApplicationPathText.getText();
        this.webxmlApplicationApplicationPathStatus = this.getApplicationPath() == null ? new Status(4, "org.jboss.tools.ws.jaxrs.ui", JaxrsApplicationCreationMessages.JaxrsApplicationCreationWizardPage_EmptyApplicationPath) : new Status(0, "org.jboss.tools.ws.jaxrs.ui", null);
        this.doStatusUpdate();
    }

    private SelectionListener onSelectWebxmlApplication() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JaxrsApplicationCreationWizardPage.this.applicationMode = 1;
                JaxrsApplicationCreationWizardPage.this.updateApplicationCreationModeControls();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    private void createSkipApplicationControls(Composite composite) {
        this.skipApplicationButton = new Button(composite, 16);
        this.skipApplicationButton.setText(JaxrsApplicationCreationMessages.JaxrsApplicationCreationWizardPage_SkipApplicationCreation);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)this.skipApplicationButton);
        this.skipApplicationButton.addSelectionListener(this.onSelectSkipApplication());
        if (!this.canSkipApplicationCreation) {
            this.skipApplicationButton.setVisible(false);
        }
    }

    private SelectionListener onSelectSkipApplication() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JaxrsApplicationCreationWizardPage.this.applicationMode = 2;
                JaxrsApplicationCreationWizardPage.this.updateApplicationCreationModeControls();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    private void updateApplicationCreationModeControls() {
        Control control;
        this.skipApplicationButton.setSelection(this.applicationMode == 2);
        this.createJavaApplicationButton.setSelection(this.applicationMode == 0);
        this.createWebxmlApplicationButton.setSelection(this.applicationMode == 1);
        Control[] controlArray = this.javaApplicationControlsContainer.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            control = controlArray[n2];
            control.setEnabled(this.applicationMode == 0);
            ++n2;
        }
        controlArray = this.webxmlApplicationControlsContainer.getChildren();
        n = controlArray.length;
        n2 = 0;
        while (n2 < n) {
            control = controlArray[n2];
            control.setEnabled(this.applicationMode == 1);
            ++n2;
        }
        this.doStatusUpdate();
    }

    public int getApplicationMode() {
        return this.applicationMode;
    }

    public void setApplicationMode(int applicationMode) {
        this.applicationMode = applicationMode;
    }

    public String getApplicationPath() {
        return this.applicationPath;
    }

    public void createType(IProgressMonitor monitor) throws CoreException, InterruptedException {
        if (this.applicationMode == 0) {
            super.createType(monitor);
        } else if (this.applicationMode == 1) {
            this.createWebXmlApplication(monitor);
        }
    }

    private void createWebXmlApplication(IProgressMonitor monitor) {
        if (this.getJavaProject() != null) {
            IProject project = this.getJavaProject().getProject();
            final IModelProvider provider = ModelProviderManager.getModelProvider((IProject)project);
            provider.modify(new Runnable(){

                @Override
                public void run() {
                    Object object = provider.getModelObject();
                    if (object instanceof WebApp) {
                        WebApp webApp = (WebApp)object;
                        ServletMapping servletMapping = WebFactory.eINSTANCE.createServletMapping();
                        servletMapping.setServletName("javax.ws.rs.core.Application");
                        UrlPatternType urlPattern = JavaeeFactory.eINSTANCE.createUrlPatternType();
                        urlPattern.setValue(JaxrsApplicationCreationWizardPage.this.getApplicationPath());
                        servletMapping.getUrlPatterns().add(urlPattern);
                        webApp.getServletMappings().add(servletMapping);
                        webApp.getServletMappings();
                    }
                }
            }, IModelProvider.FORCESAVE);
        }
    }

    public IFile getWebxmlResource() throws CoreException {
        if (this.getJavaProject() != null) {
            return WtpUtils.getWebDeploymentDescriptor((IProject)this.getJavaProject().getProject());
        }
        return null;
    }

    protected void createTypeMembers(IType newType, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        this.createInheritedMethods(newType, false, true, imports, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        JaxrsElementCreationUtils.addAnnotation((IMember)newType, "javax.ws.rs.ApplicationPath", Arrays.asList(this.applicationPath), imports);
    }
}

