/*
 * Decompiled with CFR 0.152.
 */
package tern.angular.modules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import tern.angular.modules.AngularModulesManager;
import tern.angular.modules.Directive;
import tern.angular.modules.DirectiveParameter;
import tern.angular.modules.IDirectiveProvider;
import tern.angular.modules.Restriction;

public class DOMDirectiveProvider
implements IDirectiveProvider {
    private static final DOMDirectiveProvider INSTANCE = new DOMDirectiveProvider();

    public static DOMDirectiveProvider getInstance() {
        return INSTANCE;
    }

    @Override
    public Directive getAngularDirective(Object project, Attr attr) {
        if (attr == null) {
            return null;
        }
        return AngularModulesManager.getInstance().getDirective(project, attr.getOwnerElement().getNodeName(), attr.getName(), Restriction.A);
    }

    @Override
    public Directive getAngularDirective(Object project, Element element) {
        if (element == null) {
            return null;
        }
        return AngularModulesManager.getInstance().getDirective(project, null, element.getTagName(), Restriction.E);
    }

    @Override
    public DirectiveParameter getAngularDirectiveParameter(Object project, Attr attr) {
        Element element = attr.getOwnerElement();
        Directive elementDirective = this.getAngularDirective(project, element);
        if (elementDirective != null) {
            return elementDirective.getParameter(attr.getName());
        }
        List<Directive> directives = this.getAngularDirectives(project, attr.getOwnerElement(), attr);
        DirectiveParameter parameter = null;
        for (Directive directive : directives) {
            parameter = directive.getParameter(attr.getName());
            if (parameter == null) continue;
            return parameter;
        }
        return null;
    }

    public List<Directive> getAngularDirectives(Object project, Element element, Attr selectedAttr) {
        if (element == null) {
            return Collections.emptyList();
        }
        List<Directive> names = null;
        NamedNodeMap attributes = element.getAttributes();
        int length = attributes.getLength();
        Attr attr = null;
        int i = 0;
        while (i < length) {
            Directive directive;
            attr = (Attr)attributes.item(i);
            if (!(selectedAttr != null && selectedAttr.equals(attr) || (directive = this.getAngularDirective(project, attr)) == null)) {
                if (names == null) {
                    names = new ArrayList<Directive>();
                }
                names.add(directive);
            }
            ++i;
        }
        return names != null ? names : Collections.emptyList();
    }
}

