/*
 * Decompiled with CFR 0.152.
 */
package tern.scriptpath.impl;

import java.util.ArrayList;
import java.util.Collection;
import minimatch.Minimatch;
import minimatch.PathAdapter;
import tern.ITernProject;
import tern.scriptpath.ITernScriptPath;
import tern.scriptpath.ITernScriptPathContainer;
import tern.scriptpath.impl.AbstractTernScriptPath;

public abstract class ContainerTernScriptPath
extends AbstractTernScriptPath
implements ITernScriptPathContainer {
    private final Collection<Minimatch> inclusionMinimatchs;
    private final Collection<Minimatch> exclusionMinimatchs;
    private String[] inclusionPatterns;
    private String[] exclusionPatterns;

    public ContainerTernScriptPath(ITernProject project, ITernScriptPath.ScriptPathsType type, String[] inclusionPatterns, String[] exclusionPatterns, String externalLabel) {
        super(project, type, externalLabel);
        this.inclusionPatterns = inclusionPatterns;
        this.exclusionPatterns = exclusionPatterns;
        this.inclusionMinimatchs = this.create(inclusionPatterns);
        this.exclusionMinimatchs = this.create(exclusionPatterns);
    }

    private Collection<Minimatch> create(String[] patterns) {
        if (patterns == null || patterns.length < 1) {
            return null;
        }
        ArrayList<Minimatch> minimatchs = new ArrayList<Minimatch>();
        int i = 0;
        while (i < patterns.length) {
            minimatchs.add(new Minimatch(patterns[i]));
            ++i;
        }
        return minimatchs;
    }

    public <T> boolean isInScope(T filename, PathAdapter<T> adapter) {
        if (filename == null) {
            return false;
        }
        if (this.inclusionMinimatchs == null && this.exclusionMinimatchs == null) {
            return true;
        }
        if (this.inclusionMinimatchs != null) {
            boolean include = false;
            for (Minimatch minimatch : this.inclusionMinimatchs) {
                if (!minimatch.match(filename, adapter)) continue;
                include = true;
                break;
            }
            if (!include) {
                return false;
            }
        }
        if (this.exclusionMinimatchs != null) {
            for (Minimatch minimatch : this.exclusionMinimatchs) {
                if (!minimatch.match(filename, adapter)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String[] getInclusionPatterns() {
        return this.inclusionPatterns;
    }

    public boolean hasInclusionPatterns() {
        return this.getInclusionPatterns() != null && this.getInclusionPatterns().length > 0;
    }

    @Override
    public String[] getExclusionPatterns() {
        return this.exclusionPatterns;
    }

    public boolean hasExclusionPatterns() {
        return this.getExclusionPatterns() != null && this.getExclusionPatterns().length > 0;
    }

    public String toString() {
        return "[" + (Object)((Object)this.getType()) + "]" + ", path(\"" + this.getPath() + "\")" + " including(" + this.toString(this.getInclusionPatterns()) + ")" + ", excluding(" + this.toString(this.getExclusionPatterns()) + ")";
    }

    private String toString(String[] patterns) {
        if (patterns == null) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < patterns.length) {
            if (i > 0) {
                s.append(",");
            }
            s.append(patterns[i]);
            ++i;
        }
        return s.toString();
    }
}

