/*
 * Decompiled with CFR 0.152.
 */
package tern.server.protocol.lint;

import tern.server.protocol.IJSONObjectHelper;
import tern.server.protocol.ITernResultProcessor;
import tern.server.protocol.TernDoc;
import tern.server.protocol.lint.ITernLintCollector;
import tern.server.protocol.lint.TernLintQuery;
import tern.server.protocol.lint.TernLintResultHelper;

public class TernLintResultProcessor
implements ITernResultProcessor<ITernLintCollector> {
    private static final String MESSAGES_FIELD = "messages";
    public static final TernLintResultProcessor INSTANCE = new TernLintResultProcessor();

    @Override
    public void process(TernDoc doc, IJSONObjectHelper helper, Object jsonObject, ITernLintCollector collector) {
        block9: {
            Iterable<Object> messages = helper.getList(jsonObject, MESSAGES_FIELD);
            if (messages == null) break block9;
            TernLintQuery query = (TernLintQuery)doc.getQuery();
            if (query.isGroupByFiles()) {
                String file = null;
                for (Object fileObject : messages) {
                    file = TernLintResultHelper.getFile(fileObject, helper);
                    try {
                        collector.startLint(file);
                        Iterable<Object> messagesFile = helper.getList(fileObject, MESSAGES_FIELD);
                        if (messagesFile == null) continue;
                        this.addMessages(helper, messagesFile, query, collector);
                    }
                    finally {
                        collector.endLint(file);
                    }
                }
            } else {
                String file = doc.getQuery().getFile();
                try {
                    collector.startLint(file);
                    this.addMessages(helper, messages, query, collector);
                }
                finally {
                    collector.endLint(file);
                }
            }
        }
    }

    protected void addMessages(IJSONObjectHelper helper, Iterable<Object> messages, TernLintQuery query, ITernLintCollector collector) {
        String messageId = null;
        String message = null;
        String severity = null;
        String file = null;
        for (Object messageObject : messages) {
            messageId = TernLintResultHelper.getMessageId(messageObject, helper);
            message = TernLintResultHelper.getMessage(messageObject, query, helper);
            severity = TernLintResultHelper.getSeverity(messageObject, helper);
            Long startCh = TernLintResultHelper.getStart(messageObject, helper);
            Long endCh = TernLintResultHelper.getEnd(messageObject, helper);
            Long line = TernLintResultHelper.getLine(messageObject, helper);
            file = TernLintResultHelper.getFile(messageObject, helper);
            collector.addMessage(messageId, message, startCh, endCh, line, severity, file, messageObject, query, helper);
        }
    }
}

