/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.core;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import tern.eclipse.ide.core.IIDETernRepository;
import tern.repository.TernRepository;

public class IDETernRepository
extends TernRepository
implements IIDETernRepository {
    private IPath location;
    private IProject project;

    public IDETernRepository(String name, File baseDir) {
        super(name, baseDir);
    }

    public IDETernRepository(String name, File baseDir, boolean defaultRepository) {
        super(name, baseDir, defaultRepository);
    }

    @Override
    public IPath getLocation() {
        return this.location;
    }

    @Override
    public boolean isImported() {
        return this.getProject() != null;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    @Override
    public IFile getTernServerFile() {
        IFile ternFile;
        if (this.project != null && (ternFile = this.project.getFile((IPath)new Path("node_modules/tern/bin/tern"))) != null && ternFile.exists()) {
            return ternFile;
        }
        return null;
    }

    public void setBaseDir(File baseDir) {
        super.setBaseDir(baseDir);
        this.location = new Path(this.getBaseDir().toString());
        this.tryToGetProject();
    }

    private void tryToGetProject() {
        IContainer container = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(this.location);
        if (container != null && container.exists() && container.getType() == 4) {
            this.project = (IProject)container;
        }
    }

    @Override
    public IIDETernRepository copy() {
        return new IDETernRepository(this.getName(), this.getBaseDir(), this.isDefault());
    }
}

