/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.core;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class TernModuleInstall {
    private static final String ID_ATTR = "id";
    private static final String NAME_ATTR = "name";
    private static final String SRC_ATTR = "src";
    private final String name;
    private final String id;
    private final File src;

    public TernModuleInstall(IConfigurationElement element) throws IOException {
        this.name = element.getAttribute(NAME_ATTR);
        this.id = element.getAttribute(ID_ATTR);
        String pluginId = element.getNamespaceIdentifier();
        this.src = this.getFile(element.getAttribute(SRC_ATTR), pluginId);
    }

    private File getFile(String src, String pluginId) throws IOException {
        Bundle bundle = Platform.getBundle((String)pluginId);
        URL moduleUrl = FileLocator.toFileURL((URL)bundle.getEntry(src));
        if (moduleUrl == null || !"file".equals(moduleUrl.getProtocol())) {
            throw new IOException(NLS.bind((String)"Unable to obtain a file URL for {0} in plug-in {1}", (Object)src, (Object)pluginId));
        }
        return new File(moduleUrl.getPath()).getCanonicalFile();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public File getSrc() {
        return this.src;
    }

    public void dispose() {
    }
}

