/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.core;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import tern.ITernProject;
import tern.eclipse.ide.core.DefaultTernModule;
import tern.eclipse.ide.core.IDefaultTernModulesProvider;
import tern.eclipse.ide.core.ITernNatureCapability;
import tern.eclipse.ide.core.ITernRepositoryManager;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.core.preferences.TernCorePreferenceConstants;
import tern.eclipse.ide.internal.core.DefaultTernNatureAdapter;
import tern.eclipse.ide.internal.core.Trace;
import tern.eclipse.ide.internal.core.resources.IDETernProject;
import tern.metadata.TernModuleMetadata;
import tern.server.ITernModule;
import tern.utils.StringUtils;
import tern.utils.TernModuleHelper;

public class TernNatureAdaptersManager
implements IRegistryChangeListener {
    private static final String EXTENSION_TERN_NATURE_ADAPTERS = "ternNatureAdapters";
    private static final TernNatureAdaptersManager INSTANCE = new TernNatureAdaptersManager();
    private Map<ITernNatureCapability, List<DefaultTernModule>> ternNatureAdapters;
    private boolean registryListenerIntialized = false;

    public static TernNatureAdaptersManager getManager() {
        return INSTANCE;
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas("tern.eclipse.ide.core", EXTENSION_TERN_NATURE_ADAPTERS);
        if (deltas != null) {
            IExtensionDelta[] iExtensionDeltaArray = deltas;
            int n = deltas.length;
            int n2 = 0;
            while (n2 < n) {
                IExtensionDelta delta = iExtensionDeltaArray[n2];
                this.handleTernNatureAdapterDelta(delta);
                ++n2;
            }
        }
    }

    private synchronized void loadTernNatureAdapters() {
        if (this.ternNatureAdapters != null) {
            return;
        }
        Trace.trace((byte)7, "->- Loading .ternNatureAdapters extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("tern.eclipse.ide.core", EXTENSION_TERN_NATURE_ADAPTERS);
        HashMap<ITernNatureCapability, List<DefaultTernModule>> map = new HashMap<ITernNatureCapability, List<DefaultTernModule>>(cf.length);
        this.addTernNatureAdapters(cf, map);
        this.addRegistryListenerIfNeeded();
        this.ternNatureAdapters = map;
        Trace.trace((byte)7, "-<- Done loading .ternNatureAdapters extension point -<-");
    }

    private synchronized void addTernNatureAdapters(IConfigurationElement[] cf, Map<ITernNatureCapability, List<DefaultTernModule>> map) {
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            String id = ce.getAttribute("id");
            String className = ce.getAttribute("class");
            try {
                if (!StringUtils.isEmpty((String)className)) {
                    map.put((ITernNatureCapability)ce.createExecutableExtension("class"), this.getDefaultModules(ce));
                } else if (!StringUtils.isEmpty((String)id)) {
                    map.put(new DefaultTernNatureAdapter(id), this.getDefaultModules(ce));
                }
                Trace.trace((byte)7, "  Loaded project describer: " + id != null ? id : (className != null ? className : ""));
            }
            catch (Throwable t) {
                Trace.trace((byte)3, "  Could not load project describers: " + id != null ? id : (className != null ? className : ""), t);
            }
            ++n2;
        }
    }

    private List<DefaultTernModule> getDefaultModules(IConfigurationElement ce) {
        ArrayList<DefaultTernModule> defaultModules = new ArrayList<DefaultTernModule>();
        IConfigurationElement[] iConfigurationElementArray = ce.getChildren("defaultModules");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement dmce = iConfigurationElementArray[n2];
            IConfigurationElement[] iConfigurationElementArray2 = dmce.getChildren("module");
            int n3 = iConfigurationElementArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement mce = iConfigurationElementArray2[n4];
                String module = mce.getAttribute("name");
                if (module != null && !module.trim().isEmpty()) {
                    String name = module.trim();
                    boolean withDependencies = StringUtils.asBoolean((String)mce.getAttribute("withDependencies"), (boolean)false);
                    JsonObject options = this.getOptions(mce.getAttribute("options"));
                    defaultModules.add(new DefaultTernModule(name, withDependencies, options));
                }
                ++n4;
            }
            ++n2;
        }
        return defaultModules;
    }

    private JsonObject getOptions(String options) {
        if (!StringUtils.isEmpty((String)options)) {
            try {
                return JsonObject.readFrom((String)options);
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    protected void handleTernNatureAdapterDelta(IExtensionDelta delta) {
        if (this.ternNatureAdapters == null) {
            return;
        }
        IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
        HashMap<ITernNatureCapability, List<DefaultTernModule>> map = new HashMap<ITernNatureCapability, List<DefaultTernModule>>(this.ternNatureAdapters);
        if (delta.getKind() == 1) {
            this.addTernNatureAdapters(cf, map);
        }
        this.ternNatureAdapters = map;
    }

    private void addRegistryListenerIfNeeded() {
        if (this.registryListenerIntialized) {
            return;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addRegistryChangeListener((IRegistryChangeListener)this, "tern.eclipse.ide.core");
        this.registryListenerIntialized = true;
    }

    public void initialize() {
    }

    public void destroy() {
        if (this.ternNatureAdapters == null) {
            return;
        }
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasTernNature(IProject project) {
        if (!project.isAccessible()) return false;
        try {
            ITernNatureCapability natureAdapter;
            if (project.getFile(".tern-project").exists()) {
                return true;
            }
            Map<ITernNatureCapability, List<DefaultTernModule>> ternNatureAdapters = this.getTernNatureAdapters();
            Iterator<ITernNatureCapability> iterator = ternNatureAdapters.keySet().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(natureAdapter = iterator.next()).hasTernNature(project));
            return true;
        }
        catch (CoreException e) {
            Trace.trace((byte)3, "Error tern nature", e);
        }
        return false;
    }

    private Map<ITernNatureCapability, List<DefaultTernModule>> getTernNatureAdapters() {
        if (this.ternNatureAdapters == null) {
            this.loadTernNatureAdapters();
        }
        return this.ternNatureAdapters;
    }

    public void addDefaultModules(IDETernProject ternProject) throws CoreException {
        if (ternProject.hasModules()) {
            return;
        }
        ArrayList<ITernModule> contributedModules = new ArrayList<ITernModule>();
        HashMap<ITernModule, JsonObject> moduleOptions = new HashMap<ITernModule, JsonObject>();
        ITernModule moduleFromPreferences = null;
        ITernModule[] modulesFromPreferences = this.getModulesFromPreferences(ternProject);
        int i = 0;
        while (i < modulesFromPreferences.length) {
            moduleFromPreferences = modulesFromPreferences[i];
            if (!contributedModules.contains(moduleFromPreferences)) {
                contributedModules.add(moduleFromPreferences);
            }
            ++i;
        }
        ITernRepositoryManager repositoryManager = TernCorePlugin.getTernRepositoryManager();
        Map<ITernNatureCapability, List<DefaultTernModule>> ternNatureAdapters = this.getTernNatureAdapters();
        for (ITernNatureCapability natureAdapter : ternNatureAdapters.keySet()) {
            if (!natureAdapter.hasTernNature(ternProject.getProject())) continue;
            Collection<DefaultTernModule> defaultModules = (Collection<DefaultTernModule>)ternNatureAdapters.get(natureAdapter);
            for (DefaultTernModule defaultModule : defaultModules) {
                this.collectionDefaultModule(defaultModule, ternProject, contributedModules, moduleOptions, repositoryManager);
            }
            if (!(natureAdapter instanceof IDefaultTernModulesProvider) || (defaultModules = ((IDefaultTernModulesProvider)((Object)natureAdapter)).getTernModules(ternProject.getProject())) == null) continue;
            for (DefaultTernModule defaultModule : defaultModules) {
                this.collectionDefaultModule(defaultModule, ternProject, contributedModules, moduleOptions, repositoryManager);
            }
        }
        TernModuleHelper.sort(contributedModules);
        JsonObject options = null;
        for (ITernModule module : contributedModules) {
            options = (JsonObject)moduleOptions.get(module);
            TernModuleHelper.update((ITernModule)module, (JsonValue)options, (ITernProject)ternProject);
        }
    }

    private void collectionDefaultModule(DefaultTernModule defaultModule, IDETernProject ternProject, List<ITernModule> contributedModules, Map<ITernModule, JsonObject> moduleOptions, ITernRepositoryManager repositoryManager) {
        ITernModule module = repositoryManager.findTernModule(defaultModule.getName(), ternProject);
        if (module != null) {
            TernModuleMetadata metadata;
            if (!contributedModules.contains(module)) {
                contributedModules.add(module);
                if (defaultModule.getOptions() != null) {
                    moduleOptions.put(module, defaultModule.getOptions());
                }
            }
            if (defaultModule.isWithDependencies() && (metadata = module.getMetadata()) != null) {
                Collection dependencies = metadata.getDependencies(module.getVersion());
                for (String dependency : dependencies) {
                    ITernModule dependencyModule = repositoryManager.findTernModule(dependency, ternProject);
                    if (dependencyModule == null || contributedModules.contains(dependencyModule)) continue;
                    contributedModules.add(dependencyModule);
                }
            }
        }
    }

    private ITernModule[] getModulesFromPreferences(IDETernProject ternProject) {
        IScopeContext[] lookupOrder = new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE};
        String moduleNames = Platform.getPreferencesService().getString(TernCorePlugin.getDefault().getBundle().getSymbolicName(), "defaultTernModules", TernCorePreferenceConstants.DEFAULT_TERN_MODULES_VALUE, lookupOrder);
        return TernCorePlugin.getTernRepositoryManager().getTernModules(moduleNames, ternProject);
    }
}

