/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.core.scriptpath;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import tern.ITernProject;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.core.IIDETernScriptPathReporter;
import tern.eclipse.ide.core.utils.PathUtils;
import tern.eclipse.ide.internal.core.Trace;
import tern.eclipse.ide.internal.core.scriptpath.EclipsePathAdapter;
import tern.eclipse.ide.internal.core.scriptpath.IIDETernScriptPath;
import tern.eclipse.ide.internal.core.scriptpath.ScriptResourceProxyVisitor;
import tern.scriptpath.ITernScriptResource;
import tern.scriptpath.impl.ProjectScriptPath;

public class EclipseProjectScriptPath
extends ProjectScriptPath
implements IIDETernScriptPath {
    private final IIDETernScriptPathReporter reporter;

    public EclipseProjectScriptPath(ITernProject project, ITernProject ownerProject, String[] inclusionPatterns, String[] exclusionPatterns, String external) {
        super(project, ownerProject, inclusionPatterns, exclusionPatterns, external);
        this.reporter = ((IIDETernProject)project).getScriptPathReporter();
    }

    protected void collect(List<ITernScriptResource> scripts) {
        super.collect(scripts);
        IProject container = ((IIDETernProject)super.getProject()).getProject();
        ScriptResourceProxyVisitor visitor = new ScriptResourceProxyVisitor(this, scripts, this.reporter);
        try {
            if (container.exists()) {
                container.accept((IResourceProxyVisitor)visitor, 0);
            }
        }
        catch (CoreException e) {
            Trace.trace((byte)3, "Error while retrieving script resources from the project script path " + container.getName(), e);
        }
    }

    @Override
    public boolean isBelongToContainer(IPath path) {
        IProject project = ((IIDETernProject)this.getOwnerProject()).getProject();
        IPath projectPath = project.getFullPath();
        return PathUtils.isBelongToContainer(path, projectPath);
    }

    @Override
    public boolean isInScope(IPath path, int resourceType) {
        IProject project = ((IIDETernProject)this.getOwnerProject()).getProject();
        IPath projectPath = project.getFullPath();
        IPath relativePath = PathUtils.getRelativePath(path, projectPath, resourceType);
        return this.isInScope(relativePath, EclipsePathAdapter.INSTANCE);
    }
}

