/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.jsdt.internal.ui.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.PartInitException;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.ui.search.ElementQuerySpecification;
import org.eclipse.wst.jsdt.ui.search.IMatchPresentation;
import org.eclipse.wst.jsdt.ui.search.IQueryParticipant;
import org.eclipse.wst.jsdt.ui.search.ISearchRequestor;
import org.eclipse.wst.jsdt.ui.search.QuerySpecification;
import tern.ITernFile;
import tern.ITernProject;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.core.resources.TernDocumentFile;
import tern.eclipse.ide.jsdt.internal.ui.search.TernRef;
import tern.eclipse.ide.jsdt.internal.ui.search.TernRefLabelProvider;
import tern.eclipse.ide.ui.utils.EditorUtils;
import tern.server.protocol.ITernResultsCollector;
import tern.server.protocol.TernQuery;
import tern.server.protocol.refs.ITernRefCollector;
import tern.server.protocol.refs.TernRefsQuery;

public class TernQueryParticipant
implements IQueryParticipant,
IMatchPresentation {
    public void search(final ISearchRequestor requestor, QuerySpecification querySpecification, IProgressMonitor monitor) throws CoreException {
        if (querySpecification instanceof ElementQuerySpecification) {
            ElementQuerySpecification elementQuery = (ElementQuerySpecification)querySpecification;
            IJavaScriptElement jsElement = elementQuery.getElement();
            IResource resource = jsElement.getResource();
            if (resource == null || resource.getType() != 1) {
                return;
            }
            IFile file = (IFile)resource;
            IProject project = file.getProject();
            if (TernCorePlugin.hasTernNature((IProject)project)) {
                final IIDETernProject ternProject = TernCorePlugin.getTernProject((IProject)project);
                IDocument document = EditorUtils.getDocument((IFile)file);
                TernDocumentFile ternFile = document != null ? new TernDocumentFile(file, document) : null;
                Integer end = this.getEnd(jsElement);
                if (end != null) {
                    String filename = ternFile.getFullName((ITernProject)ternProject);
                    TernRefsQuery query = new TernRefsQuery(filename, end);
                    ITernRefCollector collector = new ITernRefCollector(){

                        public void setDefinition(String filename, Long start, Long end) {
                            IFile file = ternProject.getIDEFile(filename);
                            Match match = new Match((Object)new TernRef(file), start.intValue(), end.intValue() - start.intValue());
                            requestor.reportMatch(match);
                        }
                    };
                    try {
                        ternProject.request((TernQuery)query, (ITernFile)ternFile, (ITernResultsCollector)collector);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    protected Integer getEnd(IJavaScriptElement jsElement) {
        ISourceRange range = null;
        if (jsElement instanceof ILocalVariable) {
            range = ((ILocalVariable)jsElement).getNameRange();
        } else if (jsElement instanceof ISourceReference) {
            try {
                range = ((ISourceReference)jsElement).getSourceRange();
            }
            catch (JavaScriptModelException e) {
                e.printStackTrace();
            }
        }
        if (range != null) {
            return range.getOffset() + range.getLength();
        }
        return null;
    }

    public int estimateTicks(QuerySpecification specification) {
        return 0;
    }

    public IMatchPresentation getUIParticipant() {
        return this;
    }

    public ILabelProvider createLabelProvider() {
        return new TernRefLabelProvider();
    }

    public void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        Object element = match.getElement();
        if (element instanceof TernRef) {
            IFile file = ((TernRef)element).getFile();
            EditorUtils.openInEditor((IFile)file, (int)currentOffset, (int)currentLength, (boolean)activate);
        }
    }
}

