/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.jsdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension2;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.ui.JavaScriptUI;
import org.eclipse.wst.jsdt.ui.text.java.IInvocationContext;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;
import org.eclipse.wst.jsdt.ui.text.java.IQuickFixProcessor;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;
import tern.eclipse.ide.jsdt.internal.ui.text.correction.ReplaceTextProposal;
import tern.server.protocol.lint.Fix;

public class TernLintQuickFixProcessor
implements IQuickFixProcessor {
    public boolean hasCorrections(IJavaScriptUnit unit, int problemId) {
        return false;
    }

    public IJavaCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        ArrayList<ReplaceTextProposal> proposals = new ArrayList<ReplaceTextProposal>();
        IJavaScriptUnit cu = context.getCompilationUnit();
        Iterator e = this.getOriginAnnotation(cu, locations);
        while (e.hasNext()) {
            Annotation annotation = (Annotation)e.next();
            Fix fix = this.getFix(annotation);
            if (fix == null) continue;
            proposals.add(new ReplaceTextProposal(cu, fix));
        }
        return proposals.toArray(new IJavaCompletionProposal[proposals.size()]);
    }

    private Fix getFix(Annotation annotation) {
        if (annotation instanceof TemporaryAnnotation) {
            Object fixInfo = ((TemporaryAnnotation)annotation).getAdditionalFixInfo();
            return fixInfo instanceof Fix ? (Fix)fixInfo : null;
        }
        return null;
    }

    private Iterator getOriginAnnotation(IJavaScriptUnit cu, IProblemLocation[] locations) {
        IEditorPart part = EditorUtility.isOpenInEditor((Object)cu);
        IAnnotationModel model = JavaScriptUI.getDocumentProvider().getAnnotationModel((Object)part.getEditorInput());
        if (model instanceof IAnnotationModelExtension2) {
            int start = 0;
            int end = 0;
            int i = 0;
            while (i < locations.length) {
                IProblemLocation location = locations[i];
                if (i == 0) {
                    start = location.getOffset();
                    end = location.getOffset() + location.getLength();
                } else {
                    if (start > location.getOffset()) {
                        start = location.getOffset();
                    }
                    if (end < location.getOffset() + location.getLength()) {
                        end = location.getOffset() + location.getLength();
                    }
                }
                ++i;
            }
            return ((IAnnotationModelExtension2)model).getAnnotationIterator(start, end - start, true, true);
        }
        return model.getAnnotationIterator();
    }
}

