/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.server.nodejs.internal.ui.preferences;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class WorkspaceResourceSelectionDialog
extends ElementTreeSelectionDialog {
    private static final String EMPTY_STRING = "";
    private Mode mode = Mode.FILE_FOLDER;
    private ViewerFilter[] filters;

    public WorkspaceResourceSelectionDialog(Shell parent, Mode mode) {
        super(parent, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        this.mode = mode;
        this.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length > 0 && WorkspaceResourceSelectionDialog.this.checkMode(selection[0])) {
                    return new Status(0, "tern.eclipse.ide.server.nodejs.ui", 0, WorkspaceResourceSelectionDialog.EMPTY_STRING, null);
                }
                return new Status(4, "tern.eclipse.ide.server.nodejs.ui", 4, WorkspaceResourceSelectionDialog.EMPTY_STRING, null);
            }
        });
        this.setInput(ResourcesPlugin.getWorkspace().getRoot());
    }

    public WorkspaceResourceSelectionDialog(Shell parent, Mode mode, String title, String message) {
        this(parent, mode);
        this.setTitle(title);
        this.setMessage(message);
    }

    protected boolean checkMode(Object selection) {
        return this.mode == Mode.FILE && selection instanceof IFile || this.mode == Mode.FOLDER && selection instanceof IFolder || this.mode == Mode.FILE_FOLDER;
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        FilteredTree tree = new FilteredTree(parent, style, new PatternFilter(), true);
        tree.setLayoutData((Object)new GridData(1808));
        WorkspaceResourceSelectionDialog.applyDialogFont((Control)tree);
        TreeViewer viewer = tree.getViewer();
        return viewer;
    }

    protected Control createDialogArea(Composite parent) {
        Control dialogControl = super.createDialogArea(parent);
        ViewerFilter[] filters = this.getTreeViewer().getFilters();
        if (!(filters.length <= 0 || filters.length == 1 && filters[0] instanceof PatternFilter)) {
            this.filters = filters;
            final Button showAllFilesButton = new Button((Composite)dialogControl, 32);
            showAllFilesButton.setText("Show all files");
            GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).grab(true, false).span(2, 2).applyTo((Control)showAllFilesButton);
            showAllFilesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (showAllFilesButton.getSelection()) {
                        ViewerFilter[] viewerFilterArray = WorkspaceResourceSelectionDialog.this.filters;
                        int n = viewerFilterArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ViewerFilter viewerFilter = viewerFilterArray[n2];
                            WorkspaceResourceSelectionDialog.this.getTreeViewer().removeFilter(viewerFilter);
                            ++n2;
                        }
                    } else {
                        ViewerFilter[] viewerFilterArray = WorkspaceResourceSelectionDialog.this.filters;
                        int n = viewerFilterArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            ViewerFilter viewerFilter = viewerFilterArray[n3];
                            WorkspaceResourceSelectionDialog.this.getTreeViewer().addFilter(viewerFilter);
                            ++n3;
                        }
                    }
                }
            });
        }
        return dialogControl;
    }

    public static enum Mode {
        FILE,
        FOLDER,
        FILE_FOLDER;

    }
}

