/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.ui.util;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class AllInOneWorkbenchListener
implements IWindowListener,
IPerspectiveListener,
IPartListener,
IPageListener {
    public void initialize() {
        new Job("Init AllInOneWorkbenchListener"){
            {
                this.setSystem(true);
            }

            protected IStatus run(IProgressMonitor monitor) {
                if (PlatformUI.isWorkbenchRunning()) {
                    final IWorkbench workbench = PlatformUI.getWorkbench();
                    workbench.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            AllInOneWorkbenchListener.this.hookListeners(workbench);
                        }
                    });
                } else {
                    this.schedule(100L);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void dispose() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        this.unhookListeners(workbench);
    }

    private void hookListeners(IWorkbench workbench) {
        workbench.addWindowListener((IWindowListener)this);
        IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            this.hookListeners(window);
            ++n2;
        }
    }

    private void unhookListeners(IWorkbench workbench) {
        if (workbench.getDisplay().isDisposed()) {
            return;
        }
        workbench.removeWindowListener((IWindowListener)this);
        IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            this.unhookListeners(window);
            ++n2;
        }
    }

    private void hookListeners(IWorkbenchWindow window) {
        if (window == null) {
            return;
        }
        window.addPageListener((IPageListener)this);
        window.addPerspectiveListener((IPerspectiveListener)this);
        IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
        int n = iWorkbenchPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            this.hookListeners(page);
            ++n2;
        }
    }

    private void unhookListeners(IWorkbenchWindow window) {
        if (window == null) {
            return;
        }
        window.removePageListener((IPageListener)this);
        window.removePerspectiveListener((IPerspectiveListener)this);
        IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
        int n = iWorkbenchPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            this.unhookListeners(page);
            ++n2;
        }
    }

    private void hookListeners(IWorkbenchPage page) {
        IPerspectiveDescriptor perspective = page.getPerspective();
        if (perspective != null) {
            this.perspectiveActivated(page, perspective);
        }
        page.addPartListener((IPartListener)this);
    }

    private void unhookListeners(IWorkbenchPage page) {
        page.removePartListener((IPartListener)this);
    }

    public void windowOpened(IWorkbenchWindow window) {
        this.hookListeners(window);
    }

    public void windowClosed(IWorkbenchWindow window) {
        this.unhookListeners(window);
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void pageActivated(IWorkbenchPage page) {
    }

    public void pageClosed(IWorkbenchPage page) {
        this.unhookListeners(page);
    }

    public void pageOpened(IWorkbenchPage page) {
        this.hookListeners(page);
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
    }
}

