/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.preferences;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class CheckComboFieldEditor
extends FieldEditor {
    private Button fButton;
    private String checkboxText;
    private Combo fCombo;
    private String fValue;
    private String[][] fEntryNamesAndValues;
    private String unselectedValue;

    public CheckComboFieldEditor(String name, String labelText, String[][] entryNamesAndValues, String unselectedValue, Composite parent) {
        this.init(name, "");
        Assert.isTrue((boolean)this.checkArray(entryNamesAndValues));
        this.fEntryNamesAndValues = entryNamesAndValues;
        this.checkboxText = labelText;
        this.unselectedValue = unselectedValue;
        this.createControl(parent);
    }

    private boolean checkArray(String[][] table) {
        if (table == null) {
            return false;
        }
        int i = 0;
        while (i < table.length) {
            String[] array = table[i];
            if (array == null || array.length != 2) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void adjustForNumColumns(int numColumns) {
        if (numColumns > 1) {
            int left = numColumns - 1;
            ((GridData)this.fButton.getLayoutData()).horizontalSpan = 1;
            Label control = this.getLabelControl();
            if (control != null) {
                ((GridData)control.getLayoutData()).exclude = true;
            }
            ((GridData)this.fCombo.getLayoutData()).horizontalSpan = left;
        } else {
            ((GridData)this.fButton.getLayoutData()).horizontalSpan = 1;
            Label control = this.getLabelControl();
            if (control != null) {
                ((GridData)control.getLayoutData()).exclude = true;
            }
            ((GridData)this.fCombo.getLayoutData()).horizontalSpan = 1;
        }
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        int comboC = 1;
        if (numColumns > 1) {
            comboC = numColumns - 1;
        }
        Button control = this.getCheckControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        control.setLayoutData((Object)gd);
        control.setFont(parent.getFont());
        control = this.getLabelControl(parent);
        gd = new GridData();
        gd.exclude = true;
        control.setLayoutData((Object)gd);
        control = this.getComboBoxControl(parent);
        gd = new GridData();
        gd.horizontalSpan = comboC;
        gd.horizontalAlignment = 4;
        control.setLayoutData((Object)gd);
        control.setFont(parent.getFont());
    }

    protected void doLoad() {
        this.updateComboForValue(this.getPreferenceStore().getString(this.getPreferenceName()));
    }

    protected void doLoadDefault() {
        this.updateComboForValue(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
    }

    protected void doStore() {
        if (this.fValue == null) {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
            return;
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.fValue);
    }

    public String getValue() {
        return this.fValue;
    }

    public int getSelection() {
        return this.fCombo.getSelectionIndex();
    }

    public int getNumberOfControls() {
        return 3;
    }

    private Combo getComboBoxControl(Composite parent) {
        if (this.fCombo == null) {
            this.fCombo = new Combo(parent, 8);
            this.fCombo.setFont(parent.getFont());
            int i = 0;
            while (i < this.fEntryNamesAndValues.length) {
                this.fCombo.add(this.fEntryNamesAndValues[i][0], i);
                ++i;
            }
            this.fCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    CheckComboFieldEditor.this.updateValue(CheckComboFieldEditor.this.fButton.getSelection(), CheckComboFieldEditor.this.fCombo.getText());
                }
            });
        }
        return this.fCombo;
    }

    private String getValueForName(String name) {
        int i = 0;
        while (i < this.fEntryNamesAndValues.length) {
            String[] entry = this.fEntryNamesAndValues[i];
            if (name.equals(entry[0])) {
                return entry[1];
            }
            ++i;
        }
        return this.fEntryNamesAndValues[0][0];
    }

    private void updateComboForValue(String value) {
        boolean select = !value.equals(this.unselectedValue);
        this.fButton.setSelection(select);
        this.updateComboBoxEnablement(this.fCombo.getParent(), select);
        this.fValue = value;
        int i = 0;
        while (i < this.fEntryNamesAndValues.length) {
            if (value.equals(this.fEntryNamesAndValues[i][1])) {
                this.fCombo.setText(this.fEntryNamesAndValues[i][0]);
                return;
            }
            ++i;
        }
        if (this.fEntryNamesAndValues.length > 0) {
            if (select) {
                this.fValue = this.fEntryNamesAndValues[0][1];
            }
            this.fCombo.setText(this.fEntryNamesAndValues[0][0]);
        }
        this.refreshValidState();
        if (!this.isValid()) {
            this.fireStateChanged("field_editor_is_valid", true, false);
        }
    }

    public boolean isCheckboxSelected() {
        return this.fButton == null || this.fButton.getSelection();
    }

    public void setEnabled(boolean enabled, Composite parent) {
        Button check = this.getCheckControl(parent);
        check.setEnabled(enabled);
        enabled = check.getSelection();
        super.setEnabled(enabled, parent);
        this.updateComboBoxEnablement(parent, enabled);
    }

    private void updateValue(boolean selected, String name) {
        String oldValue = this.fValue;
        this.fValue = selected ? this.getValueForName(name) : this.unselectedValue;
        this.setPresentsDefaultValue(false);
        boolean oldState = this.isValid();
        this.refreshValidState();
        if (this.isValid() != oldState) {
            this.fireStateChanged("field_editor_is_valid", oldState, this.isValid());
        }
        if (!this.fValue.equals(oldValue)) {
            this.fireValueChanged("field_editor_value", oldValue, this.fValue);
        }
    }

    protected void updateComboBoxEnablement(Composite parent, boolean enabled) {
        this.getComboBoxControl(parent).setEnabled(enabled);
        boolean oldState = this.isValid();
        this.refreshValidState();
        if (this.isValid() != oldState) {
            this.fireStateChanged("field_editor_is_valid", oldState, this.isValid());
        }
    }

    private Button getCheckControl(final Composite parent) {
        if (this.fButton == null) {
            this.fButton = new Button(parent, 32);
            this.fButton.setFont(parent.getFont());
            this.fButton.setText(this.checkboxText);
            this.fButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    CheckComboFieldEditor.this.updateComboBoxEnablement(parent, CheckComboFieldEditor.this.fButton.getSelection());
                    CheckComboFieldEditor.this.updateValue(CheckComboFieldEditor.this.fButton.getSelection(), CheckComboFieldEditor.this.fCombo.getText());
                }
            });
        }
        return this.fButton;
    }
}

