/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.utils;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.internal.ui.Trace;
import tern.eclipse.ide.ui.TernUIPlugin;
import tern.server.protocol.outline.IJSNode;
import tern.utils.StringUtils;

public class EditorUtils {
    private EditorUtils() {
    }

    public static IEditorPart openInEditor(IFile file, int start, int length, boolean activate) {
        IEditorPart editor = null;
        IWorkbenchPage page = TernUIPlugin.getActivePage();
        try {
            if (start > 0) {
                editor = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)activate);
                ITextEditor textEditor = null;
                if (editor instanceof ITextEditor) {
                    textEditor = (ITextEditor)editor;
                } else if (editor instanceof IAdaptable) {
                    textEditor = (ITextEditor)editor.getAdapter(ITextEditor.class);
                }
                if (textEditor != null) {
                    textEditor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                    textEditor.selectAndReveal(start, length);
                    page.activate((IWorkbenchPart)editor);
                } else {
                    IMarker marker = file.createMarker("org.eclipse.core.resources.textmarker");
                    marker.setAttribute("lineNumber", start);
                    editor = IDE.openEditor((IWorkbenchPage)page, (IMarker)marker, (boolean)activate);
                    marker.delete();
                }
            } else {
                editor = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)activate);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return editor;
    }

    public static void openInEditor(IJSNode node) {
        IFile file = EditorUtils.getFile(node);
        EditorUtils.openInEditor(node, file);
    }

    public static void openInEditor(IJSNode node, IFile file) {
        if (file != null && file.exists()) {
            Long start = node.getStart();
            Long end = node.getEnd();
            EditorUtils.openInEditor(file, start != null ? start.intValue() : -1, start != null && end != null ? end.intValue() - start.intValue() : -1, true);
        }
    }

    public static IFile getFile(IJSNode node) {
        IIDETernProject ternProject = (IIDETernProject)node.getTernProject();
        String file = node.getFile();
        if (StringUtils.isEmpty((String)file)) {
            return null;
        }
        return ternProject.getIDEFile(node.getFile());
    }

    public static IFile getFile(IEditorPart editor) {
        IResource resource = EditorUtils.getResource(editor);
        return resource != null && resource.getType() == 1 ? (IFile)resource : null;
    }

    public static IResource getResource(IEditorPart editor) {
        return (IResource)editor.getEditorInput().getAdapter(IResource.class);
    }

    public static ITextEditor getEditor(IWorkbenchPartReference ref) {
        IWorkbenchPart part = ref.getPart(true);
        if (part != null && part instanceof ITextEditor) {
            return (ITextEditor)part;
        }
        return null;
    }

    public static IDocument getDocument(ITextEditor editor) {
        return editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
    }

    public static ISourceViewer getSourceViewer(IEditorPart editor) {
        if (editor == null) {
            return null;
        }
        ISourceViewer viewer = (ISourceViewer)editor.getAdapter(ITextOperationTarget.class);
        return viewer;
    }

    public static IFile getFile(IDocument document) {
        IPath location;
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        ITextFileBuffer buffer = bufferManager.getTextFileBuffer(document);
        IPath iPath = location = buffer == null ? null : buffer.getLocation();
        if (location == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile(location);
    }

    public static IDocument getDocument(IFile file) {
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IPath location = file.getLocation();
        boolean connected = false;
        try {
            ITextFileBuffer buffer = manager.getTextFileBuffer(location, LocationKind.NORMALIZE);
            if (buffer == null) {
                manager.connect(location, LocationKind.NORMALIZE, (IProgressMonitor)new NullProgressMonitor());
                connected = true;
                buffer = manager.getTextFileBuffer(location, LocationKind.NORMALIZE);
                if (buffer == null) {
                    return null;
                }
            }
            IDocument iDocument = buffer.getDocument();
            return iDocument;
        }
        catch (CoreException ce) {
            Trace.trace((byte)3, "Error while get document from file", ce);
            return null;
        }
        finally {
            if (connected) {
                try {
                    manager.disconnect(location, LocationKind.NORMALIZE, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    Trace.trace((byte)3, "Error while get document from file", e);
                }
            }
        }
    }
}

