/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.views;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.internal.ui.Trace;
import tern.eclipse.ide.internal.ui.views.actions.LinkEditorAction;
import tern.eclipse.ide.internal.ui.views.actions.TerminateTernServerAction;
import tern.eclipse.ide.ui.utils.EditorUtils;
import tern.eclipse.ide.ui.views.AbstractTernOutlineView;
import tern.server.ITernServer;
import tern.server.ITernServerListener;
import tern.server.protocol.outline.IJSNode;

public abstract class AbstractTernContentOutlinePage
extends Page
implements IContentOutlinePage,
ITernServerListener,
IDocumentListener {
    private final AbstractTernOutlineView view;
    private CommonViewer viewer;
    private LinkEditorAction toggleLinkingAction;
    private TerminateTernServerAction terminateAction;
    private final IProject project;
    private IDocument currentDocument;
    private IFile currentFile;

    public AbstractTernContentOutlinePage(IProject project, AbstractTernOutlineView view) {
        this.project = project;
        this.view = view;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.viewer.addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.viewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.viewer.removePostSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.viewer.setSelection(selection);
    }

    public Control getControl() {
        return this.viewer != null ? this.viewer.getControl() : null;
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    public void createControl(Composite parent) {
        this.viewer = new CommonViewer(this.getViewerId(), parent, 2);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty() && selection.getFirstElement() instanceof IJSNode) {
                    IJSNode node = (IJSNode)selection.getFirstElement();
                    AbstractTernContentOutlinePage.this.view.openInEditor(node, true);
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IJSNode node;
                IFile nodeFile;
                AbstractTernContentOutlinePage.this.updateEnabledActions();
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty() && selection.getFirstElement() instanceof IJSNode && ((nodeFile = EditorUtils.getFile(node = (IJSNode)selection.getFirstElement())) == null || nodeFile.equals((Object)AbstractTernContentOutlinePage.this.getCurrentFile()))) {
                    AbstractTernContentOutlinePage.this.view.openInEditor(node, false);
                }
            }
        });
        this.registerActions(this.getSite().getActionBars().getToolBarManager());
        this.registerContextMenu(this.viewer.getControl());
        try {
            IProject project = this.getProject();
            TernCorePlugin.getTernProject((IProject)project).addServerListener((ITernServerListener)this);
        }
        catch (CoreException e) {
            Trace.trace((byte)3, "error while getting tern project", e);
        }
        this.updateEnabledActions();
    }

    protected void registerActions(IToolBarManager manager) {
        this.toggleLinkingAction = new LinkEditorAction(this.view, this.getViewer());
        manager.add((IAction)this.toggleLinkingAction);
        this.terminateAction = new TerminateTernServerAction(this);
        manager.add((IAction)this.terminateAction);
    }

    protected void registerContextMenu(Control control) {
    }

    public CommonViewer getViewer() {
        return this.viewer;
    }

    protected void updateEnabledActions() {
    }

    public void onStart(ITernServer server) {
        this.refreshOutline();
        this.terminateAction.setEnabled(true);
    }

    public void onStop(ITernServer server) {
        this.terminateAction.setEnabled(false);
    }

    public void dispose() {
        super.dispose();
        if (this.currentDocument != null) {
            this.currentDocument.removeDocumentListener((IDocumentListener)this);
        }
        try {
            IProject project = this.getProject();
            TernCorePlugin.getTernProject((IProject)project).removeServerListener((ITernServerListener)this);
        }
        catch (CoreException e) {
            Trace.trace((byte)3, "error while getting tern project", e);
        }
    }

    public void setCurrentFile(IFile currentFile) {
        IFile oldFile = this.currentFile;
        IDocument oldDocument = this.currentDocument;
        if (oldDocument != null) {
            oldDocument.removeDocumentListener((IDocumentListener)this);
        }
        this.currentFile = currentFile;
        this.currentDocument = EditorUtils.getDocument(currentFile);
        if (this.currentDocument != null) {
            this.currentDocument.addDocumentListener((IDocumentListener)this);
        }
        if (this.isRefreshOutline(oldFile, currentFile)) {
            this.refreshOutline();
        }
    }

    protected abstract boolean isRefreshOutline(IFile var1, IFile var2);

    protected abstract String getViewerId();

    public final IFile getCurrentFile() {
        return this.currentFile;
    }

    public IDocument getCurrentDocument() {
        return this.currentDocument;
    }

    public final IProject getProject() {
        return this.project;
    }

    public abstract IFile getFile();

    public void refreshOutline() {
        this.view.refreshOutline();
    }

    public void documentChanged(DocumentEvent event) {
        this.refreshOutline();
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }
}

