/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.views;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.texteditor.ITextEditor;
import tern.eclipse.ide.internal.ui.TernUIMessages;
import tern.eclipse.ide.ui.utils.EditorUtils;
import tern.eclipse.ide.ui.views.AbstractTernOutlineView;
import tern.server.protocol.outline.IJSNode;
import tern.utils.StringUtils;

class UpdateSelectionJob
extends Job
implements ISelectionChangedListener {
    private static final int UPDATE_DELAY = 100;
    private final AbstractTernOutlineView view;
    private ISelection selection;
    private ITextEditor textEditor;

    public UpdateSelectionJob(AbstractTernOutlineView view) {
        super(TernUIMessages.Link_With_Editor_Job_);
        super.setSystem(true);
        super.setPriority(20);
        this.view = view;
    }

    protected IStatus run(IProgressMonitor monitor) {
        BestNode bestNode = this.findBestNode(this.selection);
        if (bestNode != null) {
            try {
                this.view.ignoreSelectionChanged = true;
                final IJSNode node = bestNode.node;
                final CommonViewer viewer = bestNode.viewer;
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        viewer.setSelection((ISelection)new StructuredSelection((Object)node));
                    }
                });
            }
            finally {
                this.view.ignoreSelectionChanged = false;
            }
        }
        return Status.OK_STATUS;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectInTreeview(event.getSelection());
    }

    public void setCurrentPart(IWorkbenchPart part) {
        if (this.textEditor != null) {
            this.uninstall(this.textEditor.getSelectionProvider());
        }
        if (part instanceof ITextEditor) {
            this.textEditor = (ITextEditor)part;
            ISelectionProvider provider = this.textEditor.getSelectionProvider();
            this.selectInTreeview(provider.getSelection());
            this.install(provider);
        } else {
            this.textEditor = null;
        }
    }

    private void selectInTreeview(ISelection selection) {
        if (this.view.ignoreEditorActivation) {
            return;
        }
        this.selection = selection;
        super.schedule(100L);
    }

    private void install(ISelectionProvider selectionProvider) {
        if (selectionProvider == null) {
            return;
        }
        if (selectionProvider instanceof IPostSelectionProvider) {
            IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
            provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
        } else {
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    private void uninstall(ISelectionProvider selectionProvider) {
        if (selectionProvider == null) {
            return;
        }
        if (selectionProvider instanceof IPostSelectionProvider) {
            IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
            provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
        } else {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    private BestNode findBestNode(ISelection selection) {
        if (!this.view.isLinkingEnabled()) {
            return null;
        }
        CommonViewer viewer = this.view.getCurrentViewer();
        if (viewer == null) {
            return null;
        }
        IStructuredContentProvider contentProvider = (IStructuredContentProvider)viewer.getContentProvider();
        if (contentProvider == null || selection == null || selection.isEmpty() || !(selection instanceof ITextSelection)) {
            return null;
        }
        Object[] elements = contentProvider.getElements(viewer.getInput());
        IFile currentFile = this.view.getCurrentTernPage().getCurrentFile();
        if (elements != null) {
            Object elt = null;
            IJSNode bestNode = null;
            int i = 0;
            while (i < elements.length) {
                elt = elements[i];
                if (elt instanceof IJSNode && (bestNode = this.findBestNode((IJSNode)elt, (ITextSelection)selection, currentFile)) != null) {
                    return new BestNode(bestNode, viewer);
                }
                ++i;
            }
        }
        return null;
    }

    private IJSNode findBestNode(IJSNode node, ITextSelection selection, IFile currentFile) {
        int start = selection.getOffset();
        int end = start + selection.getLength();
        if (node.getStart() != null && node.getStart() <= (long)start && node.getEnd() >= (long)end) {
            IJSNode child;
            if (!StringUtils.isEmpty((String)node.getFile()) && currentFile != null && !currentFile.equals((Object)EditorUtils.getFile(node))) {
                return null;
            }
            if (node.isContainer() && (child = this.findBestNodeInChildren(node, selection, currentFile)) != null) {
                return child;
            }
            return node;
        }
        return this.findBestNodeInChildren(node, selection, currentFile);
    }

    protected IJSNode findBestNodeInChildren(IJSNode node, ITextSelection selection, IFile currentFile) {
        if (node.hasChidren()) {
            for (IJSNode child : node.getChildren()) {
                IJSNode c = this.findBestNode(child, selection, currentFile);
                if (c == null) continue;
                return c;
            }
        }
        return null;
    }

    public void dispose() {
        if (this.textEditor != null) {
            this.uninstall(this.textEditor.getSelectionProvider());
        }
        super.cancel();
    }

    private class BestNode {
        public final IJSNode node;
        public final CommonViewer viewer;

        public BestNode(IJSNode node, CommonViewer viewer) {
            this.node = node;
            this.viewer = viewer;
        }
    }
}

