/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.jface.images;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import tern.eclipse.jface.images.TernImagesRegistry;

public class TernCompositeImageDescriptor
extends CompositeImageDescriptor {
    private static final Point SMALL_SIZE = new Point(16, 16);
    private ImageDescriptor fBaseImage;
    private String typeKey;
    private Point fSize;

    public TernCompositeImageDescriptor(ImageDescriptor baseImage, String typeKey) {
        this(baseImage, typeKey, SMALL_SIZE);
    }

    public TernCompositeImageDescriptor(ImageDescriptor baseImage, String typeKey, Point size) {
        this.fBaseImage = baseImage;
        Assert.isNotNull((Object)this.fBaseImage);
        this.typeKey = typeKey;
        this.fSize = size;
        Assert.isNotNull((Object)this.fSize);
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = this.getImageData(this.fBaseImage);
        this.drawImage(bg, 0, 0);
        this.drawBottomRight();
    }

    private void drawBottomRight() {
        Point size = this.getSize();
        Point pos = new Point(size.x, size.y);
        this.addBottomRightImage(TernImagesRegistry.getImageDescriptor(TernImagesRegistry.getOvr(this.typeKey)), pos);
    }

    private void addBottomRightImage(ImageDescriptor desc, Point pos) {
        ImageData data = this.getImageData(desc);
        int x = pos.x - data.width;
        int y = pos.y - data.height;
        if (x >= 0 && y >= 0) {
            this.drawImage(data, x, y);
            pos.x = x;
        }
    }

    protected Point getSize() {
        return this.fSize;
    }

    private ImageData getImageData(ImageDescriptor descriptor) {
        ImageData data = descriptor.getImageData();
        if (data == null) {
            data = DEFAULT_IMAGE_DATA;
        }
        return data;
    }
}

