/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.jface.text;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;

public class HoverLocationListener
extends LocationAdapter {
    public static final String HTTP_PROTOCOL = "http";
    public static final String TERN_FILE_PROTOCOL = "tern-file:";
    public static final String TERN_DEFINITION_PROTOCOL = "tern-definition:";
    private final BrowserInformationControl control;

    public HoverLocationListener(BrowserInformationControl control) {
        this.control = control;
    }

    public void changing(LocationEvent event) {
        String loc = event.location;
        if ("about:blank".equals(loc)) {
            this.handleTextSet();
            return;
        }
        event.doit = false;
        if (loc.startsWith(TERN_FILE_PROTOCOL)) {
            this.handleTernFileLink(loc);
            return;
        }
        if (loc.startsWith(TERN_DEFINITION_PROTOCOL)) {
            this.handleTernDefinitionLink(loc);
            return;
        }
        if (loc.startsWith("about:")) {
            return;
        }
        if (loc.startsWith(HTTP_PROTOCOL)) {
            try {
                this.handleHttpLink(new URL(loc), event.display);
                return;
            }
            catch (MalformedURLException malformedURLException) {}
        }
    }

    protected void handleTernFileLink(String loc) {
        this.control.notifyDelayedInputChange(null);
        this.control.dispose();
    }

    protected void handleTernDefinitionLink(String loc) {
        this.control.notifyDelayedInputChange(null);
        this.control.dispose();
    }

    private void handleTextSet() {
    }

    private void handleHttpLink(URL url, Display display) {
        this.control.notifyDelayedInputChange(null);
        this.control.dispose();
        Program.launch((String)url.toExternalForm());
    }

    public static void addLinkListener(BrowserInformationControl control) {
        HoverLocationListener.addLinkListener(control, (LocationListener)new HoverLocationListener(control));
    }

    public static void addLinkListener(BrowserInformationControl control, LocationListener listener) {
        control.addLocationListener(listener);
    }
}

