/*
 * Decompiled with CFR 0.152.
 */
package tern.server.nodejs.process;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import tern.TernException;
import tern.server.nodejs.NodejsTernHelper;
import tern.server.nodejs.process.INodejsLaunchConfiguration;
import tern.server.nodejs.process.INodejsProcess;
import tern.server.nodejs.process.INodejsProcessListener;
import tern.server.nodejs.process.NodejsProcessException;

public abstract class AbstractNodejsProcess
implements INodejsProcess {
    protected final File nodejsBaseDir;
    protected final File projectDir;
    private INodejsLaunchConfiguration launchConfiguration;
    private Integer port;
    private long elapsedSartTime = 0L;
    protected final List<INodejsProcessListener> listeners;
    protected final Object lock = new Object();
    private boolean hasError;

    public AbstractNodejsProcess(File nodejsBaseDir, File projectDir) throws TernException {
        this.projectDir = projectDir;
        this.nodejsBaseDir = nodejsBaseDir;
        this.listeners = new ArrayList<INodejsProcessListener>();
        this.hasError = false;
    }

    @Override
    public int start(long timeout, int testNumber) throws NodejsProcessException, InterruptedException {
        if (!this.isStarted()) {
            this.start();
        }
        this.waitOnStartNodejs(timeout, testNumber);
        return this.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitOnStartNodejs(long timeout, int testNumber) throws InterruptedException, NodejsProcessException {
        if (this.port == null) {
            if (!this.hasError) {
                int i = 0;
                while (i < testNumber) {
                    Object object = this.lock;
                    synchronized (object) {
                        this.lock.wait(timeout);
                        if (this.port != null || this.hasError) {
                            break;
                        }
                    }
                    ++i;
                }
            }
            if (this.port == null) {
                throw new NodejsProcessException("Cannot start node process.");
            }
        }
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    protected void setPort(Integer port) {
        this.port = port;
    }

    @Override
    public File getProjectDir() {
        return this.projectDir;
    }

    @Override
    public long getElapsedStartTime() {
        return this.elapsedSartTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProcessListener(INodejsProcessListener listener) {
        List<INodejsProcessListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProcessListener(INodejsProcessListener listener) {
        List<INodejsProcessListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyCreateProcess(List<String> commands, File projectDir) {
        List<INodejsProcessListener> list = this.listeners;
        synchronized (list) {
            for (INodejsProcessListener listener : this.listeners) {
                listener.onCreate(this, commands, projectDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyStartProcess(long startTime) {
        this.elapsedSartTime = NodejsTernHelper.getElapsedTimeInMs(startTime);
        List<INodejsProcessListener> list = this.listeners;
        synchronized (list) {
            for (INodejsProcessListener listener : this.listeners) {
                listener.onStart(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyStopProcess() {
        List<INodejsProcessListener> list = this.listeners;
        synchronized (list) {
            for (INodejsProcessListener listener : this.listeners) {
                listener.onStop(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyDataProcess(String line) {
        List<INodejsProcessListener> list = this.listeners;
        synchronized (list) {
            for (INodejsProcessListener listener : this.listeners) {
                listener.onData(this, line);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyErrorProcess(String line) {
        this.hasError = true;
        List<INodejsProcessListener> list = this.listeners;
        synchronized (list) {
            for (INodejsProcessListener listener : this.listeners) {
                listener.onError(this, line);
            }
        }
    }

    protected List<String> createNodejsArgs() throws NodejsProcessException {
        return this.getLaunchConfiguration().createNodeArgs();
    }

    protected INodejsLaunchConfiguration getLaunchConfiguration() throws NodejsProcessException {
        if (this.launchConfiguration == null) {
            throw new NodejsProcessException("Launch configuration cannot be null.");
        }
        return this.launchConfiguration;
    }

    @Override
    public void setLaunchConfiguration(INodejsLaunchConfiguration launchConfiguration) {
        this.launchConfiguration = launchConfiguration;
    }
}

