/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.unit;

import com.jrockit.mc.common.unit.IQuantity;
import com.jrockit.mc.common.unit.LinearKindOfQuantity;
import com.jrockit.mc.common.unit.LinearQuantity;
import com.jrockit.mc.common.unit.LinearUnit;
import com.jrockit.mc.common.util.Messages;
import java.text.MessageFormat;

public abstract class QuantityConversionException
extends Exception {
    private static final long serialVersionUID = 1L;
    protected final Problem problem;
    protected final String badString;

    public static QuantityConversionException unparsable(String badString, String prototype) {
        return new Fixed(Problem.UNPARSEABLE, badString, prototype);
    }

    public static QuantityConversionException noUnit(String badString, String prototype) {
        return new Fixed(Problem.NO_UNIT, badString, prototype);
    }

    public static QuantityConversionException unknownUnit(String badString, String prototype) {
        return new Fixed(Problem.UNKNOWN_UNIT, badString, prototype);
    }

    public static QuantityConversionException tooLow(String badString, String min) {
        return new Fixed(Problem.TOO_LOW, badString, min);
    }

    public static QuantityConversionException tooHigh(String badString, String max) {
        return new Fixed(Problem.TOO_HIGH, badString, max);
    }

    public static QuantityConversionException belowPrecision(String badString, String ulp) {
        return new Fixed(Problem.TOO_SMALL_MAGNITUDE, badString, ulp);
    }

    public static QuantityConversionException unparsable(String badString, IQuantity prototype) {
        return new Quantity(Problem.UNPARSEABLE, badString, prototype);
    }

    public static QuantityConversionException noUnit(String badString, IQuantity prototype) {
        return new Quantity(Problem.NO_UNIT, badString, prototype);
    }

    public static QuantityConversionException unknownUnit(String badString, IQuantity prototype) {
        return new Quantity(Problem.UNKNOWN_UNIT, badString, prototype);
    }

    public static <Q extends IQuantity> QuantityConversionException tooLow(Q badValue, Q min) {
        return new Quantity(Problem.TOO_LOW, badValue, min);
    }

    public static <Q extends IQuantity> QuantityConversionException tooHigh(Q badValue, Q max) {
        return new Quantity(Problem.TOO_HIGH, badValue, max);
    }

    public static <Q extends IQuantity> QuantityConversionException belowPrecision(Q badValue, Q ulp) {
        return new Quantity(Problem.TOO_SMALL_MAGNITUDE, badValue, ulp);
    }

    protected QuantityConversionException(Problem problem, String badString) {
        this.problem = problem;
        this.badString = badString;
    }

    public Problem getProblem() {
        return this.problem;
    }

    public String getBadString() {
        return this.badString;
    }

    public abstract String getPersistablePrototype();

    public abstract String getHumanPrototype();

    @Override
    public String getMessage() {
        return MessageFormat.format(this.problem.logMsg, this.badString, this.getPersistablePrototype());
    }

    @Override
    public String getLocalizedMessage() {
        return MessageFormat.format(this.problem.localizedMsg, this.badString, this.getHumanPrototype());
    }

    @Override
    public String toString() {
        String s = this.getClass().getName();
        String message = this.getMessage();
        return message != null ? String.valueOf(s) + ": " + message : s;
    }

    public static class Fixed
    extends QuantityConversionException {
        private static final long serialVersionUID = 1L;
        protected final String prototype;

        public Fixed(Problem problem, String badString, String prototype) {
            super(problem, badString);
            this.prototype = prototype;
        }

        @Override
        public String getPersistablePrototype() {
            return this.prototype;
        }

        @Override
        public String getHumanPrototype() {
            return this.prototype;
        }
    }

    public static enum Problem {
        UNPARSEABLE("Unparsable {0}, expected {1}", "QuantityConversionException_UNPARSEABLE_MSG"),
        NO_UNIT("No unit in {0}, expected {1}", "QuantityConversionException_NO_UNIT_MSG"),
        UNKNOWN_UNIT("Unknown unit in {0}, expected {1}", "QuantityConversionException_UNKNOWN_UNIT_MSG"),
        TOO_LOW("Value {0} too low, min is {1}", "QuantityConversionException_TOO_LOW_MSG"),
        TOO_HIGH("Value {0} too high, max is {1}", "QuantityConversionException_TOO_HIGH_MSG"),
        TOO_SMALL_MAGNITUDE("Value {0} below precision, smallest unit is {1}", "QuantityConversionException_TOO_SMALL_MAGNITUDE_MSG");

        public final String logMsg;
        public final String localizedMsg;

        private Problem(String logMsg, String localizedMsgKey) {
            this.logMsg = logMsg;
            this.localizedMsg = Messages.getString(localizedMsgKey);
        }
    }

    public static class Quantity
    extends QuantityConversionException {
        private static final long serialVersionUID = 1L;
        protected final IQuantity badQuantity;
        protected final IQuantity prototype;

        public Quantity(Problem problem, String badString, IQuantity prototype) {
            super(problem, badString);
            this.badQuantity = null;
            this.prototype = prototype;
        }

        public Quantity(Problem problem, IQuantity badQuantity, IQuantity prototype) {
            super(problem, null);
            this.badQuantity = badQuantity;
            this.prototype = prototype;
        }

        @Override
        public String getMessage() {
            if (this.badQuantity != null) {
                return MessageFormat.format(this.problem.logMsg, this.badQuantity.persistableString(), this.getPersistablePrototype());
            }
            return super.getMessage();
        }

        @Override
        public String getLocalizedMessage() {
            if (this.badQuantity != null) {
                if (this.badQuantity instanceof LinearQuantity) {
                    String protoString = Quantity.readableProto((LinearQuantity)this.prototype, ((LinearQuantity)this.badQuantity).getUnit());
                    return MessageFormat.format(this.problem.localizedMsg, this.badQuantity.displayUsing("exact"), protoString);
                }
                return MessageFormat.format(this.problem.localizedMsg, this.badQuantity.displayUsing("exact"), this.prototype.displayUsing("exact"));
            }
            return super.getLocalizedMessage();
        }

        private static String readableProto(LinearQuantity prototype, LinearUnit userUnit) {
            LinearUnit exactUnit = prototype.getUnit();
            StringBuilder out = new StringBuilder(prototype.displayUsing("exact"));
            if (!userUnit.equals(exactUnit)) {
                LinearKindOfQuantity kindOfQuantity = exactUnit.getContentType();
                LinearUnit autoUnit = kindOfQuantity.getPreferredUnit(prototype, 1.0, 1000.0);
                if (!userUnit.equals(autoUnit)) {
                    out.append(" \u2248 ");
                    out.append(LinearKindOfQuantity.AutoFormatter.formatInUnit(prototype, userUnit, 3));
                }
                out.append(" \u2248 ");
                out.append(LinearKindOfQuantity.AutoFormatter.formatInUnit(prototype, autoUnit, 3));
            }
            return out.toString();
        }

        @Override
        public String getPersistablePrototype() {
            return this.prototype.persistableString();
        }

        @Override
        public String getHumanPrototype() {
            return this.prototype.interactiveFormat();
        }
    }
}

