/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.util;

import com.jrockit.mc.common.util.Filter;
import java.util.Iterator;

public final class FilteredIterator<T>
implements Iterator<T> {
    private final Iterator<T> m_iterator;
    private final Filter<? super T> m_filter;
    private T m_next;

    public FilteredIterator(Iterator<T> iterator, Filter<? super T> filter) {
        this.m_iterator = iterator;
        this.m_filter = filter;
        this.skipToNext();
    }

    private void skipToNext() {
        while (this.m_iterator.hasNext()) {
            T object = this.m_iterator.next();
            if (!this.m_filter.accept(object)) continue;
            this.m_next = object;
            return;
        }
        this.m_next = null;
    }

    @Override
    public boolean hasNext() {
        return this.m_next != null;
    }

    @Override
    public T next() {
        T event = this.m_next;
        this.skipToNext();
        return event;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("");
    }
}

