/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.version;

public class JavaVersion {
    private final int[] versionNumbers;
    public static final int UNKNOWN = -1;

    public JavaVersion(String version) {
        String[] numbers = version.split("[\\._]");
        this.versionNumbers = new int[numbers.length];
        int i = 0;
        while (i < numbers.length) {
            this.versionNumbers[i] = this.parseNumber(i, numbers);
            ++i;
        }
    }

    public JavaVersion(int ... versionNumbers) {
        this.versionNumbers = versionNumbers;
    }

    private int parseNumber(int index, String[] numbers) {
        if (index + 1 > numbers.length) {
            return -1;
        }
        StringBuilder numberStringBuilder = new StringBuilder();
        int i = 0;
        while (i < numbers[index].length()) {
            char c = numbers[index].charAt(i);
            if (!Character.isDigit(c)) break;
            numberStringBuilder.append(c);
            ++i;
        }
        try {
            return Integer.parseInt(numberStringBuilder.toString());
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        int i = 0;
        while (i < this.versionNumbers.length) {
            result = 31 * result + this.versionNumbers[i];
            ++i;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaVersion other = (JavaVersion)obj;
        return this.isGreaterOrEqualThan(other) && other.isGreaterOrEqualThan(this);
    }

    public boolean isGreaterOrEqualThan(JavaVersion otherVersion) {
        int maxLength = Math.max(this.versionNumbers.length, otherVersion.versionNumbers.length);
        int i = 0;
        while (i < maxLength) {
            int otherNumber;
            int thisNumber = this.versionNumbers.length > i ? this.versionNumbers[i] : 0;
            int n = otherNumber = otherVersion.versionNumbers.length > i ? otherVersion.versionNumbers[i] : 0;
            if (thisNumber != otherNumber) {
                return thisNumber > otherNumber;
            }
            ++i;
        }
        return true;
    }
}

