/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.information;

import com.jrockit.mc.components.ui.base.AbstractUIComponent;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.spi.Expansion;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.spi.IView;
import com.jrockit.mc.flightrecorder.ui.common.IEventConsumer;
import com.jrockit.mc.flightrecorder.ui.common.SimpleView;
import com.jrockit.mc.flightrecorder.ui.common.StartService;
import com.jrockit.mc.flightrecorder.ui.components.EventTypeAcceptor;
import com.jrockit.mc.flightrecorder.ui.components.dial.DialDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.fields.EventFieldToolkit;
import com.jrockit.mc.flightrecorder.ui.components.information.InformationDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.information.InformationDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.components.information.InformationModelBuilder;
import com.jrockit.mc.flightrecorder.ui.components.inputs.Role;
import com.jrockit.mc.flightrecorder.ui.components.range.INavigatorSelectionChangeListener;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.views.types.ITypeVisibilitySupport;
import com.jrockit.mc.flightrecorder.util.TimeRange;
import com.jrockit.mc.ui.accessibility.SimpleTraverseListener;
import com.jrockit.mc.ui.fields.FieldRenderer;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.model.fields.Field;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class InformationComponent
extends AbstractUIComponent
implements INavigatorSelectionChangeListener,
IEventConsumer,
ITypeVisibilitySupport {
    private static final String INFORMATION_DESCRIPTOR_REPOSITORY = "informationDescriptorRepository";
    private FieldRenderer m_renderer;

    public boolean initialize(IServiceLocator serviceLocator) {
        boolean initOk = super.initialize(serviceLocator);
        InformationModelBuilder<InformationDescriptor> informationModelBuilder = new InformationModelBuilder<InformationDescriptor>(serviceLocator, this.getInformationDescriptors(), this.getComponentDescriptor(), false);
        informationModelBuilder.setEventView(this.createView());
        informationModelBuilder.addObserver(new Observer(){

            @Override
            public void update(Observable observable, Object arg) {
                if (InformationComponent.this.m_renderer != null) {
                    InformationComponent.this.sceduleFieldUpdate((Map)InformationComponent.this.getBuilder().getModel(), InformationComponent.this.getBuilder().getView().getRange());
                }
            }
        });
        serviceLocator.registerService(informationModelBuilder);
        return initOk;
    }

    public Control createPart(Composite parent) {
        this.m_renderer = new FieldRenderer(parent, this.getFormToolkit(), null);
        this.m_renderer.render(this.createFields());
        Composite client = this.m_renderer.getClient();
        client.addTraverseListener((TraverseListener)new SimpleTraverseListener());
        return client;
    }

    @Override
    public void onChange(long startTime, long endTime) {
        if (this.getRepository().getRole() == Role.INDEPENDENT) {
            this.getBuilder().getView().setRange((ITimeRange)new TimeRange(startTime, endTime));
            this.markDirty();
        }
    }

    public boolean dispose(IServiceLocator serviceLocator) {
        this.getBuilder().stop();
        return super.dispose(serviceLocator);
    }

    private List<InformationDescriptor> getInformationDescriptors() {
        return this.getRepository().getInformationDescriptors();
    }

    private Field[] createFields() {
        List<InformationDescriptor> informationDescriptors = this.getInformationDescriptors();
        int index = 0;
        Field[] fields = new Field[informationDescriptors.size()];
        for (InformationDescriptor infoDescriptor : informationDescriptors) {
            fields[index] = EventFieldToolkit.createField(infoDescriptor, infoDescriptor.getAttributeIdentifier(), index);
            ++index;
        }
        return fields;
    }

    private InformationDescriptorRepository getRepository() {
        return (InformationDescriptorRepository)this.getComponentSettings().getChildObject(INFORMATION_DESCRIPTOR_REPOSITORY, InformationDescriptorRepository.class);
    }

    private FlightRecording getFlightRecording() {
        return (FlightRecording)this.getServiceLocator().getService(FlightRecording.class);
    }

    @Override
    public void consumeEvents(Iterable<IEvent> events, Role source) {
        if (this.getRepository().getRole().listensTo(source) && this.getBuilder().getView() instanceof SimpleView) {
            SimpleView s = (SimpleView)this.getBuilder().getView();
            s.setEvents(events);
            this.getBuilder().scheduleRebuild();
        }
    }

    protected InformationModelBuilder<DialDescriptor> getBuilder() {
        return (InformationModelBuilder)this.getServiceLocator().getService(InformationModelBuilder.class);
    }

    private void sceduleFieldUpdate(final Map<String, Object> result, final ITimeRange range) {
        if (result != null) {
            DisplayToolkit.safeAsyncExec((Widget)this.m_renderer.getClient(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    InformationComponent.this.updateFields(result, range);
                }
            });
        }
    }

    public void refresh() {
        this.getBuilder().scheduleRebuild();
    }

    private void updateFields(Map<String, Object> result, ITimeRange range) {
        List<InformationDescriptor> desc = this.getInformationDescriptors();
        Object[] values = result.values().toArray();
        Object[] data = new Object[values.length];
        int n = 0;
        while (n < desc.size()) {
            data[n] = values[n];
            ++n;
        }
        this.m_renderer.updateFields(data, (Object)this.getFlightRecording());
    }

    protected void initializeUI() {
        super.initializeUI();
        this.getBuilder().getView().setRange((ITimeRange)new TimeRange(this.getStartService().getStartTimestamp(), this.getStartService().getEndTimestamp()));
        this.getBuilder().setOperativeSetEnabled(false);
        EventTypeAcceptor eta = new EventTypeAcceptor(this.getServiceLocator(), this.getRepository().getEventTypeDescriptorRepository());
        this.getBuilder().getView().setEventTypes(eta.getAcceptedSet());
    }

    private IView createView() {
        if (this.getRepository().getRole() == Role.INDEPENDENT) {
            IView v = this.getFlightRecording().createView();
            if (this.getRepository().getExpandedRange().booleanValue()) {
                v.setExpansion(Expansion.EXPANDED);
            }
            return v;
        }
        return new SimpleView();
    }

    private StartService getStartService() {
        return (StartService)this.getServiceLocator().getService(StartService.class);
    }

    @Override
    public EventTypeDescriptorRepository getEventTypeDescriptorRepository() {
        return this.getRepository().getEventTypeDescriptorRepository();
    }
}

